/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.configuration.DbSchemaCreator;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;

public class TaskanaEngineConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineConfiguration.class);
    private static final String USER_NAME = "sa";
    private static final String USER_PASSWORD = "sa";
    private static final String JDBC_H2_MEM_TASKANA = "jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0";
    private static final String H2_DRIVER = "org.h2.Driver";
    private static final String TASKANA_PROPERTIES = "/taskana.properties";
    private static final String TASKANA_ROLES_SEPARATOR = "|";
    private static final String TASKANA_DOMAINS_PROPERTY = "taskana.domains";
    protected String propertiesFileName = "/taskana.properties";
    protected DataSource dataSource;
    protected DbSchemaCreator dbScriptRunner;
    protected String rolesSeparator = "|";
    protected Map<TaskanaRole, Set<String>> roleMap = new HashMap<TaskanaRole, Set<String>>();
    protected boolean securityEnabled = true;
    protected boolean useManagedTransactions;
    private boolean germanPublicHolidaysEnabled;
    private List<LocalDate> customHolidays;
    protected List<String> domains = new ArrayList<String>();

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions) throws SQLException {
        this(dataSource, useManagedTransactions, true);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled) throws SQLException {
        this(dataSource, useManagedTransactions, securityEnabled, null, null);
    }

    public TaskanaEngineConfiguration(DataSource dataSource, boolean useManagedTransactions, boolean securityEnabled, String propertiesFileName, String rolesSeparator) throws SQLException {
        this.useManagedTransactions = useManagedTransactions;
        this.securityEnabled = securityEnabled;
        if (propertiesFileName != null) {
            this.propertiesFileName = propertiesFileName;
        }
        if (rolesSeparator != null) {
            this.rolesSeparator = rolesSeparator;
        }
        this.initTaskanaProperties(this.propertiesFileName, this.rolesSeparator);
        this.dataSource = dataSource != null ? dataSource : TaskanaEngineConfiguration.createDefaultDataSource();
        this.dbScriptRunner = new DbSchemaCreator(this.dataSource);
        this.dbScriptRunner.run();
    }

    public void initTaskanaProperties(String propertiesFile, String rolesSeparator) {
        LOGGER.debug("Reading taskana configuration from {} with role separator {}", (Object)propertiesFile, (Object)rolesSeparator);
        Properties props = this.readPropertiesFromFile(propertiesFile);
        this.initTaskanaRoles(props, rolesSeparator);
        this.initDomains(props);
    }

    private void initDomains(Properties props) {
        String domainNames = props.getProperty(TASKANA_DOMAINS_PROPERTY);
        if (domainNames != null && !domainNames.isEmpty()) {
            StringTokenizer st = new StringTokenizer(domainNames, ",");
            while (st.hasMoreTokens()) {
                this.domains.add(st.nextToken().trim().toUpperCase());
            }
        }
        LOGGER.debug("Configured domains: {}", this.domains);
    }

    private void initTaskanaRoles(Properties props, String rolesSeparator) {
        List validPropertyNames = Arrays.stream(TaskanaRole.values()).map(TaskanaRole::getPropertyName).collect(Collectors.toList());
        for (Object obj : props.keySet()) {
            String propertyName = (String)obj;
            if (!validPropertyNames.contains(propertyName.toLowerCase().trim())) continue;
            String propertyValue = props.getProperty(propertyName);
            HashSet<String> roleMemberSet = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(propertyValue, rolesSeparator);
            while (st.hasMoreTokens()) {
                String token = st.nextToken().toLowerCase().trim();
                roleMemberSet.add(token);
            }
            TaskanaRole key = TaskanaRole.fromPropertyName(propertyName);
            if (key != null) {
                this.roleMap.put(key, roleMemberSet);
                continue;
            }
            LOGGER.error("Internal System error when processing role property {}.", (Object)propertyName);
            throw new SystemException("Internal System error when processing role property " + propertyName);
        }
        this.ensureRoleMapIsFullyInitialized();
        this.roleMap.forEach((k, v) -> LOGGER.debug("Found Taskana RoleConfig {} : {} ", (Object)k, (Object)LoggerUtils.setToString(v)));
    }

    private Properties readPropertiesFromFile(String propertiesFile) {
        Properties props = new Properties();
        boolean loadFromClasspath = this.loadFromClasspath(propertiesFile);
        try {
            if (loadFromClasspath) {
                InputStream inputStream = this.getClass().getResourceAsStream(propertiesFile);
                if (inputStream == null) {
                    LOGGER.error("taskana properties file {} was not found on classpath.", (Object)propertiesFile);
                } else {
                    props.load(new InputStreamReader(inputStream));
                    LOGGER.debug("Role properties were loaded from file {} from classpath.", (Object)propertiesFile);
                }
            } else {
                props.load(new FileInputStream(propertiesFile));
                LOGGER.debug("Role properties were loaded from file {}.", (Object)propertiesFile);
            }
        }
        catch (IOException e) {
            LOGGER.error("caught IOException when processing properties file {}.", (Object)propertiesFile);
            throw new SystemException("internal System error when processing properties file " + propertiesFile);
        }
        return props;
    }

    private boolean loadFromClasspath(String propertiesFile) {
        boolean loadFromClasspath = true;
        File f = new File(propertiesFile);
        if (f.exists() && !f.isDirectory()) {
            loadFromClasspath = false;
        }
        return loadFromClasspath;
    }

    private void ensureRoleMapIsFullyInitialized() {
        Arrays.stream(TaskanaRole.values()).forEach(role -> {
            Set cfr_ignored_0 = this.roleMap.putIfAbsent((TaskanaRole)((Object)role), new HashSet());
        });
    }

    public static DataSource createDefaultDataSource() {
        LOGGER.info("No datasource is provided. A inmemory db is used: 'org.h2.Driver', 'jdbc:h2:mem:taskana;IGNORECASE=TRUE;LOCK_MODE=0', 'sa', 'sa'");
        return TaskanaEngineConfiguration.createDatasource(H2_DRIVER, JDBC_H2_MEM_TASKANA, "sa", "sa");
    }

    public TaskanaEngine buildTaskanaEngine() {
        return TaskanaEngineImpl.createTaskanaEngine(this);
    }

    public static DataSource createDatasource(String driver, String jdbcUrl, String username, String password) {
        return new PooledDataSource(driver, jdbcUrl, username, password);
    }

    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    public DataSource getDatasource() {
        return this.dataSource;
    }

    public boolean getUseManagedTransactions() {
        return this.useManagedTransactions;
    }

    public String getPropertiesFileName() {
        return this.propertiesFileName;
    }

    public void setPropertiesFileName(String propertiesFileName) {
        this.propertiesFileName = propertiesFileName;
    }

    public String getPropertiesSeparator() {
        return this.rolesSeparator;
    }

    public void setPropertiesSeparator(String propertiesSeparator) {
        this.rolesSeparator = propertiesSeparator;
    }

    public boolean isGermanPublicHolidaysEnabled() {
        return this.germanPublicHolidaysEnabled;
    }

    public void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        this.germanPublicHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public List<LocalDate> getCustomHolidays() {
        return this.customHolidays;
    }

    public void setCustomHolidays(List<LocalDate> customHolidays) {
        this.customHolidays = customHolidays;
    }

    public Map<TaskanaRole, Set<String>> getRoleMap() {
        return this.roleMap;
    }

    public void setRoleMap(Map<TaskanaRole, Set<String>> roleMap) {
        this.roleMap = roleMap;
    }

    public List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public static boolean shouldUseLowerCaseForAccessIds() {
        return true;
    }
}

