/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.impl.BulkOperationResults;
import pro.taskana.impl.Job;
import pro.taskana.impl.SingleJobExecutor;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.mappings.JobMapper;

public class JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private TaskanaEngineImpl taskanaEngine;
    private JobMapper jobMapper;

    public JobRunner(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.jobMapper = (JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkOperationResults<String, Exception> runJobs() {
        LOGGER.info("entry to runJobs()");
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        try {
            this.taskanaEngine.openConnection();
            List<Job> jobs = this.jobMapper.findJobsToRun();
            for (Job job : jobs) {
                BulkOperationResults<String, Exception> log = this.runSingleJob(job);
                bulkLog.addAllErrors(log);
            }
            BulkOperationResults<String, Exception> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.info("exit from runJobs(). Returning result {} ", bulkLog);
        }
    }

    private BulkOperationResults<String, Exception> runSingleJob(Job job) {
        LOGGER.debug("entry to runSingleJob(job = {})", (Object)job);
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        if (Job.State.READY.equals((Object)job.getState())) {
            job.setStarted(Instant.now());
        }
        job.setState(Job.State.RUNNING);
        this.jobMapper.update(job);
        try {
            SingleJobExecutor executor = (SingleJobExecutor)Class.forName(job.getExecutor()).newInstance();
            bulkLog = executor.runSingleJob(job, this.taskanaEngine);
        }
        catch (Exception e) {
            bulkLog.addError("JobId:" + job.getJobId(), e);
            job.setCompleted(Instant.now());
            job.setState(Job.State.FAILED);
            this.jobMapper.update(job);
            return bulkLog;
        }
        job.setCompleted(Instant.now());
        job.setState(Job.State.COMPLETED);
        this.jobMapper.update(job);
        LOGGER.debug("exit from runSingleJob");
        if (bulkLog.containsErrors()) {
            LOGGER.error("Errors occurred when running job {}.", (Object)job);
            for (String id : bulkLog.getFailedIds()) {
                LOGGER.error(id + bulkLog.getErrorForId(id));
            }
        }
        return bulkLog;
    }
}

