/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.impl.BulkOperationResults;
import pro.taskana.impl.Job;
import pro.taskana.impl.SingleJobExecutor;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.AttachmentMapper;
import pro.taskana.mappings.ClassificationMapper;
import pro.taskana.mappings.TaskMapper;

public class TaskUpdateOnClassificationChangeExecutor
implements SingleJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    public static final String CLASSIFICATION_ID = "classificationId";
    public static final String PRIORITY_CHANGED = "priorityChanged";
    public static final String SERVICE_LEVEL_CHANGED = "serviceLevelChanged";
    private TaskanaEngineImpl taskanaEngine;
    private Job job;
    private String classificationId;
    private boolean priorityChanged;
    private boolean serviceLevelChanged;
    private TaskMapper taskMapper;
    private ClassificationMapper classificationMapper;
    private AttachmentMapper attachmentMapper;

    @Override
    public BulkOperationResults<String, Exception> runSingleJob(Job job, TaskanaEngineImpl taskanaEngine) {
        this.job = job;
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = (TaskMapper)taskanaEngine.getSqlSession().getMapper(TaskMapper.class);
        this.classificationMapper = (ClassificationMapper)taskanaEngine.getSqlSession().getMapper(ClassificationMapper.class);
        this.attachmentMapper = (AttachmentMapper)taskanaEngine.getSqlSession().getMapper(AttachmentMapper.class);
        Map<String, String> args = job.getArguments();
        this.classificationId = args.get(CLASSIFICATION_ID);
        this.priorityChanged = Boolean.getBoolean(args.get(PRIORITY_CHANGED));
        this.serviceLevelChanged = Boolean.getBoolean(args.get(SERVICE_LEVEL_CHANGED));
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        bulkLog.addAllErrors(this.handleAffectedTasks());
        return bulkLog;
    }

    private BulkOperationResults<String, Exception> handleAffectedTasks() {
        List<TaskSummaryImpl> tasks = this.taskMapper.findTasksAffectedByClassificationChange(this.classificationId);
        List<String> taskIdsFromAttachments = this.attachmentMapper.findTaskIdsAffectedByClassificationChange(this.classificationId);
        List<String> filteredTaskIdsFromAttachments = this.taskMapper.filterTaskIdsForNotCompleted(taskIdsFromAttachments);
        HashSet<String> affectedTaskIds = new HashSet<String>(filteredTaskIdsFromAttachments);
        for (TaskSummaryImpl task : tasks) {
            affectedTaskIds.add(task.getTaskId());
        }
        LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)this.classificationId, (Object)LoggerUtils.setToString(affectedTaskIds));
        TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngine.getTaskService();
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        for (String taskId : affectedTaskIds) {
            try {
                bulkLog.addAllErrors(taskService.classificationChanged(taskId, this.classificationId));
            }
            catch (Exception e) {
                bulkLog.addError(taskId, e);
            }
        }
        return bulkLog;
    }
}

