/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.CustomField;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskState;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.DaysToWorkingDaysConverter;
import pro.taskana.impl.SelectedItem;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.report.impl.CategoryReport;
import pro.taskana.impl.report.impl.ClassificationReport;
import pro.taskana.impl.report.impl.CustomFieldValueReport;
import pro.taskana.impl.report.impl.DaysToWorkingDaysPreProcessor;
import pro.taskana.impl.report.impl.DetailedClassificationReport;
import pro.taskana.impl.report.impl.DetailedMonitorQueryItem;
import pro.taskana.impl.report.impl.MonitorQueryItem;
import pro.taskana.impl.report.impl.TaskQueryItem;
import pro.taskana.impl.report.impl.TaskStatusReport;
import pro.taskana.impl.report.impl.TimeIntervalColumnHeader;
import pro.taskana.impl.report.impl.WorkbasketLevelReport;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.TaskMonitorMapper;

public class TaskMonitorServiceImpl
implements TaskMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskMonitorMapper taskMonitorMapper;

    TaskMonitorServiceImpl(TaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
    }

    @Override
    public WorkbasketLevelReport getWorkbasketLevelReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException, NotAuthorizedException {
        return this.getWorkbasketLevelReport(workbasketIds, states, categories, domains, customField, customFieldValues, Collections.emptyList(), false);
    }

    @Override
    public WorkbasketLevelReport getWorkbasketLevelReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException, NotAuthorizedException {
        return this.getWorkbasketLevelReport(workbasketIds, states, categories, domains, customField, customFieldValues, columnHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketLevelReport getWorkbasketLevelReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders, boolean inWorkingDays) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbasketLevelReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, columnHeaders = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(columnHeaders), inWorkingDays});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            WorkbasketLevelReport report = new WorkbasketLevelReport(columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfWorkbaskets(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysPreProcessor(columnHeaders, inWorkingDays));
            WorkbasketLevelReport workbasketLevelReport = report;
            return workbasketLevelReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getWorkbasketLevelReport().");
        }
    }

    @Override
    public CategoryReport getCategoryReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException, NotAuthorizedException {
        return this.getCategoryReport(workbasketIds, states, categories, domains, customField, customFieldValues, Collections.emptyList(), false);
    }

    @Override
    public CategoryReport getCategoryReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException, NotAuthorizedException {
        return this.getCategoryReport(workbasketIds, states, categories, domains, customField, customFieldValues, columnHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CategoryReport getCategoryReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders, boolean inWorkingDays) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCategoryReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, reportLineItemDefinitions = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(columnHeaders), inWorkingDays});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            CategoryReport report = new CategoryReport(columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCategories(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysPreProcessor(columnHeaders, inWorkingDays));
            CategoryReport categoryReport = report;
            return categoryReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCategoryReport().");
        }
    }

    @Override
    public ClassificationReport getClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException, NotAuthorizedException {
        return this.getClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, Collections.emptyList(), false);
    }

    @Override
    public ClassificationReport getClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException, NotAuthorizedException {
        return this.getClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, columnHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassificationReport getClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders, boolean inWorkingDays) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getClassificationReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, columnHeaders = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(columnHeaders), inWorkingDays});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            ClassificationReport report = new ClassificationReport(columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfClassifications(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysPreProcessor(columnHeaders, inWorkingDays));
            ClassificationReport classificationReport = report;
            return classificationReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getClassificationReport().");
        }
    }

    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException, NotAuthorizedException {
        return this.getDetailedClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, Collections.emptyList(), false);
    }

    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException, NotAuthorizedException {
        return this.getDetailedClassificationReport(workbasketIds, states, categories, domains, customField, customFieldValues, columnHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetailedClassificationReport getDetailedClassificationReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders, boolean inWorkingDays) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getDetailedClassificationReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, columnHeaders = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(columnHeaders), inWorkingDays});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngineImpl.openConnection();
            this.configureDaysToWorkingDaysConverter();
            DetailedClassificationReport report = new DetailedClassificationReport(columnHeaders);
            List<DetailedMonitorQueryItem> detailedMonitorQueryItems = this.taskMonitorMapper.getTaskCountOfDetailedClassifications(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addItems(detailedMonitorQueryItems, new DaysToWorkingDaysPreProcessor(columnHeaders, inWorkingDays));
            DetailedClassificationReport detailedClassificationReport = report;
            return detailedClassificationReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getDetailedClassificationReport().");
        }
    }

    @Override
    public CustomFieldValueReport getCustomFieldValueReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues) throws InvalidArgumentException, NotAuthorizedException {
        return this.getCustomFieldValueReport(workbasketIds, states, categories, domains, customField, customFieldValues, Collections.emptyList(), false);
    }

    @Override
    public CustomFieldValueReport getCustomFieldValueReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException, NotAuthorizedException {
        return this.getCustomFieldValueReport(workbasketIds, states, categories, domains, customField, customFieldValues, columnHeaders, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomFieldValueReport getCustomFieldValueReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders, boolean inWorkingDays) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCustomFieldValueReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, columnHeaders = {}, inWorkingDays = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(columnHeaders), inWorkingDays});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            this.taskanaEngineImpl.openConnection();
            if (customField == null) {
                throw new InvalidArgumentException("CustomField can\u00b4t be used as NULL-Parameter");
            }
            this.configureDaysToWorkingDaysConverter();
            CustomFieldValueReport report = new CustomFieldValueReport(columnHeaders);
            List<MonitorQueryItem> monitorQueryItems = this.taskMonitorMapper.getTaskCountOfCustomFieldValues(workbasketIds, states, categories, domains, customField, customFieldValues);
            report.addItems(monitorQueryItems, new DaysToWorkingDaysPreProcessor(columnHeaders, inWorkingDays));
            CustomFieldValueReport customFieldValueReport = report;
            return customFieldValueReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCustomFieldValueReport().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCustomAttributeValuesForReport(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, List<String> classificationIds, List<String> excludedClassificationIds, Map<String, String> customAttributeFilter, String customAttributeName) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getCustomAttributeValuesForReport(workbasketIds = {}, states = {}, categories = {}, domains = {}, classificationIds = {}, excludedClassificationIds = {}, customAttributeName = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), LoggerUtils.listToString(classificationIds), LoggerUtils.listToString(excludedClassificationIds), customAttributeName});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            List<String> customAttributeValues;
            this.taskanaEngineImpl.openConnection();
            if (customAttributeName == null || customAttributeName.isEmpty()) {
                throw new InvalidArgumentException("customAttributeName must not be null.");
            }
            List<String> list = customAttributeValues = this.taskMonitorMapper.getCustomAttributeValuesForReport(workbasketIds, states, categories, domains, classificationIds, excludedClassificationIds, customAttributeFilter, "CUSTOM_" + customAttributeName);
            return list;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getCustomAttributeValuesForReport().");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTaskIdsForSelectedItems(List<String> workbasketIds, List<TaskState> states, List<String> categories, List<String> domains, List<String> classificationIds, List<String> excludedClassificationIds, CustomField customField, List<String> customFieldValues, List<TimeIntervalColumnHeader> columnHeaders, boolean inWorkingDays, List<SelectedItem> selectedItems, String dimension) throws InvalidArgumentException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getTaskIdsForSelectedItems(workbasketIds = {}, states = {}, categories = {}, domains = {}, customField = {}, customFieldValues = {}, columnHeaders = {}, inWorkingDays = {}, selectedItems = {}, dimension = {})", new Object[]{LoggerUtils.listToString(workbasketIds), LoggerUtils.listToString(states), LoggerUtils.listToString(categories), LoggerUtils.listToString(domains), LoggerUtils.listToString(classificationIds), LoggerUtils.listToString(excludedClassificationIds), customField, LoggerUtils.listToString(customFieldValues), LoggerUtils.listToString(columnHeaders), inWorkingDays, LoggerUtils.listToString(selectedItems), dimension});
        }
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            List<String> taskIds;
            this.taskanaEngineImpl.openConnection();
            if (columnHeaders == null) {
                throw new InvalidArgumentException("ColumnHeader must not be null.");
            }
            if (selectedItems == null || selectedItems.size() == 0) {
                throw new InvalidArgumentException("SelectedItems must not be null or empty.");
            }
            boolean joinWithAttachments = this.subKeyIsSet(selectedItems);
            if (joinWithAttachments && !"CLASSIFICATION_KEY".equals(dimension)) {
                throw new InvalidArgumentException("SubKeys are supported for dimension CLASSIFICATION_KEY only.");
            }
            this.configureDaysToWorkingDaysConverter();
            if (inWorkingDays) {
                selectedItems = this.convertWorkingDaysToDays(selectedItems, columnHeaders);
            }
            List<String> list = taskIds = this.taskMonitorMapper.getTaskIdsForSelectedItems(workbasketIds, states, categories, domains, classificationIds, excludedClassificationIds, customField, customFieldValues, dimension, selectedItems, joinWithAttachments);
            return list;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from getTaskIdsForSelectedItems().");
        }
    }

    @Override
    public TaskStatusReport getTaskStatusReport() throws NotAuthorizedException {
        return this.getTaskStatusReport(null, null);
    }

    @Override
    public TaskStatusReport getTaskStatusReport(List<String> domains) throws NotAuthorizedException {
        return this.getTaskStatusReport(domains, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatusReport getTaskStatusReport(List<String> domains, List<TaskState> states) throws NotAuthorizedException {
        this.taskanaEngineImpl.checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngineImpl.openConnection();
            List<TaskQueryItem> tasks = this.taskMonitorMapper.getTasksCountByState(domains, states);
            TaskStatusReport report = new TaskStatusReport(states);
            report.addItems(tasks);
            TaskStatusReport taskStatusReport = report;
            return taskStatusReport;
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
    }

    private List<SelectedItem> convertWorkingDaysToDays(List<SelectedItem> selectedItems, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException {
        DaysToWorkingDaysConverter instance = DaysToWorkingDaysConverter.initialize(columnHeaders);
        for (SelectedItem selectedItem : selectedItems) {
            selectedItem.setLowerAgeLimit(Collections.min(instance.convertWorkingDaysToDays(selectedItem.getLowerAgeLimit())));
            selectedItem.setUpperAgeLimit(Collections.max(instance.convertWorkingDaysToDays(selectedItem.getUpperAgeLimit())));
        }
        return selectedItems;
    }

    private void configureDaysToWorkingDaysConverter() {
        DaysToWorkingDaysConverter.setCustomHolidays(this.taskanaEngineImpl.getConfiguration().getCustomHolidays());
        DaysToWorkingDaysConverter.setGermanPublicHolidaysEnabled(this.taskanaEngineImpl.getConfiguration().isGermanPublicHolidaysEnabled());
    }

    private boolean subKeyIsSet(List<SelectedItem> selectedItems) {
        for (SelectedItem selectedItem : selectedItems) {
            if (selectedItem.getSubKey() == null || selectedItem.getSubKey().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

