/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.persistence;

import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTypeHandler
extends BaseTypeHandler<Map> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Map parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null && parameter.size() > 0) {
            LOGGER.debug("Input-Map before serializing: ", (Object)parameter);
            JSONObject jsonObj = new JSONObject(parameter);
            Clob content = ps.getConnection().createClob();
            content.setString(1L, jsonObj.toString());
            ps.setClob(i, content);
        } else {
            ps.setNull(i, 2004);
        }
    }

    public Map getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Clob fieldValue = rs.getClob(columnName);
        if (fieldValue != null) {
            return this.convertClobToMap(fieldValue);
        }
        return null;
    }

    public Map getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Clob fieldValue = rs.getClob(columnIndex);
        if (fieldValue != null) {
            return this.convertClobToMap(fieldValue);
        }
        return null;
    }

    public Map getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Clob fieldValue = cs.getClob(columnIndex);
        if (fieldValue != null) {
            return this.convertClobToMap(fieldValue);
        }
        return null;
    }

    private Map convertClobToMap(Clob fieldValue) throws SQLException {
        String content = fieldValue.getSubString(1L, (int)fieldValue.length());
        JSONObject jsonObj = new JSONObject(content);
        Map result = jsonObj.toMap();
        return result;
    }
}

