/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import pro.taskana.impl.report.ReportRow;
import pro.taskana.impl.report.impl.DetailedMonitorQueryItem;

public class DetailedReportRow
extends ReportRow<DetailedMonitorQueryItem> {
    private Map<String, ReportRow<DetailedMonitorQueryItem>> detailRows = new LinkedHashMap<String, ReportRow<DetailedMonitorQueryItem>>();
    private int columnCount;

    public DetailedReportRow(int columnCount) {
        super(columnCount);
        this.columnCount = columnCount;
    }

    public Map<String, ReportRow<DetailedMonitorQueryItem>> getDetailRows() {
        return this.detailRows;
    }

    @Override
    public void updateTotalValue(DetailedMonitorQueryItem item) {
        super.updateTotalValue(item);
        if (item.getAttachmentKey() != null) {
            this.detailRows.computeIfAbsent(item.getAttachmentKey(), s -> new ReportRow(this.columnCount)).updateTotalValue(item);
        } else {
            this.detailRows.computeIfAbsent("N/A", s -> new ReportRow(this.columnCount)).updateTotalValue(item);
        }
    }

    @Override
    public void addItem(DetailedMonitorQueryItem item, int index) {
        super.addItem(item, index);
        if (item.getAttachmentKey() != null) {
            this.detailRows.computeIfAbsent(item.getAttachmentKey(), s -> new ReportRow(this.columnCount)).addItem(item, index);
        } else {
            this.detailRows.computeIfAbsent("N/A", s -> new ReportRow(this.columnCount)).addItem(item, index);
        }
    }
}

