/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.mappings;

import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import pro.taskana.CustomField;
import pro.taskana.TaskState;
import pro.taskana.impl.SelectedItem;
import pro.taskana.impl.report.impl.DetailedMonitorQueryItem;
import pro.taskana.impl.report.impl.MonitorQueryItem;
import pro.taskana.impl.report.impl.TaskQueryItem;

public interface TaskMonitorMapper {
    @Select(value={"<script><if test=\"_databaseId == 'db2'\">SELECT WORKBASKET_KEY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> <if test=\"_databaseId == 'h2'\">SELECT WORKBASKET_KEY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> FROM TASKANA.TASK <where><if test=\"workbasketIds != null\">WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test=\"states != null\">AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test=\"categories != null\">AND CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test=\"domains != null\">AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test=\"customField != null and customFieldValues != null\">AND ${customField}  IN (<foreach collection='customFieldValues' item='customFieldValue' separator=','>#{customFieldValue}</foreach>) </if>AND DUE IS NOT NULL </where><if test=\"_databaseId == 'db2'\">GROUP BY WORKBASKET_KEY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP))</if> <if test=\"_databaseId == 'h2'\">GROUP BY WORKBASKET_KEY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE)</if> <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(column="WORKBASKET_KEY", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfWorkbaskets(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="customField") CustomField var5, @Param(value="customFieldValues") List<String> var6);

    @Select(value={"<script><if test=\"_databaseId == 'db2'\">SELECT CLASSIFICATION_CATEGORY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> <if test=\"_databaseId == 'h2'\">SELECT CLASSIFICATION_CATEGORY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> FROM TASKANA.TASK <where><if test=\"workbasketIds != null\">WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test=\"states != null\">AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test=\"categories != null\">AND CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test=\"domains != null\">AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test=\"customField != null and customFieldValues != null\">AND ${customField}  IN (<foreach collection='customFieldValues' item='customFieldValue' separator=','>#{customFieldValue}</foreach>) </if>AND DUE IS NOT NULL </where><if test=\"_databaseId == 'db2'\">GROUP BY CLASSIFICATION_CATEGORY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP))</if> <if test=\"_databaseId == 'h2'\">GROUP BY CLASSIFICATION_CATEGORY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE)</if> <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(column="CLASSIFICATION_CATEGORY", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfCategories(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="customField") CustomField var5, @Param(value="customFieldValues") List<String> var6);

    @Select(value={"<script><if test=\"_databaseId == 'db2'\">SELECT CLASSIFICATION_KEY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> <if test=\"_databaseId == 'h2'\">SELECT CLASSIFICATION_KEY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> FROM TASKANA.TASK <where><if test=\"workbasketIds != null\">WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test=\"states != null\">AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test=\"categories != null\">AND CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test=\"domains != null\">AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test=\"customField != null and customFieldValues != null\">AND ${customField}  IN (<foreach collection='customFieldValues' item='customFieldValue' separator=','>#{customFieldValue}</foreach>) </if>AND DUE IS NOT NULL </where><if test=\"_databaseId == 'db2'\">GROUP BY CLASSIFICATION_KEY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP))</if> <if test=\"_databaseId == 'h2'\">GROUP BY CLASSIFICATION_KEY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE)</if> <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(column="CLASSIFICATION_KEY", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfClassifications(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="customField") CustomField var5, @Param(value="customFieldValues") List<String> var6);

    @Select(value={"<script><if test=\"_databaseId == 'db2'\">SELECT T.CLASSIFICATION_KEY as TASK_CLASSIFICATION_KEY, A.CLASSIFICATION_KEY as ATTACHMENT_CLASSIFICATION_KEY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> <if test=\"_databaseId == 'h2'\">SELECT T.CLASSIFICATION_KEY as TASK_CLASSIFICATION_KEY, A.CLASSIFICATION_KEY as ATTACHMENT_CLASSIFICATION_KEY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> FROM TASKANA.TASK AS T LEFT JOIN TASKANA.ATTACHMENT AS A ON T.ID = A.TASK_ID <where><if test=\"workbasketIds != null\">T.WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test=\"states != null\">AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test=\"categories != null\">AND CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test=\"domains != null\">AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test=\"customField != null and customFieldValues != null\">AND ${customField}  IN (<foreach collection='customFieldValues' item='customFieldValue' separator=','>#{customFieldValue}</foreach>) </if>AND DUE IS NOT NULL </where><if test=\"_databaseId == 'db2'\">GROUP BY T.CLASSIFICATION_KEY, A.CLASSIFICATION_KEY, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP))</if> <if test=\"_databaseId == 'h2'\">GROUP BY T.CLASSIFICATION_KEY, A.CLASSIFICATION_KEY, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE)</if> <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(column="TASK_CLASSIFICATION_KEY", property="key"), @Result(column="ATTACHMENT_CLASSIFICATION_KEY", property="attachmentKey"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<DetailedMonitorQueryItem> getTaskCountOfDetailedClassifications(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="customField") CustomField var5, @Param(value="customFieldValues") List<String> var6);

    @Select(value={"<script><if test=\"_databaseId == 'db2'\">SELECT ${customField} as CUSTOM_FIELD, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> <if test=\"_databaseId == 'h2'\">SELECT ${customField} as CUSTOM_FIELD, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) as AGE_IN_DAYS, COUNT(*) as NUMBER_OF_TASKS</if> FROM TASKANA.TASK <where><if test=\"workbasketIds != null\">WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test=\"states != null\">AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test=\"categories != null\">AND CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test=\"domains != null\">AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test=\"customField != null and customFieldValues != null\">AND ${customField}  IN (<foreach collection='customFieldValues' item='customFieldValue' separator=','>#{customFieldValue}</foreach>) </if>AND DUE IS NOT NULL </where><if test=\"_databaseId == 'db2'\">GROUP BY ${customField}, (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP))</if> <if test=\"_databaseId == 'h2'\">GROUP BY ${customField}, DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE)</if> <if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    @Results(value={@Result(column="CUSTOM_FIELD", property="key"), @Result(column="AGE_IN_DAYS", property="ageInDays"), @Result(column="NUMBER_OF_TASKS", property="numberOfTasks")})
    public List<MonitorQueryItem> getTaskCountOfCustomFieldValues(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="customField") CustomField var5, @Param(value="customFieldValues") List<String> var6);

    @Select(value={"<script>SELECT TASK.ID FROM TASKANA.TASK <if test=\"joinWithAttachments\">LEFT JOIN TASKANA.ATTACHMENT ON TASK.ID = ATTACHMENT.TASK_ID </if><where><if test=\"workbasketIds != null\">TASK.WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test=\"states != null\">AND TASK.STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test=\"categories != null\">AND TASK.CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test=\"domains != null\">AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test='classificationIds != null'>AND TASK.CLASSIFICATION_ID IN (<foreach collection='classificationIds' item='classificationId' separator=','>#{classificationId}</foreach>) </if><if test='excludedClassificationIds != null'>AND TASK.CLASSIFICATION_ID NOT IN (<foreach collection='excludedClassificationIds' item='excludedClassificationId' separator=','>#{excludedClassificationId}</foreach>) </if><if test=\"customField != null and customFieldValues != null\">AND TASK.${customField}  IN (<foreach collection='customFieldValues' item='customFieldValue' separator=','>#{customFieldValue}</foreach>) </if>AND TASK.DUE IS NOT NULL AND ( <foreach collection='selectedItems' item='selectedItem' separator=' OR '>#{selectedItem.key} = TASK.${groupedBy} AND <if test=\"joinWithAttachments\">ATTACHMENT.CLASSIFICATION_KEY = #{selectedItem.subKey} AND </if><if test=\"_databaseId == 'db2'\">#{selectedItem.upperAgeLimit} >= (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) AND #{selectedItem.lowerAgeLimit} &lt;= (DAYS(DUE) - DAYS(CURRENT_TIMESTAMP)) </if> <if test=\"_databaseId == 'h2'\">#{selectedItem.upperAgeLimit} >= DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) AND #{selectedItem.lowerAgeLimit} &lt;= DATEDIFF('DAY', CURRENT_TIMESTAMP, DUE) </if> </foreach>) </where><if test=\"_databaseId == 'db2'\">with UR </if> </script>"})
    public List<String> getTaskIdsForSelectedItems(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="classificationIds") List<String> var5, @Param(value="excludedClassificationIds") List<String> var6, @Param(value="customField") CustomField var7, @Param(value="customFieldValues") List<String> var8, @Param(value="groupedBy") String var9, @Param(value="selectedItems") List<SelectedItem> var10, @Param(value="joinWithAttachments") boolean var11);

    @Select(value={"<script>SELECT DOMAIN, STATE, COUNT(STATE) as COUNT FROM TASKANA.TASK <where><if test='domains != null'>DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test='states != null'>AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if></where>GROUP BY DOMAIN, STATE</script>"})
    @Results(value={@Result(column="DOMAIN", property="domain"), @Result(column="STATE", property="state"), @Result(column="COUNT", property="count")})
    public List<TaskQueryItem> getTasksCountByState(@Param(value="domains") List<String> var1, @Param(value="states") List<TaskState> var2);

    @Select(value={"<script>SELECT DISTINCT ${customAttributeName} FROM TASKANA.TASK <where><if test='workbasketIds != null'>WORKBASKET_ID IN (<foreach collection='workbasketIds' item='workbasketId' separator=','>#{workbasketId}</foreach>) </if><if test='states != null'>AND STATE IN (<foreach collection='states' item='state' separator=','>#{state}</foreach>) </if><if test='categories != null'>AND CLASSIFICATION_CATEGORY IN (<foreach collection='categories' item='category' separator=','>#{category}</foreach>) </if><if test='domains != null'>AND DOMAIN IN (<foreach collection='domains' item='domain' separator=','>#{domain}</foreach>) </if><if test='classificationIds != null'>AND CLASSIFICATION_ID IN (<foreach collection='classificationIds' item='classificationId' separator=','>#{classificationId}</foreach>) </if><if test='excludedClassificationIds != null'>AND CLASSIFICATION_ID NOT IN (<foreach collection='excludedClassificationIds' item='excludedClassificationId' separator=','>#{excludedClassificationId}</foreach>) </if><if test='customAttributeFilter != null'>AND (<foreach collection='customAttributeFilter.keys' item='key' separator=' AND '>(CUSTOM_${key} = '${customAttributeFilter.get(key)}')</foreach>) </if></where></script>"})
    public List<String> getCustomAttributeValuesForReport(@Param(value="workbasketIds") List<String> var1, @Param(value="states") List<TaskState> var2, @Param(value="categories") List<String> var3, @Param(value="domains") List<String> var4, @Param(value="classificationIds") List<String> var5, @Param(value="excludedClassificationIds") List<String> var6, @Param(value="customAttributeFilter") Map<String, String> var7, @Param(value="customAttributeName") String var8);
}

