/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketAccessItemQuery;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketService;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketAccessItemImpl;
import pro.taskana.impl.WorkbasketAccessItemQueryImpl;
import pro.taskana.impl.WorkbasketImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.WorkbasketSummaryImpl;
import pro.taskana.impl.util.IdGenerator;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.DistributionTargetMapper;
import pro.taskana.mappings.TaskMapper;
import pro.taskana.mappings.WorkbasketAccessMapper;
import pro.taskana.mappings.WorkbasketMapper;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketServiceImpl
implements WorkbasketService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketServiceImpl.class);
    private static final String ID_PREFIX_WORKBASKET = "WBI";
    private static final String ID_PREFIX_WORKBASKET_AUTHORIZATION = "WAI";
    private TaskanaEngineImpl taskanaEngine;
    private WorkbasketMapper workbasketMapper;
    private DistributionTargetMapper distributionTargetMapper;
    private WorkbasketAccessMapper workbasketAccessMapper;

    public WorkbasketServiceImpl() {
    }

    WorkbasketServiceImpl(TaskanaEngine taskanaEngine, WorkbasketMapper workbasketMapper, DistributionTargetMapper distributionTargetMapper, WorkbasketAccessMapper workbasketAccessMapper) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.workbasketMapper = workbasketMapper;
        this.distributionTargetMapper = distributionTargetMapper;
        this.workbasketAccessMapper = workbasketAccessMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasket(String workbasketId) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to getWorkbasket(workbasketId = {})", (Object)workbasketId);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngine.openConnection();
            result = this.workbasketMapper.findById(workbasketId);
            if (result == null) {
                LOGGER.error("Method getWorkbasket() didn't find workbasket with ID {}. Throwing WorkbasketNotFoundException", (Object)workbasketId);
                throw new WorkbasketNotFoundException(workbasketId, "Workbasket with id " + workbasketId + " was not found.");
            }
            if (!this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasketId, WorkbasketPermission.READ);
            }
            WorkbasketImpl workbasketImpl = result;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket getWorkbasket(String workbasketKey, String domain) throws WorkbasketNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to getWorkbasketByKey(workbasketKey = {})", (Object)workbasketKey);
        WorkbasketImpl result = null;
        try {
            this.taskanaEngine.openConnection();
            result = this.workbasketMapper.findByKeyAndDomain(workbasketKey, domain);
            if (result == null) {
                LOGGER.error("Method getWorkbasketByKey() didn't find workbasket with key {}. Throwing WorkbasketNotFoundException", (Object)workbasketKey);
                throw new WorkbasketNotFoundException(workbasketKey, domain, "Workbasket with key " + workbasketKey + " and domain " + domain + " was not found.");
            }
            if (!this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasketKey, domain, WorkbasketPermission.READ);
            }
            WorkbasketImpl workbasketImpl = result;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getWorkbasket(workbasketId). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getWorkbaskets(List<WorkbasketPermission> permissions) {
        ArrayList<WorkbasketSummaryImpl> arrayList;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to getWorkbaskets(permissions = {})", (Object)LoggerUtils.listToString(permissions));
        }
        ArrayList<WorkbasketSummaryImpl> result = null;
        try {
            this.taskanaEngine.openConnection();
            HashSet<WorkbasketSummaryImpl> workbaskets = new HashSet<WorkbasketSummaryImpl>();
            for (String accessId : CurrentUserContext.getAccessIds()) {
                workbaskets.addAll(this.workbasketMapper.findByPermission(permissions, accessId));
            }
            result = new ArrayList<WorkbasketSummaryImpl>();
            result.addAll(workbaskets);
            arrayList = result;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbaskets(permissions). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket createWorkbasket(Workbasket newWorkbasket) throws InvalidWorkbasketException, NotAuthorizedException, WorkbasketAlreadyExistException, DomainNotFoundException {
        LOGGER.debug("entry to createtWorkbasket(workbasket)", (Object)newWorkbasket);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        WorkbasketImpl workbasket = (WorkbasketImpl)newWorkbasket;
        try {
            this.taskanaEngine.openConnection();
            Instant now = Instant.now();
            workbasket.setCreated(now);
            workbasket.setModified(now);
            WorkbasketImpl existingWorkbasket = this.workbasketMapper.findByKeyAndDomain(newWorkbasket.getKey(), newWorkbasket.getDomain());
            if (existingWorkbasket != null) {
                LOGGER.error("createWorkbasket failed because Workbasket with key {} and domain {} already exists. Throwing WorkbasketAlreadyExistsException.", (Object)newWorkbasket.getKey(), (Object)newWorkbasket.getDomain());
                throw new WorkbasketAlreadyExistException(existingWorkbasket);
            }
            if (workbasket.getId() == null || workbasket.getId().isEmpty()) {
                workbasket.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET));
            }
            this.validateWorkbasket(workbasket);
            this.workbasketMapper.insert(workbasket);
            LOGGER.debug("Method createWorkbasket() created Workbasket '{}'", (Object)workbasket);
            WorkbasketImpl workbasketImpl = workbasket;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createWorkbasket(workbasket). Returning result {} ", (Object)workbasket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Workbasket updateWorkbasket(Workbasket workbasketToUpdate) throws NotAuthorizedException, WorkbasketNotFoundException, InvalidWorkbasketException {
        LOGGER.debug("entry to updateWorkbasket(workbasket)", (Object)workbasketToUpdate);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        WorkbasketImpl workbasket = (WorkbasketImpl)workbasketToUpdate;
        try {
            this.taskanaEngine.openConnection();
            workbasket.setModified(Instant.now());
            this.workbasketMapper.update(workbasket);
            LOGGER.debug("Method updateWorkbasket() updated workbasket '{}'", (Object)workbasket.getId());
            WorkbasketImpl workbasketImpl = workbasket;
            return workbasketImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from updateWorkbasket(). Returning result {} ", (Object)workbasket);
        }
    }

    @Override
    public WorkbasketAccessItem newWorkbasketAccessItem(String workbasketId, String accessId) {
        WorkbasketAccessItemImpl accessItem = new WorkbasketAccessItemImpl();
        accessItem.setWorkbasketId(workbasketId);
        accessItem.setAccessId(accessId);
        return accessItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketAccessItem createWorkbasketAccessItem(WorkbasketAccessItem workbasketAccessItem) throws InvalidArgumentException, NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to createWorkbasketAccessItemn(workbasketAccessItem = {})", (Object)workbasketAccessItem);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        WorkbasketAccessItemImpl accessItem = (WorkbasketAccessItemImpl)workbasketAccessItem;
        try {
            this.taskanaEngine.openConnection();
            accessItem.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET_AUTHORIZATION));
            if (workbasketAccessItem.getId() == null || workbasketAccessItem.getAccessId() == null || workbasketAccessItem.getWorkbasketId() == null) {
                LOGGER.error("createWorkbasketAccessItem failed because id, accessId or workbasketId is null. Throwing InvalidArgumentException.");
                throw new InvalidArgumentException("Checking the preconditions of the current WorkbasketAccessItem failed. WorkbasketAccessItem=" + workbasketAccessItem.toString());
            }
            WorkbasketImpl wb = this.workbasketMapper.findById(workbasketAccessItem.getWorkbasketId());
            if (wb == null) {
                throw new WorkbasketNotFoundException(workbasketAccessItem.getWorkbasketId(), "WorkbasketAccessItem " + workbasketAccessItem + " refers to a not existing workbasket");
            }
            this.workbasketAccessMapper.insert(accessItem);
            LOGGER.debug("Method createWorkbasketAccessItem() created workbaskteAccessItem {}", (Object)accessItem);
            WorkbasketAccessItemImpl workbasketAccessItemImpl = accessItem;
            return workbasketAccessItemImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createWorkbasketAccessItem(workbasketAccessItem). Returning result {}", (Object)accessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWorkbasketAccessItems(String workbasketId, List<WorkbasketAccessItem> wbAccessItems) throws InvalidArgumentException, NotAuthorizedException {
        LOGGER.debug("entry to setWorkbasketAccessItems(workbasketAccessItems = {})", (Object)wbAccessItems.toString());
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        ArrayList<WorkbasketAccessItemImpl> newItems = new ArrayList<WorkbasketAccessItemImpl>();
        try {
            this.taskanaEngine.openConnection();
            if (!wbAccessItems.isEmpty()) {
                for (WorkbasketAccessItem workbasketAccessItem : wbAccessItems) {
                    WorkbasketAccessItemImpl wbAccessItemImpl = (WorkbasketAccessItemImpl)workbasketAccessItem;
                    if (wbAccessItemImpl.getWorkbasketId() == null) {
                        LOGGER.error("setWorkbasketAccessItem failed because WorkbasketAccessItem {} has a null workbasketId. Throwing InvalidArgumentException.", (Object)workbasketAccessItem);
                        throw new InvalidArgumentException("Checking the preconditions of the current WorkbasketAccessItem failed - WBID is NULL. WorkbasketAccessItem=" + workbasketAccessItem.toString());
                    }
                    if (!wbAccessItemImpl.getWorkbasketId().equals(workbasketId)) {
                        LOGGER.error("setWorkbasketAccessItem failed because WorkbasketAccessItem {} does not refer to workbasket {}. Throwing InvalidArgumentException.", (Object)workbasketAccessItem, (Object)workbasketId);
                        throw new InvalidArgumentException("Checking the preconditions of the current WorkbasketAccessItem failed - the WBID does not match. Target-WBID='" + workbasketId + "' WorkbasketAccessItem=" + workbasketAccessItem.toString());
                    }
                    if (wbAccessItemImpl.getId() == null || wbAccessItemImpl.getId().isEmpty()) {
                        wbAccessItemImpl.setId(IdGenerator.generateWithPrefix(ID_PREFIX_WORKBASKET_AUTHORIZATION));
                    }
                    newItems.add(wbAccessItemImpl);
                }
                this.workbasketAccessMapper.deleteAllAccessItemsForWorkbasketId(workbasketId);
                newItems.stream().forEach(item -> this.workbasketAccessMapper.insert((WorkbasketAccessItemImpl)item));
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from setWorkbasketAccessItems(workbasketAccessItems = {})", (Object)wbAccessItems.toString());
        }
    }

    @Override
    public void deleteWorkbasketAccessItem(String accessItemId) throws NotAuthorizedException {
        LOGGER.debug("entry to deleteWorkbasketAccessItem(id = {})", (Object)accessItemId);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            this.workbasketAccessMapper.delete(accessItemId);
            LOGGER.debug("Method deleteWorkbasketAccessItem() deleted workbasketAccessItem wit Id {}", (Object)accessItemId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteWorkbasketAccessItem(id).");
        }
    }

    @Override
    public void deleteWorkbasketAccessItemsForAccessId(String accessId) throws NotAuthorizedException {
        LOGGER.debug("entry to deleteWorkbasketAccessItemsForAccessId(accessId = {})", (Object)accessId);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            this.workbasketAccessMapper.deleteAccessItemsForAccessId(accessId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteWorkbasketAccessItemsForAccessId(accessId={}).", (Object)accessId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAuthorization(String workbasketId, WorkbasketPermission ... requestedPermissions) throws NotAuthorizedException, WorkbasketNotFoundException {
        boolean isAuthorized = true;
        try {
            this.taskanaEngine.openConnection();
            if (this.workbasketMapper.findById(workbasketId) == null) {
                LOGGER.error("Throwing WorkbasketNotFoundException because workbasket with id {} does not exist", (Object)workbasketId);
                throw new WorkbasketNotFoundException(workbasketId, "Workbasket with id " + workbasketId + " was not found.");
            }
            if (this.skipAuthorizationCheck()) {
                return;
            }
            List<String> accessIds = CurrentUserContext.getAccessIds();
            ArrayList<WorkbasketPermission> grantedPermissions = new ArrayList<WorkbasketPermission>();
            WorkbasketAccessItemImpl wbAcc = this.workbasketAccessMapper.findByWorkbasketAndAccessId(workbasketId, accessIds);
            if (wbAcc == null) {
                LOGGER.error("AccessIds {} do not have permission {} on workbasket with id {}. Throwing NotAuthorizedException.", new Object[]{LoggerUtils.listToString(accessIds), Arrays.toString((Object[])requestedPermissions), workbasketId});
                throw new NotAuthorizedException("Not authorized. Permission '" + Arrays.toString((Object[])requestedPermissions) + "' on workbasket '" + workbasketId + "' is needed.");
            }
            this.addWorkbasketAccessItemValuesToPermissionSet(wbAcc, grantedPermissions);
            for (WorkbasketPermission perm : requestedPermissions) {
                if (grantedPermissions.contains((Object)perm)) continue;
                isAuthorized = false;
                LOGGER.error("AccessIds {} do not have permission {} on workbasket with id {}. Throwing NotAuthorizedException.", new Object[]{LoggerUtils.listToString(accessIds), perm.name(), workbasketId});
                throw new NotAuthorizedException("Not authorized. Permission '" + perm.name() + "' on workbasket '" + workbasketId + "' is needed.");
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from checkAuthorization(). User is authorized = {}.", (Object)isAuthorized);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkAuthorization(String workbasketKey, String domain, WorkbasketPermission ... requestedPermissions) throws NotAuthorizedException, WorkbasketNotFoundException {
        boolean isAuthorized = true;
        try {
            this.taskanaEngine.openConnection();
            if (this.workbasketMapper.findByKeyAndDomain(workbasketKey, domain) == null) {
                LOGGER.error("Throwing WorkbasketNotFoundException because workbasket with key {} and domain {} does not exist", (Object)workbasketKey, (Object)domain);
                throw new WorkbasketNotFoundException(workbasketKey, domain, "Workbasket with key " + workbasketKey + " and domain " + domain + " was not found");
            }
            if (this.skipAuthorizationCheck()) {
                return;
            }
            List<String> accessIds = CurrentUserContext.getAccessIds();
            ArrayList<WorkbasketPermission> grantedPermissions = new ArrayList<WorkbasketPermission>();
            WorkbasketAccessItemImpl wbAcc = this.workbasketAccessMapper.findByWorkbasketKeyDomainAndAccessId(workbasketKey, domain, accessIds);
            if (wbAcc == null) {
                LOGGER.error("AccessIds {} do not have permission {} on workbasket with key {} and domain {}. Throwing NotAuthorizedException.", new Object[]{LoggerUtils.listToString(accessIds), Arrays.toString((Object[])requestedPermissions), workbasketKey, domain});
                throw new NotAuthorizedException("Not authorized. Permission '" + Arrays.toString((Object[])requestedPermissions) + "' on workbasket with key '" + workbasketKey + "' and domain '" + domain + "' is needed.");
            }
            this.addWorkbasketAccessItemValuesToPermissionSet(wbAcc, grantedPermissions);
            for (WorkbasketPermission perm : requestedPermissions) {
                if (grantedPermissions.contains((Object)perm)) continue;
                isAuthorized = false;
                LOGGER.error("AccessIds {} do not have permission {} on workbasket with key {} and domain {}. Throwing NotAuthorizedException.", new Object[]{LoggerUtils.listToString(accessIds), perm.name(), workbasketKey, domain});
                throw new NotAuthorizedException("Not authorized. Permission '" + perm.name() + "' on workbasket with key '" + workbasketKey + "' and domain '" + domain + "' is needed.");
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from checkAuthorization(). User is authorized = {}.", (Object)isAuthorized);
        }
    }

    private boolean skipAuthorizationCheck() {
        if (!this.taskanaEngine.getConfiguration().isSecurityEnabled()) {
            LOGGER.debug("Skipping permissions check since security is disabled.");
            return true;
        }
        if (this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN)) {
            LOGGER.debug("Skipping permissions check since user is in role ADMIN.");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkbasketAccessItem updateWorkbasketAccessItem(WorkbasketAccessItem workbasketAccessItem) throws InvalidArgumentException, NotAuthorizedException {
        LOGGER.debug("entry to updateWorkbasketAccessItem(workbasketAccessItem = {}", (Object)workbasketAccessItem);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        WorkbasketAccessItemImpl accessItem = (WorkbasketAccessItemImpl)workbasketAccessItem;
        try {
            this.taskanaEngine.openConnection();
            WorkbasketAccessItemImpl originalItem = this.workbasketAccessMapper.findById(accessItem.getId());
            if (originalItem.getAccessId() != null && !originalItem.getAccessId().equals(accessItem.getAccessId()) || originalItem.getWorkbasketId() != null && !originalItem.getWorkbasketId().equals(accessItem.getWorkbasketId())) {
                throw new InvalidArgumentException("AccessId and WorkbasketId must not be changed in updateWorkbasketAccessItem calls");
            }
            this.workbasketAccessMapper.update(accessItem);
            LOGGER.debug("Method updateWorkbasketAccessItem() updated workbasketAccessItem {}", (Object)accessItem);
            WorkbasketAccessItemImpl workbasketAccessItemImpl = accessItem;
            return workbasketAccessItemImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from updateWorkbasketAccessItem(workbasketAccessItem). Returning {}", (Object)accessItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> getWorkbasketAccessItems(String workbasketId) throws NotAuthorizedException {
        ArrayList<WorkbasketAccessItem> arrayList;
        LOGGER.debug("entry to getWorkbasketAccessItems(workbasketId = {})", (Object)workbasketId);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngine.openConnection();
            List<WorkbasketAccessItemImpl> queryResult = this.workbasketAccessMapper.findByWorkbasketId(workbasketId);
            result.addAll(queryResult);
            arrayList = result;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from getWorkbasketAccessItems(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from getWorkbasketAccessItems(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<WorkbasketPermission> getPermissionsForWorkbasket(String workbasketId) {
        ArrayList<WorkbasketPermission> permissions = new ArrayList<WorkbasketPermission>();
        WorkbasketAccessItemImpl wbAcc = this.workbasketAccessMapper.findByWorkbasketAndAccessId(workbasketId, CurrentUserContext.getAccessIds());
        this.addWorkbasketAccessItemValuesToPermissionSet(wbAcc, permissions);
        return permissions;
    }

    @Override
    public WorkbasketQuery createWorkbasketQuery() {
        return new WorkbasketQueryImpl(this.taskanaEngine);
    }

    private void validateWorkbasket(Workbasket workbasket) throws InvalidWorkbasketException, DomainNotFoundException {
        if (workbasket.getId() == null || workbasket.getId().length() == 0) {
            throw new InvalidWorkbasketException("Id must not be null for " + workbasket);
        }
        if (workbasket.getKey() == null || workbasket.getKey().length() == 0) {
            throw new InvalidWorkbasketException("Key must not be null for " + workbasket);
        }
        if (workbasket.getName() == null || workbasket.getName().length() == 0) {
            throw new InvalidWorkbasketException("Name must not be null for " + workbasket);
        }
        if (workbasket.getDomain() == null) {
            throw new InvalidWorkbasketException("Domain must not be null for " + workbasket);
        }
        if (workbasket.getType() == null) {
            throw new InvalidWorkbasketException("Type must not be null for " + workbasket);
        }
        if (!this.taskanaEngine.domainExists(workbasket.getDomain())) {
            throw new DomainNotFoundException(workbasket.getDomain(), "Domain " + workbasket.getDomain() + " does not exist in the configuration.");
        }
    }

    private void addWorkbasketAccessItemValuesToPermissionSet(WorkbasketAccessItem workbasketAccessItem, List<WorkbasketPermission> permissions) {
        if (workbasketAccessItem.isPermOpen()) {
            permissions.add(WorkbasketPermission.OPEN);
        }
        if (workbasketAccessItem.isPermRead()) {
            permissions.add(WorkbasketPermission.READ);
        }
        if (workbasketAccessItem.isPermAppend()) {
            permissions.add(WorkbasketPermission.APPEND);
        }
        if (workbasketAccessItem.isPermTransfer()) {
            permissions.add(WorkbasketPermission.TRANSFER);
        }
        if (workbasketAccessItem.isPermDistribute()) {
            permissions.add(WorkbasketPermission.DISTRIBUTE);
        }
        if (workbasketAccessItem.isPermCustom1()) {
            permissions.add(WorkbasketPermission.CUSTOM_1);
        }
        if (workbasketAccessItem.isPermCustom2()) {
            permissions.add(WorkbasketPermission.CUSTOM_2);
        }
        if (workbasketAccessItem.isPermCustom3()) {
            permissions.add(WorkbasketPermission.CUSTOM_3);
        }
        if (workbasketAccessItem.isPermCustom4()) {
            permissions.add(WorkbasketPermission.CUSTOM_4);
        }
        if (workbasketAccessItem.isPermCustom5()) {
            permissions.add(WorkbasketPermission.CUSTOM_5);
        }
        if (workbasketAccessItem.isPermCustom6()) {
            permissions.add(WorkbasketPermission.CUSTOM_6);
        }
        if (workbasketAccessItem.isPermCustom7()) {
            permissions.add(WorkbasketPermission.CUSTOM_7);
        }
        if (workbasketAccessItem.isPermCustom8()) {
            permissions.add(WorkbasketPermission.CUSTOM_8);
        }
        if (workbasketAccessItem.isPermCustom9()) {
            permissions.add(WorkbasketPermission.CUSTOM_9);
        }
        if (workbasketAccessItem.isPermCustom10()) {
            permissions.add(WorkbasketPermission.CUSTOM_10);
        }
        if (workbasketAccessItem.isPermCustom11()) {
            permissions.add(WorkbasketPermission.CUSTOM_11);
        }
        if (workbasketAccessItem.isPermCustom12()) {
            permissions.add(WorkbasketPermission.CUSTOM_12);
        }
    }

    @Override
    public Workbasket newWorkbasket(String key, String domain) {
        WorkbasketImpl wb = new WorkbasketImpl();
        wb.setDomain(domain);
        wb.setKey(key);
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getDistributionTargets(String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to getDistributionTargets(workbasketId = {})", (Object)workbasketId);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.taskanaEngine.openConnection();
            this.getWorkbasket(workbasketId);
            if (!this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasketId, WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionTargets = this.workbasketMapper.findByDistributionTargets(workbasketId);
            result.addAll(distributionTargets);
            ArrayList<WorkbasketSummary> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result.size();
                LOGGER.debug("exit from getDistributionTargets(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getDistributionTargets(String workbasketKey, String domain) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to getDistributionTargets(workbasketKey = {}, domain = {})", (Object)workbasketKey, (Object)domain);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.taskanaEngine.openConnection();
            Workbasket workbasket = this.getWorkbasket(workbasketKey, domain);
            if (!this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasket.getId(), WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionTargets = this.workbasketMapper.findByDistributionTargets(workbasket.getId());
            result.addAll(distributionTargets);
            ArrayList<WorkbasketSummary> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result.size();
                LOGGER.debug("exit from getDistributionTargets(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getDistributionSources(String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to getDistributionSources(workbasketId = {})", (Object)workbasketId);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.taskanaEngine.openConnection();
            this.getWorkbasket(workbasketId);
            if (!this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasketId, WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionSources = this.workbasketMapper.findDistributionSources(workbasketId);
            result.addAll(distributionSources);
            ArrayList<WorkbasketSummary> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result.size();
                LOGGER.debug("exit from getDistributionSources(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> getDistributionSources(String workbasketKey, String domain) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to getDistributionSources(workbasketKey = {}, domain = {})", (Object)workbasketKey, (Object)domain);
        ArrayList<WorkbasketSummary> result = new ArrayList<WorkbasketSummary>();
        try {
            this.taskanaEngine.openConnection();
            Workbasket workbasket = this.getWorkbasket(workbasketKey, domain);
            if (!this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN)) {
                this.checkAuthorization(workbasket.getId(), WorkbasketPermission.READ);
            }
            List<WorkbasketSummaryImpl> distributionSources = this.workbasketMapper.findDistributionSources(workbasket.getId());
            result.addAll(distributionSources);
            ArrayList<WorkbasketSummary> arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result.size();
                LOGGER.debug("exit from getDistributionSources(workbasketId). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDistributionTargets(String sourceWorkbasketId, List<String> targetWorkbasketIds) throws WorkbasketNotFoundException, NotAuthorizedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("entry to setDistributionTargets(sourceWorkbasketId = {}, targetWorkazketIds = {})", (Object)sourceWorkbasketId, (Object)LoggerUtils.listToString(targetWorkbasketIds));
        }
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
            this.distributionTargetMapper.deleteAllDistributionTargetsBySourceId(sourceWorkbasketId);
            sourceWorkbasket.setModified(Instant.now());
            this.workbasketMapper.update(sourceWorkbasket);
            if (targetWorkbasketIds != null) {
                for (String targetId : targetWorkbasketIds) {
                    this.getWorkbasket(targetId);
                    this.distributionTargetMapper.insert(sourceWorkbasketId, targetId);
                    LOGGER.debug("Method setDistributionTargets() created distributiontarget for source '{}' and target {}", (Object)sourceWorkbasketId, (Object)targetId);
                }
            }
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("setDistributionTargets set {} distribution targets to source workbasket {} ", (Object)(targetWorkbasketIds == null ? 0 : targetWorkbasketIds.size()), (Object)sourceWorkbasketId);
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("setDistributionTargets set {} distribution targets to source workbasket {} ", (Object)(targetWorkbasketIds == null ? 0 : targetWorkbasketIds.size()), (Object)sourceWorkbasketId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDistributionTarget(String sourceWorkbasketId, String targetWorkbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to addDistributionTarget(sourceWorkbasketId = {}, targetWorkbasketId = {})", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
            this.getWorkbasket(targetWorkbasketId);
            int numOfDistTargets = this.distributionTargetMapper.getNumberOfDistributionTargets(sourceWorkbasketId, targetWorkbasketId);
            if (numOfDistTargets > 0) {
                LOGGER.debug("addDistributionTarget detected that the specified distribution target exists already. Doing nothing...");
            } else {
                this.distributionTargetMapper.insert(sourceWorkbasketId, targetWorkbasketId);
                LOGGER.debug("addDistributionTarget inserted distribution target sourceId = {}, targetId = {}", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
                sourceWorkbasket.setModified(Instant.now());
                this.workbasketMapper.update(sourceWorkbasket);
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from addDistributionTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDistributionTarget(String sourceWorkbasketId, String targetWorkbasketId) throws NotAuthorizedException, WorkbasketNotFoundException {
        LOGGER.debug("entry to removeDistributionTarget(sourceWorkbasketId = {}, targetWorkbasketId = {})", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            int numberOfDistTargets = this.distributionTargetMapper.getNumberOfDistributionTargets(sourceWorkbasketId, targetWorkbasketId);
            if (numberOfDistTargets > 0) {
                this.distributionTargetMapper.delete(sourceWorkbasketId, targetWorkbasketId);
                LOGGER.debug("removeDistributionTarget deleted distribution target sourceId = {}, targetId = {}", (Object)sourceWorkbasketId, (Object)targetWorkbasketId);
                try {
                    WorkbasketImpl sourceWorkbasket = (WorkbasketImpl)this.getWorkbasket(sourceWorkbasketId);
                    sourceWorkbasket.setModified(Instant.now());
                    this.workbasketMapper.update(sourceWorkbasket);
                }
                catch (WorkbasketNotFoundException e) {
                    LOGGER.debug("removeDistributionTarget found that the source workbasket {} doesn't exist. Ignoring the request... ", (Object)sourceWorkbasketId);
                }
            } else {
                LOGGER.debug("removeDistributionTarget detected that the specified distribution target doesn't exist. Doing nothing...");
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from addDistributionTarget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteWorkbasket(String workbasketId) throws NotAuthorizedException, WorkbasketNotFoundException, WorkbasketInUseException, InvalidArgumentException {
        LOGGER.debug("entry to deleteWorkbasket(workbasketId = {})", (Object)workbasketId);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            if (workbasketId == null || workbasketId.isEmpty()) {
                throw new InvalidArgumentException("The WorkbasketId can\u00b4t be NULL or EMPTY for deleteWorkbasket()");
            }
            Workbasket wb = this.getWorkbasket(workbasketId);
            long numTasksInWorkbasket = ((TaskMapper)this.taskanaEngine.getSqlSession().getMapper(TaskMapper.class)).countTasksInWorkbasket(workbasketId);
            if (numTasksInWorkbasket > 0L) {
                throw new WorkbasketInUseException("Workbasket is used on tasks and can\u00b4t be deleted. WorkbasketId=" + workbasketId);
            }
            this.distributionTargetMapper.deleteAllDistributionTargetsBySourceId(wb.getId());
            this.distributionTargetMapper.deleteAllDistributionTargetsByTargetId(wb.getId());
            this.workbasketAccessMapper.deleteAllAccessItemsForWorkbasketId(wb.getId());
            this.workbasketMapper.delete(workbasketId);
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteWorkbasket(workbasketId = {})", (Object)workbasketId);
        }
    }

    @Override
    public WorkbasketAccessItemQuery createWorkbasketAccessItemQuery() throws NotAuthorizedException {
        this.taskanaEngine.checkRoleMembership(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN);
        return new WorkbasketAccessItemQueryImpl(this.taskanaEngine);
    }
}

