/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BulkOperationResults;
import pro.taskana.impl.Job;
import pro.taskana.impl.JobRunner;
import pro.taskana.impl.SingleJobExecutor;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskUpdateJobExecutor;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.AttachmentMapper;
import pro.taskana.mappings.ClassificationMapper;
import pro.taskana.mappings.JobMapper;
import pro.taskana.mappings.TaskMapper;

public class ClassificationChangedJobExecutor
implements SingleJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationChangedJobExecutor.class);
    private TaskanaEngineImpl taskanaEngine;
    private Job job;
    private String classificationId;
    private boolean priorityChanged;
    private boolean serviceLevelChanged;
    private TaskMapper taskMapper;
    private ClassificationMapper classificationMapper;
    private AttachmentMapper attachmentMapper;

    @Override
    public BulkOperationResults<String, Exception> runSingleJob(Job job, TaskanaEngineImpl taskanaEngine) {
        this.job = job;
        this.taskanaEngine = taskanaEngine;
        this.taskMapper = (TaskMapper)taskanaEngine.getSqlSession().getMapper(TaskMapper.class);
        this.classificationMapper = (ClassificationMapper)taskanaEngine.getSqlSession().getMapper(ClassificationMapper.class);
        this.attachmentMapper = (AttachmentMapper)taskanaEngine.getSqlSession().getMapper(AttachmentMapper.class);
        Map<String, String> args = job.getArguments();
        this.classificationId = args.get("classificationId");
        this.priorityChanged = Boolean.parseBoolean(args.get("priorityChanged"));
        this.serviceLevelChanged = Boolean.parseBoolean(args.get("serviceLevelChanged"));
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        bulkLog.addAllErrors(this.findAffectedTasksAndScheduleUpdateJobs());
        return bulkLog;
    }

    private BulkOperationResults<String, Exception> findAffectedTasksAndScheduleUpdateJobs() {
        List<TaskSummaryImpl> tasks = this.taskMapper.findTasksAffectedByClassificationChange(this.classificationId);
        List<String> taskIdsFromAttachments = this.attachmentMapper.findTaskIdsAffectedByClassificationChange(this.classificationId);
        List<Object> filteredTaskIdsFromAttachments = taskIdsFromAttachments.isEmpty() ? new ArrayList() : this.taskMapper.filterTaskIdsForNotCompleted(taskIdsFromAttachments);
        HashSet<String> affectedTaskIds = new HashSet<String>(filteredTaskIdsFromAttachments);
        for (TaskSummaryImpl task : tasks) {
            affectedTaskIds.add(task.getTaskId());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks are affected by the update of classification {} : {}", (Object)this.classificationId, (Object)LoggerUtils.setToString(affectedTaskIds));
        }
        int batchSize = this.taskanaEngine.getConfiguration().getMaxNumberOfTaskUpdatesPerTransaction();
        List affectedTaskBatches = JobRunner.partition(affectedTaskIds, batchSize);
        for (List taskIdBatch : affectedTaskBatches) {
            HashMap<String, String> args = new HashMap<String, String>();
            if (taskIdBatch.isEmpty()) continue;
            String taskIds = String.join((CharSequence)",", taskIdBatch);
            args.put("taskIds", taskIds);
            args.put("classificationId", this.classificationId);
            args.put("priorityChanged", new Boolean(this.priorityChanged).toString());
            args.put("serviceLevelChanged", new Boolean(this.serviceLevelChanged).toString());
            Job job = new Job();
            job.setCreated(Instant.now());
            job.setState(Job.State.READY);
            job.setRetryCount(0);
            job.setType(Job.Type.UPDATETASKSJOB);
            job.setExecutor(TaskUpdateJobExecutor.class.getName());
            job.setArguments(args);
            ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).insertJob(job);
        }
        return null;
    }
}

