/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BulkOperationResults;
import pro.taskana.impl.Job;
import pro.taskana.impl.SingleJobExecutor;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;

public class TaskUpdateJobExecutor
implements SingleJobExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskUpdateJobExecutor.class);
    private TaskanaEngineImpl taskanaEngine;
    private String classificationId;
    private List<String> affectedTaskIds;

    @Override
    public BulkOperationResults<String, Exception> runSingleJob(Job job, TaskanaEngineImpl taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        Map<String, String> args = job.getArguments();
        String taskIdsString = args.get("taskIds");
        this.affectedTaskIds = Arrays.asList(taskIdsString.split(","));
        this.classificationId = args.get("classificationId");
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        bulkLog.addAllErrors(this.handleAffectedTasks(job));
        return bulkLog;
    }

    private BulkOperationResults<String, Exception> handleAffectedTasks(Job job) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("the following tasks will be updated by the current job {}", (Object)LoggerUtils.listToString(this.affectedTaskIds));
        }
        TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngine.getTaskService();
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        for (String taskId : this.affectedTaskIds) {
            try {
                bulkLog.addAllErrors(taskService.classificationChanged(taskId, this.classificationId));
            }
            catch (Exception e) {
                bulkLog.addError(taskId, e);
            }
        }
        return bulkLog;
    }
}

