/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchemaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSchemaCreator.class);
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA = "/sql/taskana-schema.sql";
    private static final String DB_SCHEMA_POSTGRES = "/sql/taskana-schema-postgres.sql";
    private static final String DB_SCHEMA_DETECTION = "/sql/schema-detection.sql";
    private DataSource dataSource;
    private StringWriter outWriter = new StringWriter();
    private PrintWriter logWriter = new PrintWriter(this.outWriter);
    private StringWriter errorWriter = new StringWriter();
    private PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);

    public DbSchemaCreator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private static String selectDbScriptFileName(String dbProductName) {
        return "PostgreSQL".equals(dbProductName) ? DB_SCHEMA_POSTGRES : DB_SCHEMA;
    }

    public void run() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        ScriptRunner runner = new ScriptRunner(connection);
        LOGGER.debug(connection.getMetaData().toString());
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        try {
            if (!this.isSchemaPreexisting(runner)) {
                runner.runScript((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DbSchemaCreator.selectDbScriptFileName(connection.getMetaData().getDatabaseProductName()))));
            }
        }
        finally {
            runner.closeConnection();
        }
        LOGGER.debug(this.outWriter.toString());
        if (!this.errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(this.errorWriter.toString());
        }
    }

    private boolean isSchemaPreexisting(ScriptRunner runner) {
        try {
            runner.runScript((Reader)new InputStreamReader(this.getClass().getResourceAsStream(DB_SCHEMA_DETECTION)));
        }
        catch (Exception e) {
            LOGGER.debug("Schema does not exist.");
            return false;
        }
        LOGGER.debug("Schema does exist.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSchemaVersion(String expectedVersion) {
        SqlRunner runner = null;
        try {
            Connection connection = this.dataSource.getConnection();
            runner = new SqlRunner(connection);
            LOGGER.debug(connection.getMetaData().toString());
            String query = "select VERSION from TASKANA.TASKANA_SCHEMA_VERSION where VERSION = (select max(VERSION) from TASKANA.TASKANA_SCHEMA_VERSION) AND VERSION = '" + expectedVersion + "'";
            Map queryResult = runner.selectOne(query, new Object[0]);
            if (queryResult == null || queryResult.isEmpty()) {
                LOGGER.error("Schema version not valid. The VERSION property in table TASKANA.TASKANA_SCHEMA_VERSION has not the expected value {}", (Object)expectedVersion);
                boolean bl = false;
                return bl;
            }
            LOGGER.debug("Schema version is valid.");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Schema version not valid. The VERSION property in table TASKANA.TASKANA_SCHEMA_VERSION has not the expected value {}", (Object)expectedVersion);
            boolean bl = false;
            return bl;
        }
        finally {
            if (runner != null) {
                runner.closeConnection();
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

