/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.taskana.impl.report.QueryItem;
import pro.taskana.impl.report.QueryItemPreprocessor;
import pro.taskana.impl.report.ReportColumnHeader;
import pro.taskana.impl.report.ReportRow;

public abstract class Report<Item extends QueryItem, ColumnHeader extends ReportColumnHeader<? super Item>> {
    protected List<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
    private Map<String, ReportRow<Item>> reportRows = new LinkedHashMap<String, ReportRow<Item>>();
    private ReportRow<Item> sumRow;
    private String rowDesc;

    public Report(List<ColumnHeader> columnHeaders, String rowDesc) {
        this.rowDesc = rowDesc;
        this.sumRow = new ReportRow(columnHeaders.size());
        this.columnHeaders.addAll(columnHeaders);
    }

    public final Map<String, ReportRow<Item>> getReportRows() {
        return this.reportRows;
    }

    public final ReportRow<Item> getSumRow() {
        return this.sumRow;
    }

    public final List<ColumnHeader> getColumnHeaders() {
        return this.columnHeaders;
    }

    public final String getRowDesc() {
        return this.rowDesc;
    }

    public ReportRow<Item> getRow(String key) {
        return this.reportRows.get(key);
    }

    public final Set<String> rowTitles() {
        return this.reportRows.keySet();
    }

    public final int rowSize() {
        return this.reportRows.size();
    }

    public final void addItem(Item item) {
        ReportRow row = this.reportRows.computeIfAbsent(item.getKey(), s -> this.createReportRow(this.columnHeaders.size()));
        if (this.columnHeaders.isEmpty()) {
            row.updateTotalValue(item);
            this.sumRow.updateTotalValue(item);
        } else {
            for (int i = 0; i < this.columnHeaders.size(); ++i) {
                if (!((ReportColumnHeader)this.columnHeaders.get(i)).fits(item)) continue;
                row.addItem(item, i);
                this.sumRow.addItem(item, i);
            }
        }
    }

    public final void addItems(List<Item> items, QueryItemPreprocessor<Item> preprocessor) {
        items.stream().map(preprocessor::apply).forEach(this::addItem);
    }

    public final void addItems(List<Item> items) {
        items.forEach(this::addItem);
    }

    protected ReportRow<Item> createReportRow(int columnSize) {
        return new ReportRow(columnSize);
    }
}

