/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BulkOperationResults;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaTransactionProvider;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.Job;
import pro.taskana.impl.SingleJobExecutor;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.JobMapper;

public class JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunner.class);
    private TaskanaEngineImpl taskanaEngine;
    private JobMapper jobMapper;
    private int maxRetryCount;
    private TaskanaTransactionProvider<BulkOperationResults<String, Exception>> txProvider;

    public JobRunner(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.jobMapper = (JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class);
        this.maxRetryCount = taskanaEngine.getConfiguration().getMaxNumberOfRetriesOfFailedTaskUpdates();
        this.txProvider = null;
    }

    public void registerTransactionProvider(TaskanaTransactionProvider<BulkOperationResults<String, Exception>> txProvider) {
        this.txProvider = txProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkOperationResults<String, Exception> runJobs() {
        LOGGER.info("entry to runJobs()");
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults<String, Exception>();
        Job currentlyProcessedJob = null;
        try {
            Object object;
            List<Job> jobs = this.findJobsToRun();
            while (!jobs.isEmpty()) {
                object = jobs.iterator();
                while (object.hasNext()) {
                    Job job;
                    currentlyProcessedJob = job = (Job)object.next();
                    this.processAJob(bulkLog, job);
                }
                jobs = this.findJobsToRun();
            }
            object = bulkLog;
            return object;
        }
        catch (Exception e) {
            if (currentlyProcessedJob != null) {
                bulkLog.addError("JobId:" + currentlyProcessedJob.getJobId(), e);
                this.setJobFailed(currentlyProcessedJob, bulkLog);
                BulkOperationResults<String, Exception> bulkOperationResults = bulkLog;
                return bulkOperationResults;
            }
            LOGGER.error("tried to run jobs and caught exception {} ", (Throwable)e);
            bulkLog.addError("unknown", e);
            BulkOperationResults<String, Exception> bulkOperationResults = bulkLog;
            return bulkOperationResults;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.info("exit from runJobs(). Returning result {} ", bulkLog);
        }
    }

    private List<Job> findJobsToRun() {
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.txProvider != null) {
            this.txProvider.executeInTransaction(() -> {
                try {
                    this.taskanaEngine.openConnection();
                    this.doFindJobsToRun(result);
                    BulkOperationResults bulkOperationResults = null;
                    return bulkOperationResults;
                }
                finally {
                    this.taskanaEngine.returnConnection();
                }
            });
        } else {
            this.doFindJobsToRun(result);
        }
        return result;
    }

    private BulkOperationResults<String, Exception> doFindJobsToRun(List<Job> jobs) {
        List<Job> found = ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).findJobsToRun();
        jobs.addAll(found);
        return null;
    }

    private void processAJob(BulkOperationResults<String, Exception> bulkLog, Job job) {
        try {
            BulkOperationResults log = this.txProvider != null ? this.txProvider.executeInTransaction(() -> {
                try {
                    this.taskanaEngine.openConnection();
                    BulkOperationResults<String, Exception> bulkOperationResults = this.runSingleJob(job);
                    return bulkOperationResults;
                }
                finally {
                    this.taskanaEngine.returnConnection();
                }
            }) : this.runSingleJob(job);
            if (log != null && log.containsErrors() && Job.Type.UPDATETASKSJOB.equals((Object)job.getType())) {
                this.handleRetryForFailuresFromBulkOperationResult(bulkLog, job, log);
            }
        }
        catch (Exception e) {
            List<String> objectIds;
            LOGGER.warn("Processing of job " + job.getJobId() + " failed. Trying to split it up into two pieces...", (Throwable)e);
            if (job.getRetryCount() < this.maxRetryCount) {
                this.rescheduleBisectedJob(bulkLog, job);
            }
            if (job.getType().equals((Object)Job.Type.UPDATETASKSJOB)) {
                String taskIdsAsString = job.getArguments().get("taskIds");
                objectIds = Arrays.asList(taskIdsAsString.split(","));
            } else if (job.getType().equals((Object)Job.Type.CLASSIFICATIONCHANGEDJOB)) {
                String classificationId = job.getArguments().get("classificationId");
                objectIds = Arrays.asList(classificationId);
            } else {
                throw new SystemException("Unknown Jobtype " + (Object)((Object)job.getType()) + " encountered.");
            }
            for (String objectId : objectIds) {
                bulkLog.addError(objectId, e);
            }
            this.setJobFailed(job, bulkLog);
        }
    }

    private void setJobFailed(Job job, BulkOperationResults<String, Exception> bulkLog) {
        try {
            if (this.txProvider != null) {
                this.txProvider.executeInTransaction(() -> {
                    try {
                        this.taskanaEngine.openConnection();
                        BulkOperationResults<String, Exception> bulkOperationResults = this.doSetJobFailed(job, bulkLog);
                        return bulkOperationResults;
                    }
                    finally {
                        this.taskanaEngine.returnConnection();
                    }
                });
            } else {
                this.doSetJobFailed(job, bulkLog);
            }
        }
        catch (Exception e) {
            LOGGER.error("attempted to set job {} to failed, but caught Exception {}", (Object)job, (Object)e);
        }
    }

    private BulkOperationResults<String, Exception> doSetJobFailed(Job job, BulkOperationResults<String, Exception> bulkLog) {
        job.setState(Job.State.FAILED);
        if (job.getStarted() == null) {
            job.setStarted(Instant.now());
        }
        if (bulkLog.containsErrors()) {
            Map<String, Exception> errors = bulkLog.getErrorMap();
            job.setErrors(LoggerUtils.mapToString(errors));
        }
        ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).update(job);
        return null;
    }

    private void handleRetryForFailuresFromBulkOperationResult(BulkOperationResults<String, Exception> bulkLog, Job job, BulkOperationResults<String, Exception> errorLogForThisJob) {
        if (job.getRetryCount() < this.maxRetryCount) {
            List<String> failedTasks;
            if (errorLogForThisJob.containsErrors() && !(failedTasks = errorLogForThisJob.getFailedIds()).isEmpty()) {
                LOGGER.error("Errors occurred when running job {}. Processing will be retried", (Object)job);
                this.scheduleRetryJob(job, failedTasks);
            }
        } else {
            bulkLog.addAllErrors(errorLogForThisJob);
            this.setJobFailed(job, errorLogForThisJob);
        }
    }

    private void rescheduleBisectedJob(BulkOperationResults<String, Exception> bulkLog, Job job) {
        try {
            if (this.txProvider != null) {
                this.txProvider.executeInTransaction(() -> {
                    try {
                        this.taskanaEngine.openConnection();
                        BulkOperationResults<String, Exception> bulkOperationResults = this.doRescheduleBisectedJob(job);
                        return bulkOperationResults;
                    }
                    finally {
                        this.taskanaEngine.returnConnection();
                    }
                });
            } else {
                this.doRescheduleBisectedJob(job);
            }
        }
        catch (Exception e) {
            LOGGER.error("attempted to reschedule bisected jobs for {}, but caught Exception {}", (Object)job, (Object)e);
        }
    }

    private BulkOperationResults<String, Exception> doRescheduleBisectedJob(Job job) {
        if (job.getType().equals((Object)Job.Type.UPDATETASKSJOB)) {
            Map<String, String> args = job.getArguments();
            String taskIdsString = args.get("taskIds");
            List<String> taskIds = Arrays.asList(taskIdsString.split(","));
            int size = taskIds.size();
            if (size >= 2) {
                int halfSize = size % 2 == 0 ? size / 2 : size / 2 + 1;
                List<List<String>> taskIdListsForNewJobs = JobRunner.partition(taskIds, halfSize);
                for (List<String> halfSizedTaskIds : taskIdListsForNewJobs) {
                    Job newJob = new Job();
                    newJob.setCreated(Instant.now());
                    if (halfSize > 1) {
                        newJob.setRetryCount(0);
                    } else {
                        newJob.setRetryCount(job.getRetryCount() + 1);
                    }
                    newJob.setState(Job.State.READY);
                    newJob.setType(job.getType());
                    args.put("taskIds", String.join((CharSequence)",", halfSizedTaskIds));
                    newJob.setArguments(args);
                    newJob.setCreated(Instant.now());
                    newJob.setExecutor(job.getExecutor());
                    ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).insertJob(newJob);
                }
                LOGGER.debug("doRescheduleBisectedJob deleting job {} ", (Object)job);
                ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).delete(job);
            }
        } else {
            job.setState(Job.State.READY);
            job.setRetryCount(job.getRetryCount() + 1);
            ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).update(job);
        }
        return null;
    }

    private void scheduleRetryJob(Job job, List<String> failedTasks) {
        if (job.getType().equals((Object)Job.Type.UPDATETASKSJOB)) {
            try {
                if (this.txProvider != null) {
                    this.txProvider.executeInTransaction(() -> {
                        try {
                            this.taskanaEngine.openConnection();
                            BulkOperationResults<String, Exception> bulkOperationResults = this.doScheduleRetryJob(job, failedTasks);
                            return bulkOperationResults;
                        }
                        finally {
                            this.taskanaEngine.returnConnection();
                        }
                    });
                } else {
                    this.doScheduleRetryJob(job, failedTasks);
                }
            }
            catch (Exception e) {
                LOGGER.error("attempted to reschedule bisected jobs for {}, but caught Exception {}", (Object)job, (Object)e);
            }
        }
    }

    private BulkOperationResults<String, Exception> doScheduleRetryJob(Job job, List<String> failedTasks) {
        LOGGER.debug("entry to doScheduleRetryJob for job {} and failedTasks {}", (Object)job, (Object)LoggerUtils.listToString(failedTasks));
        Map<String, String> args = job.getArguments();
        Job newJob = new Job();
        newJob.setCreated(Instant.now());
        newJob.setRetryCount(job.getRetryCount() + 1);
        newJob.setState(Job.State.READY);
        newJob.setType(job.getType());
        args.put("taskIds", String.join((CharSequence)",", failedTasks));
        newJob.setArguments(args);
        newJob.setExecutor(job.getExecutor());
        ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).insertJob(newJob);
        LOGGER.debug("doScheduleRetryJob deleting job {} and scheduling {} ", (Object)job, (Object)newJob);
        ((JobMapper)this.taskanaEngine.getSqlSession().getMapper(JobMapper.class)).delete(job);
        return null;
    }

    private BulkOperationResults<String, Exception> runSingleJob(Job job) {
        SingleJobExecutor executor;
        LOGGER.debug("entry to runSingleJob(job = {})", (Object)job);
        if (job.getStarted() == null) {
            job.setStarted(Instant.now());
        }
        job.setState(Job.State.RUNNING);
        this.jobMapper.update(job);
        try {
            executor = (SingleJobExecutor)Class.forName(job.getExecutor()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.error("When attempting to load class {} caught Exception {} ", (Object)job.getExecutor(), (Object)e);
            throw new SystemException("When attempting to load class " + job.getExecutor() + " caught Exception " + e.getMessage(), e);
        }
        BulkOperationResults<String, Exception> bulkLog = executor.runSingleJob(job, this.taskanaEngine);
        if (!bulkLog.containsErrors()) {
            LOGGER.debug("runSingleJob deletin job {} ", (Object)job);
            this.jobMapper.delete(job);
        }
        LOGGER.debug("exit from runSingleJob");
        return bulkLog;
    }

    static <T> List<List<T>> partition(Collection<T> members, int maxSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> internal = new ArrayList<T>();
        for (T member : members) {
            internal.add(member);
            if (internal.size() != maxSize) continue;
            result.add(internal);
            internal = new ArrayList();
        }
        if (!internal.isEmpty()) {
            result.add(internal);
        }
        return result;
    }
}

