/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BulkOperationResults;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaTransactionProvider;
import pro.taskana.TimeInterval;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.impl.TaskServiceImpl;

public class JobTaskRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private TaskServiceImpl taskanaService;
    private TaskanaTransactionProvider<BulkOperationResults<String, Exception>> txProvider;
    private int maxRetryOperations = 3;
    private int batchSize = 50;

    public JobTaskRunner(TaskanaEngine taskanaEngine) {
        this.taskanaService = (TaskServiceImpl)taskanaEngine.getTaskService();
    }

    public BulkOperationResults<String, Exception> runCleanCompletedTasks(Instant untilDate) {
        return this.cleanCompletedTasks(untilDate);
    }

    public void registerTransactionProvider(TaskanaTransactionProvider<BulkOperationResults<String, Exception>> txProvider) {
        this.txProvider = txProvider;
    }

    private BulkOperationResults<String, Exception> cleanCompletedTasks(Instant untilDate) {
        LOGGER.info("entry to RunCompletedTasks({})", (Object)untilDate.toString());
        BulkOperationResults<String, Exception> bulkLog = new BulkOperationResults();
        int attempt = 0;
        List<TaskSummary> tasksCompleted = this.getTasksCompleted(untilDate);
        ArrayList<String> tasksIds = new ArrayList<String>();
        while (tasksCompleted.size() != 0 && attempt < this.maxRetryOperations) {
            tasksCompleted.stream().forEach(task -> {
                tasksIds.add(task.getTaskId());
                LOGGER.info("task id to be deleted: {}", (Object)task.getTaskId());
            });
            bulkLog = this.executeTransactionalDeleting(tasksIds);
            attempt = this.getAttempt(bulkLog, attempt);
            tasksCompleted = this.getTasksCompleted(untilDate);
        }
        LOGGER.info("exit from RunCompletedTasks({}). Returning result: " + bulkLog, (Object)untilDate.toString());
        return bulkLog;
    }

    private List<TaskSummary> getTasksCompleted(Instant untilDate) {
        return this.taskanaService.createTaskQuery().completedWithin(new TimeInterval(null, untilDate)).list(0, this.batchSize);
    }

    private BulkOperationResults<String, Exception> executeTransactionalDeleting(List<String> tasksIds) {
        if (this.txProvider == null) {
            return this.doDeleteTasks(tasksIds);
        }
        return this.txProvider.executeInTransaction(() -> this.doDeleteTasks(tasksIds));
    }

    private BulkOperationResults<String, Exception> doDeleteTasks(List<String> tasksIds) {
        if (tasksIds.isEmpty()) {
            return new BulkOperationResults<String, Exception>();
        }
        try {
            return this.taskanaService.deleteTasks(tasksIds).mapBulkOperationResults();
        }
        catch (InvalidArgumentException e) {
            LOGGER.error("could not delete next tasksIds batch: {}, error:" + e.getMessage(), (Object)String.join((CharSequence)",", tasksIds));
            return new BulkOperationResults<String, Exception>();
        }
    }

    private int getAttempt(BulkOperationResults<String, Exception> bulkLog, int attempt) {
        if (!bulkLog.getErrorMap().isEmpty()) {
            return ++attempt;
        }
        return 0;
    }
}

