/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.CategoryReportBuilder;
import pro.taskana.ClassificationReportBuilder;
import pro.taskana.CustomField;
import pro.taskana.CustomFieldValueReportBuilder;
import pro.taskana.TaskState;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.DaysToWorkingDaysConverter;
import pro.taskana.impl.SelectedItem;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketReportBuilderImpl;
import pro.taskana.impl.report.impl.TimeIntervalColumnHeader;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.TaskMonitorMapper;

public abstract class ReportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportBuilder.class);
    private static final String DIMENSION_CLASSIFICATION_CATEGORY = "CLASSIFICATION_CATEGORY";
    private static final String DIMENSION_CLASSIFICATION_KEY = "CLASSIFICATION_KEY";
    private static final String DIMENSION_WORKBASKET_KEY = "WORKBASKET_KEY";
    protected TaskanaEngineImpl taskanaEngine;
    protected TaskMonitorMapper taskMonitorMapper;
    protected List<TimeIntervalColumnHeader> columnHeaders;
    protected boolean inWorkingDays;
    protected List<String> workbasketIds;
    protected List<TaskState> states;
    protected List<String> categories;
    protected List<String> domains;
    protected List<String> classificationIds;
    protected List<String> excludedClassificationIds;
    protected Map<CustomField, String> customAttributeFilter;

    public ReportBuilder(TaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
        this.columnHeaders = Collections.emptyList();
        this.configureDaysToWorkingDaysConverter();
    }

    public List<TimeIntervalColumnHeader> getColumnHeaders() {
        if (this.columnHeaders == null) {
            this.columnHeaders = new ArrayList<TimeIntervalColumnHeader>();
        }
        return this.columnHeaders;
    }

    public boolean isInWorkingDays() {
        return this.inWorkingDays;
    }

    public List<String> getWorkbasketIdIn() {
        if (this.workbasketIds == null) {
            this.workbasketIds = new ArrayList<String>();
        }
        return this.workbasketIds;
    }

    public List<TaskState> getStateIn() {
        if (this.states == null) {
            this.states = new ArrayList<TaskState>();
        }
        return this.states;
    }

    public List<String> getCategoryIn() {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        return this.categories;
    }

    public List<String> getDomainIn() {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        return this.domains;
    }

    public List<String> getClassificationIdsIn() {
        if (this.classificationIds == null) {
            this.classificationIds = new ArrayList<String>();
        }
        return this.classificationIds;
    }

    public List<String> getExcludedClassificationIdsIn() {
        if (this.excludedClassificationIds == null) {
            this.excludedClassificationIds = new ArrayList<String>();
        }
        return this.excludedClassificationIds;
    }

    public Map<CustomField, String> getCustomAttributeFilter() {
        if (this.customAttributeFilter == null) {
            this.customAttributeFilter = new HashMap<CustomField, String>();
        }
        return this.customAttributeFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems) throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("entry to listTaskIdsForSelectedItems(selectedItems = {}), this = {}", (Object)LoggerUtils.listToString(selectedItems), (Object)this);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            List<String> taskIds;
            this.taskanaEngine.openConnection();
            if (this.columnHeaders == null) {
                throw new InvalidArgumentException("ColumnHeader must not be null.");
            }
            if (selectedItems == null || selectedItems.size() == 0) {
                throw new InvalidArgumentException("SelectedItems must not be null or empty.");
            }
            boolean joinWithAttachments = this.subKeyIsSet(selectedItems);
            if (!(this instanceof ClassificationReportBuilder) && joinWithAttachments) {
                throw new InvalidArgumentException("SubKeys are supported for ClassificationReport only.");
            }
            String dimension = this.determineDimension();
            if (this.inWorkingDays) {
                selectedItems = this.convertWorkingDaysToDays(selectedItems, this.columnHeaders);
            }
            List<String> list = taskIds = this.taskMonitorMapper.getTaskIdsForSelectedItems(this.workbasketIds, this.states, this.categories, this.domains, this.classificationIds, this.excludedClassificationIds, this.customAttributeFilter, dimension, selectedItems, joinWithAttachments);
            return list;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from listTaskIdsForSelectedItems().");
        }
    }

    private String determineDimension() {
        String dimension = null;
        if (this instanceof CategoryReportBuilder) {
            dimension = DIMENSION_CLASSIFICATION_CATEGORY;
        } else if (this instanceof WorkbasketReportBuilderImpl) {
            dimension = DIMENSION_WORKBASKET_KEY;
        } else if (this instanceof ClassificationReportBuilder) {
            dimension = DIMENSION_CLASSIFICATION_KEY;
        } else if (this instanceof CustomFieldValueReportBuilder) {
            dimension = ((CustomFieldValueReportBuilder)((Object)this)).getCustomField().toString();
        } else {
            throw new SystemException("Internal error. listTaskIdsForSelectedItems() does not support " + this);
        }
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listCustomAttributeValuesForCustomAttributeName(CustomField customField) throws NotAuthorizedException {
        LOGGER.debug("entry to listCustomAttributeValuesForCustomAttributeName(customField = {}), this = {}", (Object)customField, (Object)this);
        this.taskanaEngine.checkRoleMembership(TaskanaRole.MONITOR);
        try {
            List<String> customAttributeValues;
            this.taskanaEngine.openConnection();
            List<String> list = customAttributeValues = this.taskMonitorMapper.getCustomAttributeValuesForReport(this.workbasketIds, this.states, this.categories, this.domains, this.classificationIds, this.excludedClassificationIds, this.customAttributeFilter, customField);
            return list;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from listCustomAttributeValuesForCustomAttributeName().");
        }
    }

    private void configureDaysToWorkingDaysConverter() {
        DaysToWorkingDaysConverter.setCustomHolidays(this.taskanaEngine.getConfiguration().getCustomHolidays());
        DaysToWorkingDaysConverter.setGermanPublicHolidaysEnabled(this.taskanaEngine.getConfiguration().isGermanPublicHolidaysEnabled());
    }

    private List<SelectedItem> convertWorkingDaysToDays(List<SelectedItem> selectedItems, List<TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException {
        DaysToWorkingDaysConverter instance = DaysToWorkingDaysConverter.initialize(columnHeaders);
        for (SelectedItem selectedItem : selectedItems) {
            selectedItem.setLowerAgeLimit(Collections.min(instance.convertWorkingDaysToDays(selectedItem.getLowerAgeLimit())));
            selectedItem.setUpperAgeLimit(Collections.max(instance.convertWorkingDaysToDays(selectedItem.getUpperAgeLimit())));
        }
        return selectedItems;
    }

    protected boolean subKeyIsSet(List<SelectedItem> selectedItems) {
        for (SelectedItem selectedItem : selectedItems) {
            if (selectedItem.getSubKey() == null || selectedItem.getSubKey().isEmpty()) continue;
            return true;
        }
        return false;
    }
}

