/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.CategoryReportBuilder;
import pro.taskana.ClassificationReportBuilder;
import pro.taskana.CustomField;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskanaEngine;
import pro.taskana.impl.CategoryReportBuilderImpl;
import pro.taskana.impl.ClassificationReportBuilderImpl;
import pro.taskana.impl.CustomFieldValueReportBuilderImpl;
import pro.taskana.impl.TaskStatusReportBuilderImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketReportBuilderImpl;
import pro.taskana.mappings.TaskMonitorMapper;

public class TaskMonitorServiceImpl
implements TaskMonitorService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private TaskanaEngineImpl taskanaEngineImpl;
    private TaskMonitorMapper taskMonitorMapper;

    TaskMonitorServiceImpl(TaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
    }

    @Override
    public WorkbasketReportBuilderImpl createWorkbasketReportBuilder() {
        return new WorkbasketReportBuilderImpl(this.taskanaEngineImpl, this.taskMonitorMapper);
    }

    @Override
    public CategoryReportBuilder createCategoryReportBuilder() {
        return new CategoryReportBuilderImpl(this.taskanaEngineImpl, this.taskMonitorMapper);
    }

    @Override
    public ClassificationReportBuilder createClassificationReportBuilder() {
        return new ClassificationReportBuilderImpl(this.taskanaEngineImpl, this.taskMonitorMapper);
    }

    @Override
    public CustomFieldValueReportBuilderImpl createCustomFieldValueReportBuilder(CustomField customField) {
        return new CustomFieldValueReportBuilderImpl(this.taskanaEngineImpl, this.taskMonitorMapper, customField);
    }

    @Override
    public TaskStatusReportBuilderImpl createTaskStatusReportBuilder() {
        return new TaskStatusReportBuilderImpl(this.taskanaEngineImpl, this.taskMonitorMapper);
    }
}

