/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.TimeInterval;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketSummary;
import pro.taskana.WorkbasketType;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.security.CurrentUserContext;

public class WorkbasketQueryImpl
implements WorkbasketQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.mappings.QueryMapper.queryWorkbasketSummaries";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryWorkbaskets";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.mappings.QueryMapper.queryWorkbasketColumnValues";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private String columnName;
    private String[] accessId;
    private String[] idIn;
    private WorkbasketPermission permission;
    private String[] nameIn;
    private String[] nameLike;
    private String[] keyIn;
    private String[] keyLike;
    private String[] keyOrNameLike;
    private String[] domainIn;
    private String[] domainLike;
    private WorkbasketType[] type;
    private TimeInterval[] createdIn;
    private TimeInterval[] modifiedIn;
    private String[] descriptionLike;
    private String[] ownerIn;
    private String[] ownerLike;
    private String[] custom1In;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4Like;
    private String[] orgLevel1In;
    private String[] orgLevel1Like;
    private String[] orgLevel2In;
    private String[] orgLevel2Like;
    private String[] orgLevel3In;
    private String[] orgLevel3Like;
    private String[] orgLevel4In;
    private String[] orgLevel4Like;
    private TaskanaEngineImpl taskanaEngine;
    private List<String> orderBy;
    private List<String> orderColumns;
    private boolean joinWithAccessList;
    private boolean checkReadPermission;
    private boolean usedToAugmentTasks;
    private boolean callerRolesAndAccessIdsAlreadyHandled;

    WorkbasketQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
        this.callerRolesAndAccessIdsAlreadyHandled = false;
    }

    @Override
    public WorkbasketQuery idIn(String ... id) {
        this.idIn = id;
        return this;
    }

    @Override
    public WorkbasketQuery keyIn(String ... key) {
        this.keyIn = WorkbasketQueryImpl.toUpperCopy(key);
        return this;
    }

    @Override
    public WorkbasketQuery keyLike(String ... keys) {
        this.keyLike = WorkbasketQueryImpl.toUpperCopy(keys);
        return this;
    }

    @Override
    public WorkbasketQuery nameIn(String ... names) {
        this.nameIn = WorkbasketQueryImpl.toUpperCopy(names);
        return this;
    }

    @Override
    public WorkbasketQuery nameLike(String ... names) {
        this.nameLike = WorkbasketQueryImpl.toUpperCopy(names);
        return this;
    }

    @Override
    public WorkbasketQuery keyOrNameLike(String ... keysOrNames) {
        this.keyOrNameLike = WorkbasketQueryImpl.toUpperCopy(keysOrNames);
        return this;
    }

    @Override
    public WorkbasketQuery domainIn(String ... domain) {
        this.domainIn = domain;
        return this;
    }

    @Override
    public WorkbasketQuery domainLike(String ... domain) {
        this.domainLike = domain;
        return this;
    }

    @Override
    public WorkbasketQuery typeIn(WorkbasketType ... type) {
        this.type = type;
        return this;
    }

    @Override
    public WorkbasketQuery createdWithin(TimeInterval ... intervals) {
        this.createdIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public WorkbasketQuery modifiedWithin(TimeInterval ... intervals) {
        this.modifiedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public WorkbasketQuery descriptionLike(String ... description) {
        this.descriptionLike = WorkbasketQueryImpl.toUpperCopy(description);
        return this;
    }

    @Override
    public WorkbasketQuery ownerIn(String ... owners) {
        this.ownerIn = owners;
        return this;
    }

    @Override
    public WorkbasketQuery ownerLike(String ... owners) {
        this.ownerLike = WorkbasketQueryImpl.toUpperCopy(owners);
        return this;
    }

    @Override
    public WorkbasketQuery custom1In(String ... custom1) {
        this.custom1In = custom1;
        return this;
    }

    @Override
    public WorkbasketQuery custom1Like(String ... custom1) {
        this.custom1Like = WorkbasketQueryImpl.toUpperCopy(custom1);
        return this;
    }

    @Override
    public WorkbasketQuery custom2In(String ... custom2) {
        this.custom2In = custom2;
        return this;
    }

    @Override
    public WorkbasketQuery custom2Like(String ... custom2) {
        this.custom2Like = WorkbasketQueryImpl.toUpperCopy(custom2);
        return this;
    }

    @Override
    public WorkbasketQuery custom3In(String ... custom3) {
        this.custom3In = custom3;
        return this;
    }

    @Override
    public WorkbasketQuery custom3Like(String ... custom3) {
        this.custom3Like = WorkbasketQueryImpl.toUpperCopy(custom3);
        return this;
    }

    @Override
    public WorkbasketQuery custom4In(String ... custom4) {
        this.custom4In = custom4;
        return this;
    }

    @Override
    public WorkbasketQuery custom4Like(String ... custom4) {
        this.custom4Like = WorkbasketQueryImpl.toUpperCopy(custom4);
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel1In(String ... orgLevel1) {
        this.orgLevel1In = orgLevel1;
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel1Like(String ... orgLevel1) {
        this.orgLevel1Like = WorkbasketQueryImpl.toUpperCopy(orgLevel1);
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel2In(String ... orgLevel2) {
        this.orgLevel2In = orgLevel2;
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel2Like(String ... orgLevel2) {
        this.orgLevel2Like = WorkbasketQueryImpl.toUpperCopy(orgLevel2);
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel3In(String ... orgLevel3) {
        this.orgLevel3In = orgLevel3;
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel3Like(String ... orgLevel3) {
        this.orgLevel3Like = WorkbasketQueryImpl.toUpperCopy(orgLevel3);
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel4In(String ... orgLevel4) {
        this.orgLevel4In = orgLevel4;
        return this;
    }

    @Override
    public WorkbasketQuery orgLevel4Like(String ... orgLevel4) {
        this.orgLevel4Like = WorkbasketQueryImpl.toUpperCopy(orgLevel4);
        return this;
    }

    @Override
    public WorkbasketQuery orderByName(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NAME", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("KEY", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByDescription(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DESCRIPTION", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByOwner(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("OWNER", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("TYPE", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByCustom1(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_1", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByCustom2(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_2", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByCustom3(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_3", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByCustom4(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CUSTOM_4", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByOrgLevel1(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ORG_LEVEL_1", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByOrgLevel2(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ORG_LEVEL_2", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByOrgLevel3(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ORG_LEVEL_3", sortDirection);
    }

    @Override
    public WorkbasketQuery orderByOrgLevel4(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ORG_LEVEL_4", sortDirection);
    }

    @Override
    public WorkbasketQuery accessIdsHavePermission(WorkbasketPermission permission, String ... accessIds) throws InvalidArgumentException, NotAuthorizedException {
        this.taskanaEngine.checkRoleMembership(TaskanaRole.ADMIN, TaskanaRole.BUSINESS_ADMIN);
        if (permission == null) {
            throw new InvalidArgumentException("Permission can\u00b4t be null.");
        }
        if (accessIds == null || accessIds.length == 0) {
            throw new InvalidArgumentException("accessIds can\u00b4t be NULL or empty.");
        }
        this.permission = permission;
        this.accessId = accessIds;
        WorkbasketQueryImpl.lowercaseAccessIds(this.accessId);
        return this;
    }

    @Override
    public WorkbasketQuery callerHasPermission(WorkbasketPermission permission) {
        this.permission = permission;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketSummary> list() {
        ArrayList<WorkbasketSummary> arrayList;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        ArrayList<WorkbasketSummary> workbaskets = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.handleCallerRolesAndAccessIds();
            arrayList = workbaskets = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(String columnName, BaseQuery.SortDirection sortDirection) {
        ArrayList<String> arrayList;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        ArrayList<String> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.handleCallerRolesAndAccessIds();
            this.orderBy.clear();
            this.addOrderCriteria(columnName, sortDirection);
            arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<WorkbasketSummary> list(int offset, int limit) {
        ArrayList<WorkbasketSummary> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<WorkbasketSummary> workbaskets = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            this.handleCallerRolesAndAccessIds();
            arrayList = workbaskets = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngine.returnConnection();
        }
        catch (PersistenceException e) {
            try {
                if (e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = workbaskets == null ? 0 : workbaskets.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(workbaskets));
        }
        return arrayList;
    }

    @Override
    public WorkbasketSummary single() {
        WorkbasketSummary workbasketSummary;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketSummary workbasket = null;
        try {
            this.taskanaEngine.openConnection();
            this.handleCallerRolesAndAccessIds();
            workbasketSummary = workbasket = (WorkbasketSummary)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", workbasket);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)workbasket);
        return workbasketSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            this.handleCallerRolesAndAccessIds();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public String[] getAccessId() {
        return this.accessId;
    }

    public WorkbasketPermission getPermission() {
        return this.permission;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String[] getKeyIn() {
        return this.keyIn;
    }

    public String[] getKeyLike() {
        return this.keyLike;
    }

    public String[] getKeyOrNameLike() {
        return this.keyOrNameLike;
    }

    public WorkbasketType[] getType() {
        return this.type;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public TimeInterval[] getModifiedIn() {
        return this.modifiedIn;
    }

    public String[] getDescriptionLike() {
        return this.descriptionLike;
    }

    public String[] getOwnerIn() {
        return this.ownerIn;
    }

    public String[] getDomainIn() {
        return this.domainIn;
    }

    public String[] getDomainLike() {
        return this.domainLike;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getOrgLevel1In() {
        return this.orgLevel1In;
    }

    public String[] getOrgLevel1Like() {
        return this.orgLevel1Like;
    }

    public String[] getOrgLevel2In() {
        return this.orgLevel2In;
    }

    public String[] getOrgLevel2Like() {
        return this.orgLevel2Like;
    }

    public String[] getOrgLevel3In() {
        return this.orgLevel3In;
    }

    public String[] getOrgLevel3Like() {
        return this.orgLevel3Like;
    }

    public String[] getOrgLevel4In() {
        return this.orgLevel4In;
    }

    public String[] getOrgLevel4Like() {
        return this.orgLevel4Like;
    }

    public String[] getOwnerLike() {
        return this.ownerLike;
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isJoinWithAccessList() {
        return this.joinWithAccessList;
    }

    public boolean isCheckReadPermission() {
        return this.checkReadPermission;
    }

    void setUsedToAugmentTasks(boolean usedToAugmentTasks) {
        this.usedToAugmentTasks = usedToAugmentTasks;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketQueryImpl [columnName=");
        builder.append(this.columnName);
        builder.append(", accessId=");
        builder.append(Arrays.toString(this.accessId));
        builder.append(", idIn=");
        builder.append(Arrays.toString(this.idIn));
        builder.append(", permission=");
        builder.append((Object)this.permission);
        builder.append(", nameIn=");
        builder.append(Arrays.toString(this.nameIn));
        builder.append(", nameLike=");
        builder.append(Arrays.toString(this.nameLike));
        builder.append(", keyIn=");
        builder.append(Arrays.toString(this.keyIn));
        builder.append(", keyLike=");
        builder.append(Arrays.toString(this.keyLike));
        builder.append(", keyOrNameLike=");
        builder.append(Arrays.toString(this.keyOrNameLike));
        builder.append(", domainIn=");
        builder.append(Arrays.toString(this.domainIn));
        builder.append(", domainLike=");
        builder.append(Arrays.toString(this.domainLike));
        builder.append(", type=");
        builder.append(Arrays.toString((Object[])this.type));
        builder.append(", createdIn=");
        builder.append(Arrays.toString(this.createdIn));
        builder.append(", modifiedIn=");
        builder.append(Arrays.toString(this.modifiedIn));
        builder.append(", descriptionLike=");
        builder.append(Arrays.toString(this.descriptionLike));
        builder.append(", ownerIn=");
        builder.append(Arrays.toString(this.ownerIn));
        builder.append(", ownerLike=");
        builder.append(Arrays.toString(this.ownerLike));
        builder.append(", custom1In=");
        builder.append(Arrays.toString(this.custom1In));
        builder.append(", custom1Like=");
        builder.append(Arrays.toString(this.custom1Like));
        builder.append(", custom2In=");
        builder.append(Arrays.toString(this.custom2In));
        builder.append(", custom2Like=");
        builder.append(Arrays.toString(this.custom2Like));
        builder.append(", custom3In=");
        builder.append(Arrays.toString(this.custom3In));
        builder.append(", custom3Like=");
        builder.append(Arrays.toString(this.custom3Like));
        builder.append(", custom4In=");
        builder.append(Arrays.toString(this.custom4In));
        builder.append(", custom4Like=");
        builder.append(Arrays.toString(this.custom4Like));
        builder.append(", orgLevel1In=");
        builder.append(Arrays.toString(this.orgLevel1In));
        builder.append(", orgLevel1Like=");
        builder.append(Arrays.toString(this.orgLevel1Like));
        builder.append(", orgLevel2In=");
        builder.append(Arrays.toString(this.orgLevel2In));
        builder.append(", orgLevel2Like=");
        builder.append(Arrays.toString(this.orgLevel2Like));
        builder.append(", orgLevel3In=");
        builder.append(Arrays.toString(this.orgLevel3In));
        builder.append(", orgLevel3Like=");
        builder.append(Arrays.toString(this.orgLevel3Like));
        builder.append(", orgLevel4In=");
        builder.append(Arrays.toString(this.orgLevel4In));
        builder.append(", orgLevel4Like=");
        builder.append(Arrays.toString(this.orgLevel4Like));
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append(", joinWithAccessList=");
        builder.append(this.joinWithAccessList);
        builder.append(", checkReadPermission=");
        builder.append(this.checkReadPermission);
        builder.append(", usedToAugmentTasks=");
        builder.append(this.usedToAugmentTasks);
        builder.append("]");
        return builder.toString();
    }

    private void handleCallerRolesAndAccessIds() {
        if (!this.callerRolesAndAccessIdsAlreadyHandled) {
            this.callerRolesAndAccessIdsAlreadyHandled = true;
            this.joinWithAccessList = true;
            this.checkReadPermission = true;
            if (this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN) || this.taskanaEngine.isUserInRole(TaskanaRole.BUSINESS_ADMIN) && !this.usedToAugmentTasks) {
                this.checkReadPermission = false;
                if (this.accessId == null && this.permission == null) {
                    this.joinWithAccessList = false;
                }
            }
            if (this.accessId == null) {
                String[] accessIds = new String[]{};
                List<String> ucAccessIds = CurrentUserContext.getAccessIds();
                if (ucAccessIds != null && !ucAccessIds.isEmpty()) {
                    accessIds = new String[ucAccessIds.size()];
                    accessIds = ucAccessIds.toArray(accessIds);
                }
                this.accessId = accessIds;
                WorkbasketQueryImpl.lowercaseAccessIds(this.accessId);
            }
        }
        LOGGER.debug("exit from handleCallerRolesAndAccessIds, now this is {}", (Object)this);
    }

    static void lowercaseAccessIds(String[] accessIdArray) {
        if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds()) {
            for (int i = 0; i < accessIdArray.length; ++i) {
                String id = accessIdArray[i];
                if (id == null) continue;
                accessIdArray[i] = id.toLowerCase();
            }
        }
    }

    static String[] toUpperCopy(String ... source) {
        if (source == null || source.length == 0) {
            return null;
        }
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }

    private WorkbasketQuery addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " ASC";
        if (sortDirection != null && BaseQuery.SortDirection.DESCENDING.equals((Object)sortDirection)) {
            orderByDirection = " DESC";
        }
        this.orderBy.add(colName + orderByDirection);
        this.orderColumns.add(colName);
        return this;
    }
}

