/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.jobs;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BulkOperationResults;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.TimeInterval;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.TaskanaException;
import pro.taskana.jobs.AbstractTaskanaJob;
import pro.taskana.jobs.ScheduledJob;

public class TaskCleanupJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCleanupJob.class);
    private Instant firstRun;
    private Duration runEvery;
    private Duration minimumAge;

    public TaskCleanupJob(TaskanaEngine taskanaEngine, ScheduledJob scheduledJob) {
        super(taskanaEngine, scheduledJob);
        this.firstRun = taskanaEngine.getConfiguration().getTaskCleanupJobFirstRun();
        this.runEvery = taskanaEngine.getConfiguration().getTaskCleanupJobRunEvery();
        this.minimumAge = taskanaEngine.getConfiguration().getTaskCleanupJobMinimumAge();
    }

    @Override
    public void run() throws TaskanaException {
        Instant completedBefore = Instant.now().minus(this.minimumAge);
        LOGGER.info("Running job to delete all tasks completed before ({})", (Object)completedBefore.toString());
        try {
            List<TaskSummary> tasksCompletedBefore = this.getTasksCompletedBefore(completedBefore);
            this.deleteTasks(tasksCompletedBefore);
            this.scheduleNextCleanupJob();
            LOGGER.info("Job ended successfully.");
        }
        catch (InvalidArgumentException e) {
            throw new TaskanaException("Error while processing TaskCleanupJob.", e);
        }
    }

    private List<TaskSummary> getTasksCompletedBefore(Instant untilDate) {
        return this.taskanaEngineImpl.getTaskService().createTaskQuery().completedWithin(new TimeInterval(null, untilDate)).list();
    }

    private void deleteTasks(List<TaskSummary> tasksToBeDeleted) throws InvalidArgumentException {
        List<String> tasksIdsToBeDeleted = tasksToBeDeleted.stream().map(task -> task.getTaskId()).collect(Collectors.toList());
        BulkOperationResults<String, TaskanaException> results = this.taskanaEngineImpl.getTaskService().deleteTasks(tasksIdsToBeDeleted);
        LOGGER.info("{} tasks deleted.", (Object)(tasksIdsToBeDeleted.size() - results.getFailedIds().size()));
        for (String failedId : results.getFailedIds()) {
            LOGGER.warn("Task with id {} could not be deleted. Reason: {}", (Object)failedId, (Object)results.getErrorForId(failedId));
        }
    }

    public void scheduleNextCleanupJob() {
        LOGGER.debug("Entry to scheduleNextCleanupJob.");
        ScheduledJob job = new ScheduledJob();
        job.setType(ScheduledJob.Type.TASKCLEANUPJOB);
        job.setDue(this.getNextDueForTaskCleanupJob());
        this.taskanaEngineImpl.getJobService().createJob(job);
        LOGGER.debug("Exit from scheduleNextCleanupJob.");
    }

    private Instant getNextDueForTaskCleanupJob() {
        Instant nextRunAt = this.firstRun;
        while (nextRunAt.isBefore(Instant.now())) {
            nextRunAt = nextRunAt.plus(this.runEvery);
        }
        LOGGER.info("Scheduling next run of the TaskCleanupJob for {}", (Object)nextRunAt);
        return nextRunAt;
    }

    public static void initializeSchedule(TaskanaEngine taskanaEngine) {
        TaskCleanupJob job = new TaskCleanupJob(taskanaEngine, null);
        job.scheduleNextCleanupJob();
    }
}

