/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.jobs;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.TaskanaException;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.jobs.AbstractTaskanaJob;
import pro.taskana.jobs.ScheduledJob;

public class TaskRefreshJob
extends AbstractTaskanaJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRefreshJob.class);
    public static final String ARG_TASK_IDS = "taskIds";
    private List<String> affectedTaskIds;

    public TaskRefreshJob(TaskanaEngine engine, ScheduledJob job) {
        super(engine, job);
        Map<String, String> args = job.getArguments();
        String taskIdsString = args.get(ARG_TASK_IDS);
        this.affectedTaskIds = Arrays.asList(taskIdsString.split(","));
    }

    @Override
    public void run() throws TaskanaException {
        LOGGER.info("Running TaskRefreshJob for {} tasks", (Object)this.affectedTaskIds.size());
        try {
            TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
            for (String taskId : this.affectedTaskIds) {
                try {
                    taskService.refreshPriorityAndDueDate(taskId);
                }
                catch (Exception e) {
                    LOGGER.warn("Task {} could not be refreshed because of exception: {}", (Object)taskId, (Object)e.getMessage());
                }
            }
            LOGGER.info("TaskRefreshJob ended successfully.");
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing TaskRefreshJob.", e);
        }
    }
}

