/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.ClassificationQuery;
import pro.taskana.ClassificationSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.TimeInterval;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;

public class ClassificationQueryImpl
implements ClassificationQuery {
    private static final String LINK_TO_SUMMARYMAPPER = "pro.taskana.mappings.QueryMapper.queryClassificationSummaries";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryClassifications";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.mappings.QueryMapper.queryClassificationColumnValues";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationQueryImpl.class);
    private TaskanaEngineImpl taskanaEngine;
    private String columnName;
    private String[] key;
    private String[] idIn;
    private String[] parentId;
    private String[] parentKey;
    private String[] category;
    private String[] type;
    private String[] domain;
    private Boolean validInDomain;
    private TimeInterval[] createdIn;
    private TimeInterval[] modifiedIn;
    private String[] nameIn;
    private String[] nameLike;
    private String descriptionLike;
    private int[] priority;
    private String[] serviceLevelIn;
    private String[] serviceLevelLike;
    private String[] applicationEntryPointIn;
    private String[] applicationEntryPointLike;
    private String[] custom1In;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4Like;
    private String[] custom5In;
    private String[] custom5Like;
    private String[] custom6In;
    private String[] custom6Like;
    private String[] custom7In;
    private String[] custom7Like;
    private String[] custom8In;
    private String[] custom8Like;
    private List<String> orderBy;
    private List<String> orderColumns;

    ClassificationQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
    }

    @Override
    public ClassificationQuery keyIn(String ... key) {
        this.key = key;
        return this;
    }

    @Override
    public ClassificationQuery idIn(String ... id) {
        this.idIn = id;
        return this;
    }

    @Override
    public ClassificationQuery parentIdIn(String ... parentId) {
        this.parentId = parentId;
        return this;
    }

    @Override
    public ClassificationQuery parentKeyIn(String ... parentKey) {
        this.parentKey = parentKey;
        return this;
    }

    @Override
    public ClassificationQuery categoryIn(String ... category) {
        this.category = category;
        return this;
    }

    @Override
    public ClassificationQuery typeIn(String ... type) {
        this.type = type;
        return this;
    }

    @Override
    public ClassificationQuery domainIn(String ... domain) {
        this.domain = domain;
        return this;
    }

    @Override
    public ClassificationQuery validInDomainEquals(Boolean validInDomain) {
        this.validInDomain = validInDomain;
        return this;
    }

    @Override
    public ClassificationQuery createdWithin(TimeInterval ... createdIn) {
        this.createdIn = createdIn;
        for (TimeInterval ti : createdIn) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public ClassificationQuery modifiedWithin(TimeInterval ... modifiedIn) {
        this.modifiedIn = modifiedIn;
        for (TimeInterval ti : modifiedIn) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException("TimeInterval " + ti + " is invalid.");
        }
        return this;
    }

    @Override
    public ClassificationQuery nameIn(String ... nameIn) {
        this.nameIn = nameIn;
        return this;
    }

    @Override
    public ClassificationQuery nameLike(String ... nameLike) {
        this.nameLike = this.toUpperCopy(nameLike);
        return this;
    }

    @Override
    public ClassificationQuery descriptionLike(String description) {
        this.descriptionLike = description.toUpperCase();
        return this;
    }

    @Override
    public ClassificationQuery priorityIn(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public ClassificationQuery serviceLevelIn(String ... serviceLevelIn) {
        this.serviceLevelIn = serviceLevelIn;
        return this;
    }

    @Override
    public ClassificationQuery serviceLevelLike(String ... serviceLevelLike) {
        this.serviceLevelLike = this.toUpperCopy(serviceLevelLike);
        return this;
    }

    @Override
    public ClassificationQuery applicationEntryPointIn(String ... applicationEntryPointIn) {
        this.applicationEntryPointIn = applicationEntryPointIn;
        return this;
    }

    @Override
    public ClassificationQuery applicationEntryPointLike(String ... applicationEntryPointLike) {
        this.applicationEntryPointLike = this.toUpperCopy(applicationEntryPointLike);
        return this;
    }

    @Override
    public ClassificationQuery customAttributeIn(String number, String ... customIn) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute cannot be converted to a number between 1 and 16", e.getCause());
        }
        if (customIn.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (num) {
            case 1: {
                this.custom1In = customIn;
                break;
            }
            case 2: {
                this.custom2In = customIn;
                break;
            }
            case 3: {
                this.custom3In = customIn;
                break;
            }
            case 4: {
                this.custom4In = customIn;
                break;
            }
            case 5: {
                this.custom5In = customIn;
                break;
            }
            case 6: {
                this.custom6In = customIn;
                break;
            }
            case 7: {
                this.custom7In = customIn;
                break;
            }
            case 8: {
                this.custom8In = customIn;
                break;
            }
            default: {
                throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute does not represent a number between 1 and 8");
            }
        }
        return this;
    }

    @Override
    public ClassificationQuery customAttributeLike(String number, String ... customLike) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute cannot be converted to a number between 1 and 16", e.getCause());
        }
        if (customLike.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (num) {
            case 1: {
                this.custom1Like = this.toUpperCopy(customLike);
                break;
            }
            case 2: {
                this.custom2Like = this.toUpperCopy(customLike);
                break;
            }
            case 3: {
                this.custom3Like = this.toUpperCopy(customLike);
                break;
            }
            case 4: {
                this.custom4Like = this.toUpperCopy(customLike);
                break;
            }
            case 5: {
                this.custom5Like = this.toUpperCopy(customLike);
                break;
            }
            case 6: {
                this.custom6Like = this.toUpperCopy(customLike);
                break;
            }
            case 7: {
                this.custom7Like = this.toUpperCopy(customLike);
                break;
            }
            case 8: {
                this.custom8Like = this.toUpperCopy(customLike);
                break;
            }
            default: {
                throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute does not represent a number between 1 and 16");
            }
        }
        return this;
    }

    @Override
    public ClassificationQuery orderByKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("KEY", sortDirection);
    }

    @Override
    public ClassificationQuery orderByParentId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_ID", sortDirection);
    }

    @Override
    public ClassificationQuery orderByParentKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_KEY", sortDirection);
    }

    @Override
    public ClassificationQuery orderByCategory(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CATEGORY", sortDirection);
    }

    @Override
    public ClassificationQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public ClassificationQuery orderByPriority(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PRIORITY", sortDirection);
    }

    @Override
    public ClassificationQuery orderByName(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NAME", sortDirection);
    }

    @Override
    public ClassificationQuery orderByServiceLevel(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("SERVICE_LEVEL", sortDirection);
    }

    @Override
    public ClassificationQuery orderByApplicationEntryPoint(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("APPLICATION_ENTRY_POINT", sortDirection);
    }

    @Override
    public ClassificationQuery orderByCustomAttribute(String number, BaseQuery.SortDirection sortDirection) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute cannot be converted to a number between 1 and 16", e.getCause());
        }
        switch (num) {
            case 1: {
                return this.addOrderCriteria("CUSTOM_1", sortDirection);
            }
            case 2: {
                return this.addOrderCriteria("CUSTOM_2", sortDirection);
            }
            case 3: {
                return this.addOrderCriteria("CUSTOM_3", sortDirection);
            }
            case 4: {
                return this.addOrderCriteria("CUSTOM_4", sortDirection);
            }
            case 5: {
                return this.addOrderCriteria("CUSTOM_5", sortDirection);
            }
            case 6: {
                return this.addOrderCriteria("CUSTOM_6", sortDirection);
            }
            case 7: {
                return this.addOrderCriteria("CUSTOM_7", sortDirection);
            }
            case 8: {
                return this.addOrderCriteria("CUSTOM_8", sortDirection);
            }
        }
        throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute does not represent a number between 1 and 16");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ClassificationSummary> list() {
        List<ClassificationSummary> list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List<ClassificationSummary> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            list = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_SUMMARYMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public List<ClassificationSummary> list(int offset, int limit) {
        ArrayList<ClassificationSummary> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<ClassificationSummary> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_SUMMARYMAPPER, (Object)this, rowBounds);
            this.taskanaEngine.returnConnection();
        }
        catch (Exception e) {
            try {
                if (e instanceof PersistenceException && e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(String columnName, BaseQuery.SortDirection sortDirection) {
        ArrayList<String> arrayList;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        ArrayList<String> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName, sortDirection);
            arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public ClassificationSummary single() {
        ClassificationSummary classificationSummary;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        ClassificationSummary result = null;
        try {
            this.taskanaEngine.openConnection();
            classificationSummary = result = (ClassificationSummary)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_SUMMARYMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return classificationSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private ClassificationQuery addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " ASC";
        if (sortDirection != null && BaseQuery.SortDirection.DESCENDING.equals((Object)sortDirection)) {
            orderByDirection = " DESC";
        }
        this.orderBy.add(columnName + orderByDirection);
        this.orderColumns.add(columnName);
        return this;
    }

    public String[] getKey() {
        return this.key;
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getparentId() {
        return this.parentId;
    }

    public String[] getparentKey() {
        return this.parentKey;
    }

    public String[] getCategory() {
        return this.category;
    }

    public String[] getType() {
        return this.type;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String getDescriptionLike() {
        return this.descriptionLike;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public String[] getServiceLevelIn() {
        return this.serviceLevelIn;
    }

    public String[] getServiceLevelLike() {
        return this.serviceLevelLike;
    }

    public String[] getDomain() {
        return this.domain;
    }

    public Boolean getValidInDomain() {
        return this.validInDomain;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public TimeInterval[] getModifiedIn() {
        return this.modifiedIn;
    }

    public String[] getApplicationEntryPointIn() {
        return this.applicationEntryPointIn;
    }

    public String[] getApplicationEntryPointLike() {
        return this.applicationEntryPointLike;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getCustom5In() {
        return this.custom5In;
    }

    public String[] getCustom5Like() {
        return this.custom5Like;
    }

    public String[] getCustom6In() {
        return this.custom6In;
    }

    public String[] getCustom6Like() {
        return this.custom6Like;
    }

    public String[] getCustom7In() {
        return this.custom7In;
    }

    public String[] getCustom7Like() {
        return this.custom7Like;
    }

    public String[] getCustom8In() {
        return this.custom8In;
    }

    public String[] getCustom8Like() {
        return this.custom8Like;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    private String[] toUpperCopy(String ... source) {
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClassificationQueryImpl [columnName=");
        builder.append(this.columnName);
        builder.append(", key=");
        builder.append(Arrays.toString(this.key));
        builder.append(", idIn=");
        builder.append(Arrays.toString(this.idIn));
        builder.append(", parentId=");
        builder.append(Arrays.toString(this.parentId));
        builder.append(", parentKey=");
        builder.append(Arrays.toString(this.parentKey));
        builder.append(", category=");
        builder.append(Arrays.toString(this.category));
        builder.append(", type=");
        builder.append(Arrays.toString(this.type));
        builder.append(", domain=");
        builder.append(Arrays.toString(this.domain));
        builder.append(", validInDomain=");
        builder.append(this.validInDomain);
        builder.append(", createdIn=");
        builder.append(Arrays.toString(this.createdIn));
        builder.append(", modifiedIn=");
        builder.append(Arrays.toString(this.modifiedIn));
        builder.append(", nameIn=");
        builder.append(Arrays.toString(this.nameIn));
        builder.append(", nameLike=");
        builder.append(Arrays.toString(this.nameLike));
        builder.append(", descriptionLike=");
        builder.append(this.descriptionLike);
        builder.append(", priority=");
        builder.append(Arrays.toString(this.priority));
        builder.append(", serviceLevelIn=");
        builder.append(Arrays.toString(this.serviceLevelIn));
        builder.append(", serviceLevelLike=");
        builder.append(Arrays.toString(this.serviceLevelLike));
        builder.append(", applicationEntryPointIn=");
        builder.append(Arrays.toString(this.applicationEntryPointIn));
        builder.append(", applicationEntryPointLike=");
        builder.append(Arrays.toString(this.applicationEntryPointLike));
        builder.append(", custom1In=");
        builder.append(Arrays.toString(this.custom1In));
        builder.append(", custom1Like=");
        builder.append(Arrays.toString(this.custom1Like));
        builder.append(", custom2In=");
        builder.append(Arrays.toString(this.custom2In));
        builder.append(", custom2Like=");
        builder.append(Arrays.toString(this.custom2Like));
        builder.append(", custom3In=");
        builder.append(Arrays.toString(this.custom3In));
        builder.append(", custom3Like=");
        builder.append(Arrays.toString(this.custom3Like));
        builder.append(", custom4In=");
        builder.append(Arrays.toString(this.custom4In));
        builder.append(", custom4Like=");
        builder.append(Arrays.toString(this.custom4Like));
        builder.append(", custom5In=");
        builder.append(Arrays.toString(this.custom5In));
        builder.append(", custom5Like=");
        builder.append(Arrays.toString(this.custom5Like));
        builder.append(", custom6In=");
        builder.append(Arrays.toString(this.custom6In));
        builder.append(", custom6Like=");
        builder.append(Arrays.toString(this.custom6Like));
        builder.append(", custom7In=");
        builder.append(Arrays.toString(this.custom7In));
        builder.append(", custom7Like=");
        builder.append(Arrays.toString(this.custom7Like));
        builder.append(", custom8In=");
        builder.append(Arrays.toString(this.custom8In));
        builder.append(", custom8Like=");
        builder.append(Arrays.toString(this.custom8Like));
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }
}

