/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.KeyDomain;
import pro.taskana.ObjectReferenceQuery;
import pro.taskana.TaskQuery;
import pro.taskana.TaskState;
import pro.taskana.TaskSummary;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.TimeInterval;
import pro.taskana.WorkbasketPermission;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.NotAuthorizedToQueryWorkbasketException;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.exceptions.WorkbasketNotFoundException;
import pro.taskana.impl.ObjectReferenceQueryImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.security.CurrentUserContext;

public class TaskQueryImpl
implements TaskQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.mappings.QueryMapper.queryTaskSummaries";
    private static final String LINK_TO_MAPPER_DB2 = "pro.taskana.mappings.QueryMapper.queryTaskSummariesDb2";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryTasks";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.mappings.QueryMapper.queryTaskColumnValues";
    private static final String TIME_INTERVAL = "TimeInterval ";
    private static final String IS_INVALID = " is invalid.";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskQueryImpl.class);
    private TaskanaEngineImpl taskanaEngine;
    private TaskServiceImpl taskService;
    private String columnName;
    private String[] nameIn;
    private String[] nameLike;
    private String[] creatorIn;
    private String[] creatorLike;
    private String[] taskIds;
    private String[] description;
    private String[] note;
    private String[] noteLike;
    private int[] priority;
    private KeyDomain[] workbasketKeyDomainIn;
    private String[] workbasketIdIn;
    private TaskState[] stateIn;
    private String[] classificationIdIn;
    private String[] classificationKeyIn;
    private String[] classificationKeyLike;
    private String[] classificationKeyNotIn;
    private String[] classificationCategoryIn;
    private String[] classificationCategoryLike;
    private String[] ownerIn;
    private String[] ownerLike;
    private Boolean isRead;
    private Boolean isTransferred;
    private String[] porCompanyIn;
    private String[] porCompanyLike;
    private String[] porSystemIn;
    private String[] porSystemLike;
    private String[] porSystemInstanceIn;
    private String[] porSystemInstanceLike;
    private String[] porTypeIn;
    private String[] porTypeLike;
    private String[] porValueIn;
    private String[] porValueLike;
    private String[] parentBusinessProcessIdIn;
    private String[] parentBusinessProcessIdLike;
    private String[] businessProcessIdIn;
    private String[] businessProcessIdLike;
    private String[] custom1In;
    private String[] custom1Like;
    private String[] custom2In;
    private String[] custom2Like;
    private String[] custom3In;
    private String[] custom3Like;
    private String[] custom4In;
    private String[] custom4Like;
    private String[] custom5In;
    private String[] custom5Like;
    private String[] custom6In;
    private String[] custom6Like;
    private String[] custom7In;
    private String[] custom7Like;
    private String[] custom8In;
    private String[] custom8Like;
    private String[] custom9In;
    private String[] custom9Like;
    private String[] custom10In;
    private String[] custom10Like;
    private String[] custom11In;
    private String[] custom11Like;
    private String[] custom12In;
    private String[] custom12Like;
    private String[] custom13In;
    private String[] custom13Like;
    private String[] custom14In;
    private String[] custom14Like;
    private String[] custom15In;
    private String[] custom15Like;
    private String[] custom16In;
    private String[] custom16Like;
    private String[] attachmentClassificationKeyIn;
    private String[] attachmentClassificationKeyLike;
    private String[] attachmentClassificationIdIn;
    private String[] attachmentClassificationIdLike;
    private String[] attachmentChannelIn;
    private String[] attachmentChannelLike;
    private String[] attachmentReferenceIn;
    private String[] attachmentReferenceLike;
    private TimeInterval[] attachmentReceivedIn;
    private String[] accessIdIn;
    private boolean filterByAccessIdIn;
    private TimeInterval[] createdIn;
    private TimeInterval[] claimedIn;
    private TimeInterval[] completedIn;
    private TimeInterval[] modifiedIn;
    private TimeInterval[] plannedIn;
    private TimeInterval[] dueIn;
    private List<String> orderBy;
    private List<String> orderColumns;
    private boolean joinWithAttachments = false;
    private boolean addAttachmentColumnsToSelectClauseForOrdering = false;

    TaskQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.taskService = (TaskServiceImpl)taskanaEngine.getTaskService();
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
        this.filterByAccessIdIn = true;
    }

    @Override
    public TaskQuery idIn(String ... taskIds) {
        this.taskIds = taskIds;
        return this;
    }

    @Override
    public TaskQuery nameIn(String ... names) {
        this.nameIn = names;
        return this;
    }

    @Override
    public TaskQuery nameLike(String ... names) {
        this.nameLike = this.toUpperCopy(names);
        return this;
    }

    @Override
    public TaskQuery creatorIn(String ... creators) {
        this.creatorIn = creators;
        return this;
    }

    @Override
    public TaskQuery creatorLike(String ... creators) {
        this.creatorLike = this.toUpperCopy(creators);
        return this;
    }

    @Override
    public TaskQuery createdWithin(TimeInterval ... intervals) {
        this.createdIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery claimedWithin(TimeInterval ... intervals) {
        this.claimedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery completedWithin(TimeInterval ... intervals) {
        this.completedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery modifiedWithin(TimeInterval ... intervals) {
        this.modifiedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery plannedWithin(TimeInterval ... intervals) {
        this.plannedIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery dueWithin(TimeInterval ... intervals) {
        this.dueIn = intervals;
        for (TimeInterval ti : intervals) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery descriptionLike(String ... description) {
        this.description = this.toUpperCopy(description);
        return this;
    }

    @Override
    public TaskQuery noteLike(String ... note) {
        this.noteLike = this.toUpperCopy(note);
        return this;
    }

    @Override
    public TaskQuery priorityIn(int ... priorities) {
        this.priority = priorities;
        return this;
    }

    @Override
    public TaskQuery workbasketKeyDomainIn(KeyDomain ... workbasketIdentifiers) {
        this.workbasketKeyDomainIn = workbasketIdentifiers;
        return this;
    }

    @Override
    public TaskQuery workbasketIdIn(String ... workbasketIds) {
        this.workbasketIdIn = workbasketIds;
        return this;
    }

    @Override
    public TaskQuery classificationKeyIn(String ... classificationKey) {
        this.classificationKeyIn = classificationKey;
        return this;
    }

    @Override
    public TaskQuery classificationKeyNotIn(String ... classificationKeys) {
        this.classificationKeyNotIn = classificationKeys;
        return this;
    }

    @Override
    public TaskQuery classificationKeyLike(String ... classificationKeys) {
        this.classificationKeyLike = this.toUpperCopy(classificationKeys);
        return this;
    }

    @Override
    public TaskQuery classificationIdIn(String ... classificationId) {
        this.classificationIdIn = classificationId;
        return this;
    }

    @Override
    public TaskQuery classificationCategoryIn(String ... classificationCategories) {
        this.classificationCategoryIn = classificationCategories;
        return this;
    }

    @Override
    public TaskQuery classificationCategoryLike(String ... classificationCategories) {
        this.classificationCategoryLike = this.toUpperCopy(classificationCategories);
        return this;
    }

    @Override
    public TaskQuery ownerIn(String ... owners) {
        this.ownerIn = owners;
        return this;
    }

    @Override
    public TaskQuery ownerLike(String ... owners) {
        this.ownerLike = this.toUpperCopy(owners);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyIn(String ... companies) {
        this.porCompanyIn = companies;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceCompanyLike(String ... company) {
        this.porCompanyLike = this.toUpperCopy(company);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemIn(String ... systems) {
        this.porSystemIn = systems;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemLike(String ... system) {
        this.porSystemLike = this.toUpperCopy(system);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceIn(String ... systemInstances) {
        this.porSystemInstanceIn = systemInstances;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceSystemInstanceLike(String ... systemInstance) {
        this.porSystemInstanceLike = this.toUpperCopy(systemInstance);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeIn(String ... types) {
        this.porTypeIn = types;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceTypeLike(String ... type) {
        this.porTypeLike = this.toUpperCopy(type);
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueIn(String ... values) {
        this.porValueIn = values;
        return this;
    }

    @Override
    public TaskQuery primaryObjectReferenceValueLike(String ... value) {
        this.porValueLike = this.toUpperCopy(value);
        return this;
    }

    @Override
    public TaskQuery readEquals(Boolean isRead) {
        this.isRead = isRead;
        return this;
    }

    @Override
    public TaskQuery transferredEquals(Boolean isTransferred) {
        this.isTransferred = isTransferred;
        return this;
    }

    @Override
    public TaskQuery parentBusinessProcessIdIn(String ... parentBusinessProcessIds) {
        this.parentBusinessProcessIdIn = parentBusinessProcessIds;
        return this;
    }

    @Override
    public TaskQuery parentBusinessProcessIdLike(String ... parentBusinessProcessId) {
        this.parentBusinessProcessIdLike = this.toUpperCopy(parentBusinessProcessId);
        return this;
    }

    @Override
    public TaskQuery businessProcessIdIn(String ... businessProcessIds) {
        this.businessProcessIdIn = businessProcessIds;
        return this;
    }

    @Override
    public TaskQuery businessProcessIdLike(String ... businessProcessIds) {
        this.businessProcessIdLike = this.toUpperCopy(businessProcessIds);
        return this;
    }

    @Override
    public TaskQuery stateIn(TaskState ... states) {
        this.stateIn = states;
        return this;
    }

    @Override
    public TaskQuery stateNotIn(TaskState ... states) {
        List<TaskState> stateIn = Arrays.asList(TaskState.values());
        for (TaskState state : states) {
            stateIn.remove((Object)state);
        }
        this.stateIn = stateIn.toArray(new TaskState[0]);
        return this;
    }

    @Override
    public TaskQuery customAttributeIn(String number, String ... strings) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute cannot be converted to a number between 1 and 16", e.getCause());
        }
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (num) {
            case 1: {
                this.custom1In = strings;
                break;
            }
            case 2: {
                this.custom2In = strings;
                break;
            }
            case 3: {
                this.custom3In = strings;
                break;
            }
            case 4: {
                this.custom4In = strings;
                break;
            }
            case 5: {
                this.custom5In = strings;
                break;
            }
            case 6: {
                this.custom6In = strings;
                break;
            }
            case 7: {
                this.custom7In = strings;
                break;
            }
            case 8: {
                this.custom8In = strings;
                break;
            }
            case 9: {
                this.custom9In = strings;
                break;
            }
            case 10: {
                this.custom10In = strings;
                break;
            }
            case 11: {
                this.custom11In = strings;
                break;
            }
            case 12: {
                this.custom12In = strings;
                break;
            }
            case 13: {
                this.custom13In = strings;
                break;
            }
            case 14: {
                this.custom14In = strings;
                break;
            }
            case 15: {
                this.custom15In = strings;
                break;
            }
            case 16: {
                this.custom16In = strings;
                break;
            }
            default: {
                throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute does not represent a number between 1 and 16");
            }
        }
        return this;
    }

    @Override
    public TaskQuery customAttributeLike(String number, String ... strings) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute cannot be converted to a number between 1 and 16", e.getCause());
        }
        if (strings.length == 0) {
            throw new InvalidArgumentException("At least one string has to be provided as a search parameter");
        }
        switch (num) {
            case 1: {
                this.custom1Like = this.toUpperCopy(strings);
                break;
            }
            case 2: {
                this.custom2Like = this.toUpperCopy(strings);
                break;
            }
            case 3: {
                this.custom3Like = this.toUpperCopy(strings);
                break;
            }
            case 4: {
                this.custom4Like = this.toUpperCopy(strings);
                break;
            }
            case 5: {
                this.custom5Like = this.toUpperCopy(strings);
                break;
            }
            case 6: {
                this.custom6Like = this.toUpperCopy(strings);
                break;
            }
            case 7: {
                this.custom7Like = this.toUpperCopy(strings);
                break;
            }
            case 8: {
                this.custom8Like = this.toUpperCopy(strings);
                break;
            }
            case 9: {
                this.custom9Like = this.toUpperCopy(strings);
                break;
            }
            case 10: {
                this.custom10Like = this.toUpperCopy(strings);
                break;
            }
            case 11: {
                this.custom11Like = this.toUpperCopy(strings);
                break;
            }
            case 12: {
                this.custom12Like = this.toUpperCopy(strings);
                break;
            }
            case 13: {
                this.custom13Like = this.toUpperCopy(strings);
                break;
            }
            case 14: {
                this.custom14Like = this.toUpperCopy(strings);
                break;
            }
            case 15: {
                this.custom15Like = this.toUpperCopy(strings);
                break;
            }
            case 16: {
                this.custom16Like = this.toUpperCopy(strings);
                break;
            }
            default: {
                throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute does not represent a number between 1 and 16");
            }
        }
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationKeyIn(String ... attachmentClassificationKeys) {
        this.joinWithAttachments = true;
        this.attachmentClassificationKeyIn = attachmentClassificationKeys;
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationKeyLike(String ... attachmentClassificationKey) {
        this.joinWithAttachments = true;
        this.attachmentClassificationKeyLike = attachmentClassificationKey;
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationIdIn(String ... attachmentClassificationId) {
        this.joinWithAttachments = true;
        this.attachmentClassificationIdIn = attachmentClassificationId;
        return this;
    }

    @Override
    public TaskQuery attachmentClassificationIdLike(String ... attachmentClassificationId) {
        this.joinWithAttachments = true;
        this.attachmentClassificationIdLike = attachmentClassificationId;
        return this;
    }

    @Override
    public TaskQuery attachmentChannelIn(String ... attachmentChannel) {
        this.joinWithAttachments = true;
        this.attachmentChannelIn = attachmentChannel;
        return this;
    }

    @Override
    public TaskQuery attachmentChannelLike(String ... attachmentChannel) {
        this.joinWithAttachments = true;
        this.attachmentChannelLike = attachmentChannel;
        return this;
    }

    @Override
    public TaskQuery attachmentReferenceValueIn(String ... referenceValue) {
        this.joinWithAttachments = true;
        this.attachmentReferenceIn = referenceValue;
        return this;
    }

    @Override
    public TaskQuery attachmentReferenceValueLike(String ... referenceValue) {
        this.joinWithAttachments = true;
        this.attachmentReferenceLike = referenceValue;
        return this;
    }

    @Override
    public TaskQuery attachmentReceivedWithin(TimeInterval ... receivedIn) {
        this.joinWithAttachments = true;
        this.attachmentReceivedIn = receivedIn;
        for (TimeInterval ti : receivedIn) {
            if (ti.isValid()) continue;
            throw new IllegalArgumentException(TIME_INTERVAL + ti + IS_INVALID);
        }
        return this;
    }

    @Override
    public TaskQuery orderByClassificationKey(BaseQuery.SortDirection sortDirection) {
        return this.taskanaEngine.sessionManager.getConfiguration().getDatabaseId().equals("db2") ? this.addOrderCriteria("TCLASSIFICATION_KEY", sortDirection) : this.addOrderCriteria("t.CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByDomain(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DOMAIN", sortDirection);
    }

    @Override
    public TaskQuery orderByPlanned(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PLANNED", sortDirection);
    }

    @Override
    public TaskQuery orderByDue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("DUE", sortDirection);
    }

    @Override
    public TaskQuery orderByModified(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("MODIFIED", sortDirection);
    }

    @Override
    public TaskQuery orderByName(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NAME", sortDirection);
    }

    @Override
    public TaskQuery orderByCreator(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATOR", sortDirection);
    }

    @Override
    public TaskQuery orderByOwner(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("OWNER", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceCompany(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_COMPANY", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceSystem(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_SYSTEM", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceSystemInstance(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_INSTANCE", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceType(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_TYPE", sortDirection);
    }

    @Override
    public TaskQuery orderByPrimaryObjectReferenceValue(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("POR_VALUE", sortDirection);
    }

    @Override
    public TaskQuery orderByPriority(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PRIORITY", sortDirection);
    }

    @Override
    public TaskQuery orderByState(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("STATE", sortDirection);
    }

    @Override
    public TaskQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByWorkbasketId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentClassificationKey(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.taskanaEngine.sessionManager.getConfiguration().getDatabaseId().equals("db2") ? this.addOrderCriteria("ACLASSIFICATION_KEY", sortDirection) : this.addOrderCriteria("a.CLASSIFICATION_KEY", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentClassificationId(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.taskanaEngine.sessionManager.getConfiguration().getDatabaseId().equals("db2") ? this.addOrderCriteria("ACLASSIFICATION_ID", sortDirection) : this.addOrderCriteria("a.CLASSIFICATION_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentChannel(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.addOrderCriteria("CHANNEL", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentReference(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.addOrderCriteria("REF_VALUE", sortDirection);
    }

    @Override
    public TaskQuery orderByAttachmentReceived(BaseQuery.SortDirection sortDirection) {
        this.joinWithAttachments = true;
        this.addAttachmentColumnsToSelectClauseForOrdering = true;
        return this.addOrderCriteria("RECEIVED", sortDirection);
    }

    @Override
    public TaskQuery orderByNote(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("NOTE", sortDirection);
    }

    @Override
    public TaskQuery orderByCustomAttribute(String number, BaseQuery.SortDirection sortDirection) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute cannot be converted to a number between 1 and 16", e.getCause());
        }
        switch (num) {
            case 1: {
                return this.addOrderCriteria("CUSTOM_1", sortDirection);
            }
            case 2: {
                return this.addOrderCriteria("CUSTOM_2", sortDirection);
            }
            case 3: {
                return this.addOrderCriteria("CUSTOM_3", sortDirection);
            }
            case 4: {
                return this.addOrderCriteria("CUSTOM_4", sortDirection);
            }
            case 5: {
                return this.addOrderCriteria("CUSTOM_5", sortDirection);
            }
            case 6: {
                return this.addOrderCriteria("CUSTOM_6", sortDirection);
            }
            case 7: {
                return this.addOrderCriteria("CUSTOM_7", sortDirection);
            }
            case 8: {
                return this.addOrderCriteria("CUSTOM_8", sortDirection);
            }
            case 9: {
                return this.addOrderCriteria("CUSTOM_9", sortDirection);
            }
            case 10: {
                return this.addOrderCriteria("CUSTOM_10", sortDirection);
            }
            case 11: {
                return this.addOrderCriteria("CUSTOM_11", sortDirection);
            }
            case 12: {
                return this.addOrderCriteria("CUSTOM_12", sortDirection);
            }
            case 13: {
                return this.addOrderCriteria("CUSTOM_13", sortDirection);
            }
            case 14: {
                return this.addOrderCriteria("CUSTOM_14", sortDirection);
            }
            case 15: {
                return this.addOrderCriteria("CUSTOM_15", sortDirection);
            }
            case 16: {
                return this.addOrderCriteria("CUSTOM_16", sortDirection);
            }
        }
        throw new InvalidArgumentException("Argument '" + number + "' to getCustomAttribute does not represent a number between 1 and 16");
    }

    @Override
    public TaskQuery orderByBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public TaskQuery orderByClaimed(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CLAIMED", sortDirection);
    }

    @Override
    public TaskQuery orderByCompleted(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("COMPLETED", sortDirection);
    }

    @Override
    public TaskQuery orderByCreated(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("CREATED", sortDirection);
    }

    @Override
    public TaskQuery orderByParentBusinessProcessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("PARENT_BUSINESS_PROCESS_ID", sortDirection);
    }

    @Override
    public ObjectReferenceQuery createObjectReferenceQuery() {
        return new ObjectReferenceQueryImpl(this.taskanaEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskSummary> list() {
        ArrayList<TaskSummary> arrayList;
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            LOGGER.debug("entry to list(), this = {}", (Object)this);
            this.taskanaEngine.openConnection();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            List<TaskSummaryImpl> tasks = new ArrayList();
            this.setupAccessIds();
            tasks = this.taskanaEngine.getSqlSession().selectList(this.getLinkToMapperScript(), (Object)this);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("mapper returned {} resulting Objects: {} ", (Object)tasks.size(), (Object)LoggerUtils.listToString(tasks));
            }
            arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    public String getLinkToMapperScript() {
        return this.taskanaEngine.sessionManager.getConfiguration().getDatabaseId().equals("db2") ? LINK_TO_MAPPER_DB2 : LINK_TO_MAPPER;
    }

    private void setupAccessIds() {
        if (this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN) || !this.filterByAccessIdIn) {
            this.accessIdIn = null;
        } else if (this.accessIdIn == null) {
            String[] accessIds = new String[]{};
            List<String> ucAccessIds = CurrentUserContext.getAccessIds();
            if (ucAccessIds != null && !ucAccessIds.isEmpty()) {
                accessIds = new String[ucAccessIds.size()];
                accessIds = ucAccessIds.toArray(accessIds);
            }
            this.accessIdIn = accessIds;
            WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(String columnName, BaseQuery.SortDirection sortDirection) {
        ArrayList<String> arrayList;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        ArrayList<String> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName, sortDirection);
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupAccessIds();
            arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<TaskSummary> list(int offset, int limit) {
        ArrayList<TaskSummary> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<TaskSummary> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupAccessIds();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List tasks = this.taskanaEngine.getSqlSession().selectList(this.getLinkToMapperScript(), (Object)this, rowBounds);
            arrayList = result = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
            this.taskanaEngine.returnConnection();
        }
        catch (PersistenceException e) {
            try {
                if (e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskSummary single() {
        TaskSummaryImpl taskSummaryImpl;
        TaskSummary result;
        block3: {
            TaskSummary taskSummary;
            LOGGER.debug("entry to single(), this = {}", (Object)this);
            result = null;
            try {
                this.taskanaEngine.openConnection();
                this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
                this.setupAccessIds();
                taskSummaryImpl = (TaskSummaryImpl)this.taskanaEngine.getSqlSession().selectOne(this.getLinkToMapperScript(), (Object)this);
                if (taskSummaryImpl != null) break block3;
                taskSummary = null;
                this.taskanaEngine.returnConnection();
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                LOGGER.debug("exit from single(). Returning result {} ", result);
                throw throwable;
            }
            LOGGER.debug("exit from single(). Returning result {} ", result);
            return taskSummary;
        }
        ArrayList<TaskSummaryImpl> tasks = new ArrayList<TaskSummaryImpl>();
        tasks.add(taskSummaryImpl);
        List<TaskSummary> augmentedList = this.taskService.augmentTaskSummariesByContainedSummaries(tasks);
        TaskSummary taskSummary = result = augmentedList.get(0);
        this.taskanaEngine.returnConnection();
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return taskSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            this.checkOpenAndReadPermissionForSpecifiedWorkbaskets();
            this.setupAccessIds();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    public boolean isJoinWithAttachments() {
        return this.joinWithAttachments;
    }

    public void setJoinWithAttachments(boolean joinWithAttachments) {
        this.joinWithAttachments = joinWithAttachments;
    }

    public boolean isAddAttachmentColumnsToSelectClauseForOrdering() {
        return this.addAttachmentColumnsToSelectClauseForOrdering;
    }

    public void setAddAttachmentColumnsToSelectClauseForOrdering(boolean addAttachmentColumnsToSelectClauseForOrdering) {
        this.addAttachmentColumnsToSelectClauseForOrdering = addAttachmentColumnsToSelectClauseForOrdering;
    }

    private void checkOpenAndReadPermissionForSpecifiedWorkbaskets() {
        if (this.taskanaEngine.isUserInRole(TaskanaRole.ADMIN)) {
            LOGGER.debug("Skipping permissions check since user is in role ADMIN.");
            return;
        }
        try {
            if (this.workbasketIdIn != null && this.workbasketIdIn.length > 0) {
                this.filterByAccessIdIn = false;
                for (String workbasketId : this.workbasketIdIn) {
                    this.checkOpenAndReadPermissionById(workbasketId);
                }
            }
            if (this.workbasketKeyDomainIn != null && this.workbasketKeyDomainIn.length > 0) {
                this.filterByAccessIdIn = false;
                for (KeyDomain keyDomain : this.workbasketKeyDomainIn) {
                    this.checkOpenAndReadPermissionByKeyDomain(keyDomain);
                }
            }
        }
        catch (NotAuthorizedException e) {
            throw new NotAuthorizedToQueryWorkbasketException(e.getMessage(), e.getCause());
        }
    }

    private void checkOpenAndReadPermissionById(String workbasketId) throws NotAuthorizedException {
        try {
            this.taskanaEngine.getWorkbasketService().checkAuthorization(workbasketId, WorkbasketPermission.OPEN, WorkbasketPermission.READ);
        }
        catch (WorkbasketNotFoundException e) {
            LOGGER.warn("The workbasket with the ID '" + workbasketId + "' does not exist.", (Throwable)e);
        }
    }

    private void checkOpenAndReadPermissionByKeyDomain(KeyDomain keyDomain) throws NotAuthorizedException {
        try {
            this.taskanaEngine.getWorkbasketService().checkAuthorization(keyDomain.getKey(), keyDomain.getDomain(), WorkbasketPermission.OPEN, WorkbasketPermission.READ);
        }
        catch (WorkbasketNotFoundException e) {
            LOGGER.warn("The workbasket with the KEY '" + keyDomain.getKey() + "' and DOMAIN '" + keyDomain.getDomain() + "'does not exist.", (Throwable)e);
        }
    }

    public TaskanaEngineImpl getTaskanaEngine() {
        return this.taskanaEngine;
    }

    public String[] getTaskIds() {
        return this.taskIds;
    }

    public String[] getNameIn() {
        return this.nameIn;
    }

    public String[] getCreatorIn() {
        return this.creatorIn;
    }

    public String[] getCreatorLike() {
        return this.creatorLike;
    }

    public String[] getDescription() {
        return this.description;
    }

    public int[] getPriority() {
        return this.priority;
    }

    public TaskState[] getStateIn() {
        return this.stateIn;
    }

    public String[] getOwnerIn() {
        return this.ownerIn;
    }

    public String[] getOwnerLike() {
        return this.ownerLike;
    }

    public Boolean getIsRead() {
        return this.isRead;
    }

    public Boolean getIsTransferred() {
        return this.isTransferred;
    }

    public String[] getPorCompanyIn() {
        return this.porCompanyIn;
    }

    public String[] getPorCompanyLike() {
        return this.porCompanyLike;
    }

    public String[] getPorSystemIn() {
        return this.porSystemIn;
    }

    public String[] getPorSystemLike() {
        return this.porSystemLike;
    }

    public String[] getPorSystemInstanceIn() {
        return this.porSystemInstanceIn;
    }

    public String[] getPorSystemInstanceLike() {
        return this.porSystemInstanceLike;
    }

    public String[] getPorTypeIn() {
        return this.porTypeIn;
    }

    public String[] getPorTypeLike() {
        return this.porTypeLike;
    }

    public String[] getPorValueIn() {
        return this.porValueIn;
    }

    public String[] getPorValueLike() {
        return this.porValueLike;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    public TimeInterval[] getCreatedIn() {
        return this.createdIn;
    }

    public TaskServiceImpl getTaskService() {
        return this.taskService;
    }

    public String[] getNote() {
        return this.note;
    }

    public String[] getNoteLike() {
        return this.noteLike;
    }

    public String[] getParentBusinessProcessIdIn() {
        return this.parentBusinessProcessIdIn;
    }

    public String[] getParentBusinessProcessIdLike() {
        return this.parentBusinessProcessIdLike;
    }

    public String[] getBusinessProcessIdIn() {
        return this.businessProcessIdIn;
    }

    public String[] getBusinessProcessIdLike() {
        return this.businessProcessIdLike;
    }

    public String[] getCustom1In() {
        return this.custom1In;
    }

    public String[] getCustom1Like() {
        return this.custom1Like;
    }

    public String[] getCustom2In() {
        return this.custom2In;
    }

    public String[] getCustom2Like() {
        return this.custom2Like;
    }

    public String[] getCustom3In() {
        return this.custom3In;
    }

    public String[] getCustom3Like() {
        return this.custom3Like;
    }

    public String[] getCustom4In() {
        return this.custom4In;
    }

    public String[] getCustom4Like() {
        return this.custom4Like;
    }

    public String[] getCustom5In() {
        return this.custom5In;
    }

    public String[] getCustom5Like() {
        return this.custom5Like;
    }

    public String[] getCustom6In() {
        return this.custom6In;
    }

    public String[] getCustom6Like() {
        return this.custom6Like;
    }

    public String[] getCustom7In() {
        return this.custom7In;
    }

    public String[] getCustom7Like() {
        return this.custom7Like;
    }

    public String[] getCustom8In() {
        return this.custom8In;
    }

    public String[] getCustom8Like() {
        return this.custom8Like;
    }

    public String[] getCustom9In() {
        return this.custom9In;
    }

    public String[] getCustom9Like() {
        return this.custom9Like;
    }

    public String[] getCustom10In() {
        return this.custom10In;
    }

    public String[] getCustom10Like() {
        return this.custom10Like;
    }

    public String[] getCustom11In() {
        return this.custom11In;
    }

    public String[] getCustom11Like() {
        return this.custom11Like;
    }

    public String[] getCustom12In() {
        return this.custom12In;
    }

    public String[] getCustom12Like() {
        return this.custom12Like;
    }

    public String[] getCustom13In() {
        return this.custom13In;
    }

    public String[] getCustom13Like() {
        return this.custom13Like;
    }

    public String[] getCustom14In() {
        return this.custom14In;
    }

    public String[] getCustom14Like() {
        return this.custom14Like;
    }

    public String[] getCustom15In() {
        return this.custom15In;
    }

    public String[] getCustom15Like() {
        return this.custom15Like;
    }

    public String[] getCustom16In() {
        return this.custom16In;
    }

    public String[] getCustom16Like() {
        return this.custom16Like;
    }

    public String[] getClassificationCategoryIn() {
        return this.classificationCategoryIn;
    }

    public String[] getClassificationCategoryLike() {
        return this.classificationCategoryLike;
    }

    public TimeInterval[] getClaimedIn() {
        return this.claimedIn;
    }

    public TimeInterval[] getCompletedIn() {
        return this.completedIn;
    }

    public TimeInterval[] getModifiedIn() {
        return this.modifiedIn;
    }

    public TimeInterval[] getPlannedIn() {
        return this.plannedIn;
    }

    public TimeInterval[] getDueIn() {
        return this.dueIn;
    }

    public String[] getNameLike() {
        return this.nameLike;
    }

    public String[] getClassificationKeyIn() {
        return this.classificationKeyIn;
    }

    public String[] getClassificationKeyNotIn() {
        return this.classificationKeyNotIn;
    }

    public String[] getClassificationKeyLike() {
        return this.classificationKeyLike;
    }

    public String[] getClassificationIdIn() {
        return this.classificationIdIn;
    }

    public KeyDomain[] getWorkbasketKeyDomainIn() {
        return this.workbasketKeyDomainIn;
    }

    public String[] getWorkbasketIdIn() {
        return this.workbasketIdIn;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String[] getAttachmentClassificationKeyIn() {
        return this.attachmentClassificationKeyIn;
    }

    public void setAttachmentClassificationKeyIn(String[] attachmentClassificationKeyIn) {
        this.attachmentClassificationKeyIn = attachmentClassificationKeyIn;
    }

    public String[] getAttachmentClassificationKeyLike() {
        return this.attachmentClassificationKeyLike;
    }

    public void setAttachmentClassificationKeyLike(String[] attachmentClassificationKeyLike) {
        this.attachmentClassificationKeyLike = attachmentClassificationKeyLike;
    }

    public String[] getAttachmentClassificationIdIn() {
        return this.attachmentClassificationIdIn;
    }

    public void setAttachmentClassificationIdIn(String[] attachmentClassificationIdIn) {
        this.attachmentClassificationIdIn = attachmentClassificationIdIn;
    }

    public String[] getAttachmentClassificationIdLike() {
        return this.attachmentClassificationIdLike;
    }

    public void setAttachmentClassificationIdLike(String[] attachmentclassificationIdLike) {
        this.attachmentClassificationIdLike = attachmentclassificationIdLike;
    }

    public String[] getAttachmentChannelIn() {
        return this.attachmentChannelIn;
    }

    public void setAttachmentChannelIn(String[] attachmentChannelIn) {
        this.attachmentChannelIn = attachmentChannelIn;
    }

    public String[] getAttachmentChannelLike() {
        return this.attachmentChannelLike;
    }

    public void setAttachmentChannelLike(String[] attachmentChannelLike) {
        this.attachmentChannelLike = attachmentChannelLike;
    }

    public String[] getAttachmentReferenceIn() {
        return this.attachmentReferenceIn;
    }

    public void setAttachmentReferenceIn(String[] attachmentReferenceIn) {
        this.attachmentReferenceIn = attachmentReferenceIn;
    }

    public String[] getAttachmentReferenceLike() {
        return this.attachmentReferenceLike;
    }

    public void setAttachmentReferenceLike(String[] attachmentReferenceLike) {
        this.attachmentReferenceLike = attachmentReferenceLike;
    }

    public TimeInterval[] getAttachmentReceivedIn() {
        return this.attachmentReceivedIn;
    }

    public void setAttachmentReceivedIn(TimeInterval[] attachmentReceivedIn) {
        this.attachmentReceivedIn = attachmentReceivedIn;
    }

    private TaskQuery addOrderCriteria(String columnName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " ASC";
        if (sortDirection != null && BaseQuery.SortDirection.DESCENDING.equals((Object)sortDirection)) {
            orderByDirection = " DESC";
        }
        this.orderBy.add(columnName + orderByDirection);
        this.orderColumns.add(columnName);
        return this;
    }

    private String[] toUpperCopy(String ... source) {
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskQueryImpl [columnName=");
        builder.append(this.columnName);
        builder.append(", nameIn=");
        builder.append(Arrays.toString(this.nameIn));
        builder.append(", nameLike=");
        builder.append(Arrays.toString(this.nameLike));
        builder.append(", creatorIn=");
        builder.append(Arrays.toString(this.creatorIn));
        builder.append(", creatorLike=");
        builder.append(Arrays.toString(this.creatorLike));
        builder.append(", taskIds=");
        builder.append(Arrays.toString(this.taskIds));
        builder.append(", description=");
        builder.append(Arrays.toString(this.description));
        builder.append(", note=");
        builder.append(Arrays.toString(this.note));
        builder.append(", priority=");
        builder.append(Arrays.toString(this.priority));
        builder.append(", workbasketKeyDomainIn=");
        builder.append(Arrays.toString(this.workbasketKeyDomainIn));
        builder.append(", workbasketIdIn=");
        builder.append(Arrays.toString(this.workbasketIdIn));
        builder.append(", stateIn=");
        builder.append(Arrays.toString((Object[])this.stateIn));
        builder.append(", classificationIdIn=");
        builder.append(Arrays.toString(this.classificationIdIn));
        builder.append(", classificationKeyIn=");
        builder.append(Arrays.toString(this.classificationKeyIn));
        builder.append(", classificationKeyNotIn=");
        builder.append(Arrays.toString(this.classificationKeyNotIn));
        builder.append(", classificationKeyLike=");
        builder.append(Arrays.toString(this.classificationKeyLike));
        builder.append(", classificationCategoryIn=");
        builder.append(Arrays.toString(this.classificationCategoryIn));
        builder.append(", classificationCategoryLike=");
        builder.append(Arrays.toString(this.classificationCategoryLike));
        builder.append(", ownerIn=");
        builder.append(Arrays.toString(this.ownerIn));
        builder.append(", ownerLike=");
        builder.append(Arrays.toString(this.ownerLike));
        builder.append(", isRead=");
        builder.append(this.isRead);
        builder.append(", isTransferred=");
        builder.append(this.isTransferred);
        builder.append(", porCompanyIn=");
        builder.append(Arrays.toString(this.porCompanyIn));
        builder.append(", porCompanyLike=");
        builder.append(Arrays.toString(this.porCompanyLike));
        builder.append(", porSystemIn=");
        builder.append(Arrays.toString(this.porSystemIn));
        builder.append(", porSystemLike=");
        builder.append(Arrays.toString(this.porSystemLike));
        builder.append(", porSystemInstanceIn=");
        builder.append(Arrays.toString(this.porSystemInstanceIn));
        builder.append(", porSystemInstanceLike=");
        builder.append(Arrays.toString(this.porSystemInstanceLike));
        builder.append(", porTypeIn=");
        builder.append(Arrays.toString(this.porTypeIn));
        builder.append(", porTypeLike=");
        builder.append(Arrays.toString(this.porTypeLike));
        builder.append(", porValueIn=");
        builder.append(Arrays.toString(this.porValueIn));
        builder.append(", porValueLike=");
        builder.append(Arrays.toString(this.porValueLike));
        builder.append(", parentBusinessProcessIdIn=");
        builder.append(Arrays.toString(this.parentBusinessProcessIdIn));
        builder.append(", parentBusinessProcessIdLike=");
        builder.append(Arrays.toString(this.parentBusinessProcessIdLike));
        builder.append(", businessProcessIdIn=");
        builder.append(Arrays.toString(this.businessProcessIdIn));
        builder.append(", businessProcessIdLike=");
        builder.append(Arrays.toString(this.businessProcessIdLike));
        builder.append(", custom1In=");
        builder.append(Arrays.toString(this.custom1In));
        builder.append(", custom1Like=");
        builder.append(Arrays.toString(this.custom1Like));
        builder.append(", custom2In=");
        builder.append(Arrays.toString(this.custom2In));
        builder.append(", custom2Like=");
        builder.append(Arrays.toString(this.custom2Like));
        builder.append(", custom3In=");
        builder.append(Arrays.toString(this.custom3In));
        builder.append(", custom3Like=");
        builder.append(Arrays.toString(this.custom3Like));
        builder.append(", custom4In=");
        builder.append(Arrays.toString(this.custom4In));
        builder.append(", custom4Like=");
        builder.append(Arrays.toString(this.custom4Like));
        builder.append(", custom5In=");
        builder.append(Arrays.toString(this.custom5In));
        builder.append(", custom5Like=");
        builder.append(Arrays.toString(this.custom5Like));
        builder.append(", custom6In=");
        builder.append(Arrays.toString(this.custom6In));
        builder.append(", custom6Like=");
        builder.append(Arrays.toString(this.custom6Like));
        builder.append(", custom7In=");
        builder.append(Arrays.toString(this.custom7In));
        builder.append(", custom7Like=");
        builder.append(Arrays.toString(this.custom7Like));
        builder.append(", custom8In=");
        builder.append(Arrays.toString(this.custom8In));
        builder.append(", custom8Like=");
        builder.append(Arrays.toString(this.custom8Like));
        builder.append(", custom9In=");
        builder.append(Arrays.toString(this.custom9In));
        builder.append(", custom9Like=");
        builder.append(Arrays.toString(this.custom9Like));
        builder.append(", custom10In=");
        builder.append(Arrays.toString(this.custom10In));
        builder.append(", custom10Like=");
        builder.append(Arrays.toString(this.custom10Like));
        builder.append(", custom11In=");
        builder.append(Arrays.toString(this.custom11In));
        builder.append(", custom11Like=");
        builder.append(Arrays.toString(this.custom11Like));
        builder.append(", custom12In=");
        builder.append(Arrays.toString(this.custom12In));
        builder.append(", custom12Like=");
        builder.append(Arrays.toString(this.custom12Like));
        builder.append(", custom13In=");
        builder.append(Arrays.toString(this.custom13In));
        builder.append(", custom13Like=");
        builder.append(Arrays.toString(this.custom13Like));
        builder.append(", custom14In=");
        builder.append(Arrays.toString(this.custom14In));
        builder.append(", custom14Like=");
        builder.append(Arrays.toString(this.custom14Like));
        builder.append(", custom15In=");
        builder.append(Arrays.toString(this.custom15In));
        builder.append(", custom15Like=");
        builder.append(Arrays.toString(this.custom15Like));
        builder.append(", custom16In=");
        builder.append(Arrays.toString(this.custom16In));
        builder.append(", custom16Like=");
        builder.append(Arrays.toString(this.custom16Like));
        builder.append(", accessIdIn=");
        builder.append(Arrays.toString(this.accessIdIn));
        builder.append(", filterByAccessIdIn=");
        builder.append(this.filterByAccessIdIn);
        builder.append(", createdIn=");
        builder.append(Arrays.toString(this.createdIn));
        builder.append(", claimedIn=");
        builder.append(Arrays.toString(this.claimedIn));
        builder.append(", completedIn=");
        builder.append(Arrays.toString(this.completedIn));
        builder.append(", modifiedIn=");
        builder.append(Arrays.toString(this.modifiedIn));
        builder.append(", plannedIn=");
        builder.append(Arrays.toString(this.plannedIn));
        builder.append(", dueIn=");
        builder.append(Arrays.toString(this.dueIn));
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }
}

