/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.jobs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.JobServiceImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.jobs.AbstractTaskanaJob;
import pro.taskana.jobs.ScheduledJob;
import pro.taskana.jobs.TaskanaJob;
import pro.taskana.transaction.TaskanaTransactionProvider;

public class JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private TaskanaEngineImpl taskanaEngine;
    private JobServiceImpl jobService;
    private TaskanaTransactionProvider<Object> txProvider;
    private int maxRetryCount;
    private int attempt = 0;

    public JobRunner(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.jobService = (JobServiceImpl)taskanaEngine.getJobService();
        this.maxRetryCount = taskanaEngine.getConfiguration().getMaxNumberOfJobRetries();
    }

    public void registerTransactionProvider(TaskanaTransactionProvider<Object> txProvider) {
        this.txProvider = txProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runJobs() {
        LOGGER.info("entry to runJobs()");
        try {
            List<ScheduledJob> jobsToRun = this.findAndLockJobsToRun();
            for (ScheduledJob scheduledJob : jobsToRun) {
                this.runJobTransactionally(scheduledJob);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured whle running jobs: ", (Throwable)e);
        }
        finally {
            LOGGER.info("exit from runJobs().");
        }
    }

    private List<ScheduledJob> findAndLockJobsToRun() {
        List<ScheduledJob> availableJobs = this.jobService.findJobsToRun();
        ArrayList<ScheduledJob> lockedJobs = new ArrayList<ScheduledJob>();
        for (ScheduledJob job : availableJobs) {
            lockedJobs.add(this.lockJobTransactionally(job));
        }
        return lockedJobs;
    }

    private ScheduledJob lockJobTransactionally(ScheduledJob job) {
        ScheduledJob lockedJob = null;
        lockedJob = this.txProvider != null ? (ScheduledJob)this.txProvider.executeInTransaction(() -> this.lockJob(job)) : this.lockJob(job);
        LOGGER.debug("Locked job: {}", (Object)lockedJob);
        return lockedJob;
    }

    private ScheduledJob lockJob(ScheduledJob job) {
        String hostAddress = "UNKNOWN_ADDRESS";
        try {
            hostAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        job.setLockedBy(hostAddress + " - " + Thread.currentThread().getName());
        String owner = hostAddress + " - " + Thread.currentThread().getName();
        ScheduledJob lockedJob = this.jobService.lockJob(job, owner);
        return lockedJob;
    }

    private void runJobTransactionally(ScheduledJob scheduledJob) {
        try {
            if (this.txProvider != null) {
                this.txProvider.executeInTransaction(() -> {
                    this.runScheduledJob(scheduledJob);
                    return null;
                });
            } else {
                this.runScheduledJob(scheduledJob);
            }
            this.jobService.deleteJob(scheduledJob);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.warn("Processing of job " + scheduledJob.getJobId() + " failed. Trying to split it up into two pieces...", (Throwable)e);
        }
    }

    private void runScheduledJob(ScheduledJob scheduledJob) {
        LOGGER.debug("entry to runScheduledJob(job = {})", (Object)scheduledJob);
        try {
            TaskanaJob job = AbstractTaskanaJob.createFromScheduledJob(this.taskanaEngine, this.txProvider, scheduledJob);
            job.run();
        }
        catch (Exception e) {
            LOGGER.error("Error running job: {} ", (Object)scheduledJob.getType(), (Object)e);
            throw new SystemException("When attempting to load class " + (Object)((Object)scheduledJob.getType()) + " caught Exception " + e.getMessage(), e);
        }
        LOGGER.debug("exit from runScheduledJob");
    }
}

