/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana;

import java.util.List;

public interface BaseQuery<T> {
    public List<T> list();

    public List<T> list(int var1, int var2);

    public List<String> listValues(String var1, SortDirection var2);

    default public List<T> listPage(int pageNumber, int pageSize) {
        int offset = pageNumber < 1 ? 0 : (pageNumber - 1) * pageSize;
        int limit = pageSize < 0 ? 0 : pageSize;
        return this.list(offset, limit);
    }

    public T single();

    public long count();

    default public String[] toUpperCopy(String ... source) {
        if (source == null || source.length == 0) {
            return null;
        }
        String[] target = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i].toUpperCase();
        }
        return target;
    }

    public static enum SortDirection {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private final String sortDirection;

        private SortDirection(String sortDirection) {
            this.sortDirection = sortDirection;
        }

        public String toString() {
            return this.sortDirection;
        }
    }
}

