/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.history;

import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.history.api.TaskanaHistory;
import pro.taskana.history.api.TaskanaHistoryEvent;

public final class HistoryEventProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(HistoryEventProducer.class);
    TaskanaEngineConfiguration taskanaEngineConfiguration;
    private static HistoryEventProducer emitterInstance;
    private ServiceLoader<TaskanaHistory> serviceLoader;
    private boolean enabled = false;

    public static synchronized HistoryEventProducer getInstance(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        if (emitterInstance == null) {
            emitterInstance = new HistoryEventProducer(taskanaEngineConfiguration);
        }
        return emitterInstance;
    }

    public static boolean isHistoryEnabled() {
        return HistoryEventProducer.getInstance(null).isEnabled();
    }

    private HistoryEventProducer(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.serviceLoader = ServiceLoader.load(TaskanaHistory.class);
        for (TaskanaHistory history : this.serviceLoader) {
            history.initialize(taskanaEngineConfiguration);
            LOGGER.info("Registered history provider: {}", (Object)history.getClass().getName());
            this.enabled = true;
        }
        if (!this.enabled) {
            LOGGER.info("No history provider found. Running without history.");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void createEvent(TaskanaHistoryEvent event) {
        LOGGER.debug("Sending event to history service providers: {}", (Object)event);
        this.serviceLoader.forEach(historyProvider -> historyProvider.create(event));
    }
}

