/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.history.api;

import pro.taskana.Task;
import pro.taskana.history.api.TaskanaHistoryEvent;

public class TaskHistoryEvent
extends TaskanaHistoryEvent {
    protected String taskId;
    protected String businessProcessId;
    protected String parentBusinessProcessId;
    protected String domain;
    protected String workbasketKey;
    protected String taskClassificationCategory;
    protected String taskClassificationKey;
    protected String attachmentClassificationKey;
    protected String porCompany;
    protected String porSystem;
    protected String porInstance;
    protected String porType;
    protected String porValue;

    public TaskHistoryEvent(Task task) {
        this.taskId = task.getId();
        this.businessProcessId = task.getBusinessProcessId();
        this.parentBusinessProcessId = task.getParentBusinessProcessId();
        this.domain = task.getDomain();
        this.workbasketKey = task.getWorkbasketKey();
        this.taskClassificationCategory = task.getClassificationCategory();
        this.taskClassificationKey = task.getClassificationSummary().getKey();
        if (!task.getAttachments().isEmpty()) {
            this.attachmentClassificationKey = task.getAttachments().get(0).getClassificationSummary().getKey();
        }
        this.porCompany = task.getPrimaryObjRef().getCompany();
        this.porSystem = task.getPrimaryObjRef().getSystem();
        this.porInstance = task.getPrimaryObjRef().getSystemInstance();
        this.porType = task.getPrimaryObjRef().getType();
        this.porValue = task.getPrimaryObjRef().getValue();
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getBusinessProcessId() {
        return this.businessProcessId;
    }

    public void setBusinessProcessId(String businessProcessId) {
        this.businessProcessId = businessProcessId;
    }

    public String getParentBusinessProcessId() {
        return this.parentBusinessProcessId;
    }

    public void setParentBusinessProcessId(String parentBusinessProcessId) {
        this.parentBusinessProcessId = parentBusinessProcessId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getWorkbasketKey() {
        return this.workbasketKey;
    }

    public void setWorkbasketKey(String workbasketKey) {
        this.workbasketKey = workbasketKey;
    }

    public String getTaskClassificationCategory() {
        return this.taskClassificationCategory;
    }

    public void setTaskClassificationCategory(String taskClassificationCategory) {
        this.taskClassificationCategory = taskClassificationCategory;
    }

    public String getTaskClassificationKey() {
        return this.taskClassificationKey;
    }

    public void setTaskClassificationKey(String taskClassificationKey) {
        this.taskClassificationKey = taskClassificationKey;
    }

    public String getAttachmentClassificationKey() {
        return this.attachmentClassificationKey;
    }

    public void setAttachmentClassificationKey(String attachmentClassificationKey) {
        this.attachmentClassificationKey = attachmentClassificationKey;
    }

    public String getPorCompany() {
        return this.porCompany;
    }

    public void setPorCompany(String porCompany) {
        this.porCompany = porCompany;
    }

    public String getPorSystem() {
        return this.porSystem;
    }

    public void setPorSystem(String porSystem) {
        this.porSystem = porSystem;
    }

    public String getPorInstance() {
        return this.porInstance;
    }

    public void setPorInstance(String porInstance) {
        this.porInstance = porInstance;
    }

    public String getPorType() {
        return this.porType;
    }

    public void setPorType(String porType) {
        this.porType = porType;
    }

    public String getPorValue() {
        return this.porValue;
    }

    public void setPorValue(String porValue) {
        this.porValue = porValue;
    }
}

