/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.ObjectReference;
import pro.taskana.ObjectReferenceQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.util.LoggerUtils;

public class ObjectReferenceQueryImpl
implements ObjectReferenceQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.mappings.QueryMapper.queryObjectReferences";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryObjectReferences";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.mappings.QueryMapper.queryObjectReferenceColumnValues";
    private static final Logger LOGGER = LoggerFactory.getLogger(ObjectReferenceQueryImpl.class);
    private TaskanaEngineImpl taskanaEngine;
    private String columnName;
    private String[] company;
    private String[] system;
    private String[] systemInstance;
    private String[] type;
    private String[] value;
    private List<String> orderBy;

    ObjectReferenceQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.orderBy = new ArrayList<String>();
    }

    @Override
    public ObjectReferenceQuery companyIn(String ... companies) {
        this.company = companies;
        return this;
    }

    @Override
    public ObjectReferenceQuery systemIn(String ... systems) {
        this.system = systems;
        return this;
    }

    @Override
    public ObjectReferenceQuery systemInstanceIn(String ... systemInstances) {
        this.systemInstance = systemInstances;
        return this;
    }

    @Override
    public ObjectReferenceQuery typeIn(String ... types) {
        this.type = types;
        return this;
    }

    @Override
    public ObjectReferenceQuery valueIn(String ... values) {
        this.value = values;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ObjectReference> list() {
        List<ObjectReference> list;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        List<ObjectReference> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            list = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(String columnName, BaseQuery.SortDirection sortDirection) {
        ArrayList<String> arrayList;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        ArrayList<String> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName, sortDirection);
            arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public List<ObjectReference> list(int offset, int limit) {
        ArrayList<ObjectReference> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<ObjectReference> result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            arrayList = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            this.taskanaEngine.returnConnection();
        }
        catch (Exception e) {
            try {
                if (e instanceof PersistenceException && e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public ObjectReference single() {
        ObjectReference objectReference;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        ObjectReference result = null;
        try {
            this.taskanaEngine.openConnection();
            objectReference = result = (ObjectReference)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", result);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)result);
        return objectReference;
    }

    public String[] getCompany() {
        return this.company;
    }

    public void setCompany(String[] company) {
        this.company = company;
    }

    public String[] getSystem() {
        return this.system;
    }

    public void setSystem(String[] system) {
        this.system = system;
    }

    public String[] getSystemInstance() {
        return this.systemInstance;
    }

    public void setSystemInstance(String[] systemInstance) {
        this.systemInstance = systemInstance;
    }

    public String[] getType() {
        return this.type;
    }

    public void setType(String[] type) {
        this.type = type;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public String getColumnName() {
        return this.columnName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private ObjectReferenceQuery addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (Object)((Object)(sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection));
        this.orderBy.add(colName + orderByDirection);
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ObjectReferenceQueryImpl [taskanaEngineImpl=");
        builder.append(this.taskanaEngine);
        builder.append(", company=");
        builder.append(Arrays.toString(this.company));
        builder.append(", system=");
        builder.append(Arrays.toString(this.system));
        builder.append(", systemInstance=");
        builder.append(Arrays.toString(this.systemInstance));
        builder.append(", type=");
        builder.append(Arrays.toString(this.type));
        builder.append(", value=");
        builder.append(Arrays.toString(this.value));
        builder.append("]");
        return builder.toString();
    }
}

