/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.BaseQuery;
import pro.taskana.TaskanaEngine;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketAccessItemQuery;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.util.LoggerUtils;

public class WorkbasketAccessItemQueryImpl
implements WorkbasketAccessItemQuery {
    private static final String LINK_TO_MAPPER = "pro.taskana.mappings.QueryMapper.queryWorkbasketAccessItems";
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryWorkbasketAccessItems";
    private static final String LINK_TO_VALUEMAPPER = "pro.taskana.mappings.QueryMapper.queryWorkbasketAccessItemColumnValues";
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbasketQueryImpl.class);
    private String columnName;
    private String[] accessIdIn;
    private String[] accessIdLike;
    private String[] workbasketIdIn;
    private String[] workbasketKeyIn;
    private String[] workbasketKeyLike;
    private String[] idIn;
    private TaskanaEngineImpl taskanaEngine;
    private List<String> orderBy;
    private List<String> orderColumns;

    WorkbasketAccessItemQueryImpl(TaskanaEngine taskanaEngine) {
        this.taskanaEngine = (TaskanaEngineImpl)taskanaEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
    }

    @Override
    public WorkbasketAccessItemQuery idIn(String ... ids) {
        this.idIn = ids;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery workbasketIdIn(String ... id) {
        this.workbasketIdIn = id;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery workbasketKeyIn(String ... keys) {
        this.workbasketKeyIn = keys;
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery workbasketKeyLike(String ... key) {
        this.workbasketKeyLike = this.toUpperCopy(key);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery accessIdIn(String ... accessId) {
        this.accessIdIn = accessId;
        WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery accessIdLike(String ... ids) {
        this.accessIdLike = this.toUpperCopy(ids);
        return this;
    }

    @Override
    public WorkbasketAccessItemQuery orderById(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ID", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderByWorkbasketId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_ID", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderByWorkbasketKey(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WB.KEY", sortDirection);
    }

    @Override
    public WorkbasketAccessItemQuery orderByAccessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ACCESS_ID", sortDirection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WorkbasketAccessItem> list() {
        ArrayList<WorkbasketAccessItem> arrayList;
        LOGGER.debug("entry to list(), this = {}", (Object)this);
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngine.openConnection();
            List foundAccessItms = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this);
            result.addAll(foundAccessItms);
            arrayList = result;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(String columnName, BaseQuery.SortDirection sortDirection) {
        List list;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, (Object)this);
        List result = null;
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName, sortDirection);
            list = result = this.taskanaEngine.getSqlSession().selectList(LINK_TO_VALUEMAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public List<WorkbasketAccessItem> list(int offset, int limit) {
        ArrayList<WorkbasketAccessItem> arrayList;
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this});
        ArrayList<WorkbasketAccessItem> result = new ArrayList<WorkbasketAccessItem>();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List foundAccessItms = this.taskanaEngine.getSqlSession().selectList(LINK_TO_MAPPER, (Object)this, rowBounds);
            result.addAll(foundAccessItms);
            arrayList = result;
            this.taskanaEngine.returnConnection();
        }
        catch (PersistenceException e) {
            try {
                if (e.getMessage().contains("ERRORCODE=-4470")) {
                    TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                    ex.setStackTrace(e.getStackTrace());
                    throw ex;
                }
                throw e;
            }
            catch (Throwable throwable) {
                this.taskanaEngine.returnConnection();
                if (LOGGER.isDebugEnabled()) {
                    int numberOfResultObjects = result == null ? 0 : result.size();
                    LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
                }
                throw throwable;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return arrayList;
    }

    @Override
    public WorkbasketAccessItem single() {
        WorkbasketAccessItem workbasketAccessItem;
        LOGGER.debug("entry to single(), this = {}", (Object)this);
        WorkbasketAccessItem accessItm = null;
        try {
            this.taskanaEngine.openConnection();
            workbasketAccessItem = accessItm = (WorkbasketAccessItem)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_MAPPER, (Object)this);
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", accessItm);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)accessItm);
        return workbasketAccessItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", (Object)this);
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, (Object)this);
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    private WorkbasketAccessItemQuery addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (sortDirection == null ? BaseQuery.SortDirection.ASCENDING.toString() : sortDirection.toString());
        this.orderBy.add(colName + orderByDirection);
        this.orderColumns.add(colName);
        return this;
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getAccessIdIn() {
        return this.accessIdIn;
    }

    public String[] getAccessIdLike() {
        return this.accessIdLike;
    }

    public String[] getWorkbasketIdIn() {
        return this.workbasketIdIn;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String[] getWorkbasketKeyIn() {
        return this.workbasketKeyIn;
    }

    public String[] getWorkbasketKeyLike() {
        return this.workbasketKeyLike;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WorkbasketAccessItemQueryImpl [idIn=");
        builder.append(Arrays.toString(this.idIn));
        builder.append(", accessIdIn=");
        builder.append(Arrays.toString(this.accessIdIn));
        builder.append(", workbasketIdIn=");
        builder.append(Arrays.toString(this.workbasketIdIn));
        builder.append(", orderBy=");
        builder.append(this.orderBy);
        builder.append("]");
        return builder.toString();
    }
}

