/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.security;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.configuration.TaskanaEngineConfiguration;

public final class CurrentUserContext {
    private static final String GET_UNIQUE_SECURITY_NAME_METHOD = "getUniqueSecurityName";
    private static final String GET_CALLER_SUBJECT_METHOD = "getCallerSubject";
    private static final String WSSUBJECT_CLASSNAME = "com.ibm.websphere.security.auth.WSSubject";
    private static final Logger LOGGER = LoggerFactory.getLogger(CurrentUserContext.class);
    private static Boolean runningOnWebSphere = null;

    private CurrentUserContext() {
    }

    public static String getUserid() {
        if (CurrentUserContext.runningOnWebSphere()) {
            return CurrentUserContext.getUseridFromWSSubject();
        }
        return CurrentUserContext.getUseridFromJAASSubject();
    }

    private static String getUseridFromWSSubject() {
        try {
            Class<?> wsSubjectClass = Class.forName(WSSUBJECT_CLASSNAME);
            Method getCallerSubjectMethod = wsSubjectClass.getMethod(GET_CALLER_SUBJECT_METHOD, null);
            Subject callerSubject = (Subject)getCallerSubjectMethod.invoke(null, (Object[])null);
            LOGGER.debug("Subject of caller: {}", (Object)callerSubject);
            if (callerSubject != null) {
                Set<Object> publicCredentials = callerSubject.getPublicCredentials();
                LOGGER.debug("Public credentials of caller: {}", publicCredentials);
                Iterator<Object> iterator = publicCredentials.iterator();
                if (iterator.hasNext()) {
                    String userIdFound;
                    Object pC = iterator.next();
                    Object o = pC.getClass().getMethod(GET_UNIQUE_SECURITY_NAME_METHOD, null).invoke(pC, (Object[])null);
                    LOGGER.debug("Returning the unique security name of first public credential: {}", o);
                    String userIdUsed = userIdFound = o.toString();
                    if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds() && userIdFound != null) {
                        userIdUsed = userIdFound.toLowerCase();
                    }
                    LOGGER.trace("Found User id {}. Returning User id {} ", (Object)userIdFound, (Object)userIdUsed);
                    return userIdUsed;
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not get user from WSSubject. Going ahead unauthorized.");
        }
        return null;
    }

    private static boolean runningOnWebSphere() {
        if (runningOnWebSphere == null) {
            try {
                Class.forName(WSSUBJECT_CLASSNAME);
                LOGGER.debug("WSSubject detected. Assuming that Taskana runs on IBM WebSphere.");
                runningOnWebSphere = new Boolean(true);
            }
            catch (ClassNotFoundException e) {
                LOGGER.debug("No WSSubject detected. Using JAAS subject further on.");
                runningOnWebSphere = new Boolean(false);
            }
        }
        return runningOnWebSphere;
    }

    private static String getUseridFromJAASSubject() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        LOGGER.trace("Subject of caller: {}", (Object)subject);
        if (subject != null) {
            Set<Principal> principals = subject.getPrincipals();
            LOGGER.trace("Public principals of caller: {}", principals);
            for (Principal pC : principals) {
                String userIdFound;
                if (pC instanceof Group) continue;
                String userIdUsed = userIdFound = pC.getName();
                if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds() && userIdFound != null) {
                    userIdUsed = userIdFound.toLowerCase();
                }
                LOGGER.trace("Found User id {}. Returning User id {} ", (Object)userIdFound, (Object)userIdUsed);
                return userIdUsed;
            }
        }
        LOGGER.trace("No userid found in subject!");
        return null;
    }

    public static List<String> getGroupIds() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        LOGGER.trace("Subject of caller: {}", (Object)subject);
        ArrayList<String> groupIds = new ArrayList<String>();
        if (subject != null) {
            Set<Group> groups = subject.getPrincipals(Group.class);
            LOGGER.trace("Public groups of caller: {}", groups);
            for (Principal principal : groups) {
                String groupNameFound;
                String groupNameReturned = groupNameFound = principal.getName();
                if (TaskanaEngineConfiguration.shouldUseLowerCaseForAccessIds() && groupNameFound != null) {
                    groupNameReturned = groupNameFound.toLowerCase();
                }
                LOGGER.trace("Found group id {}. Returning group Id: {}", (Object)groupNameFound, (Object)groupNameReturned);
                groupIds.add(groupNameReturned);
            }
            return groupIds;
        }
        LOGGER.trace("No groupids found in subject!");
        return groupIds;
    }

    public static List<String> getAccessIds() {
        ArrayList<String> accessIds = new ArrayList<String>();
        List<String> groupIds = CurrentUserContext.getGroupIds();
        accessIds.add(CurrentUserContext.getUserid());
        if (!groupIds.isEmpty()) {
            accessIds.addAll(groupIds);
        }
        return accessIds;
    }
}

