/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana;

import java.util.List;
import pro.taskana.BulkOperationResults;
import pro.taskana.Workbasket;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.WorkbasketAccessItemQuery;
import pro.taskana.WorkbasketPermission;
import pro.taskana.WorkbasketQuery;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.DomainNotFoundException;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.InvalidWorkbasketException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.TaskanaException;
import pro.taskana.exceptions.WorkbasketAlreadyExistException;
import pro.taskana.exceptions.WorkbasketInUseException;
import pro.taskana.exceptions.WorkbasketNotFoundException;

public interface WorkbasketService {
    public Workbasket getWorkbasket(String var1) throws WorkbasketNotFoundException, NotAuthorizedException;

    public Workbasket getWorkbasket(String var1, String var2) throws WorkbasketNotFoundException, NotAuthorizedException;

    public Workbasket createWorkbasket(Workbasket var1) throws InvalidWorkbasketException, NotAuthorizedException, WorkbasketAlreadyExistException, DomainNotFoundException;

    public Workbasket updateWorkbasket(Workbasket var1) throws NotAuthorizedException;

    public WorkbasketAccessItem newWorkbasketAccessItem(String var1, String var2);

    public WorkbasketAccessItem createWorkbasketAccessItem(WorkbasketAccessItem var1) throws InvalidArgumentException, NotAuthorizedException, WorkbasketNotFoundException;

    public WorkbasketAccessItem updateWorkbasketAccessItem(WorkbasketAccessItem var1) throws InvalidArgumentException, NotAuthorizedException;

    public void deleteWorkbasketAccessItem(String var1) throws NotAuthorizedException;

    public void checkAuthorization(String var1, WorkbasketPermission ... var2) throws NotAuthorizedException, WorkbasketNotFoundException;

    public void checkAuthorization(String var1, String var2, WorkbasketPermission ... var3) throws NotAuthorizedException, WorkbasketNotFoundException;

    public List<WorkbasketAccessItem> getWorkbasketAccessItems(String var1) throws NotAuthorizedException;

    public void setWorkbasketAccessItems(String var1, List<WorkbasketAccessItem> var2) throws InvalidArgumentException, NotAuthorizedException;

    public WorkbasketQuery createWorkbasketQuery();

    public WorkbasketAccessItemQuery createWorkbasketAccessItemQuery() throws NotAuthorizedException;

    public Workbasket newWorkbasket(String var1, String var2);

    public List<WorkbasketPermission> getPermissionsForWorkbasket(String var1);

    public List<WorkbasketSummary> getDistributionTargets(String var1) throws NotAuthorizedException, WorkbasketNotFoundException;

    public List<WorkbasketSummary> getDistributionTargets(String var1, String var2) throws NotAuthorizedException, WorkbasketNotFoundException;

    public void setDistributionTargets(String var1, List<String> var2) throws NotAuthorizedException, WorkbasketNotFoundException;

    public void addDistributionTarget(String var1, String var2) throws NotAuthorizedException, WorkbasketNotFoundException;

    public void removeDistributionTarget(String var1, String var2) throws NotAuthorizedException;

    public boolean deleteWorkbasket(String var1) throws NotAuthorizedException, WorkbasketNotFoundException, WorkbasketInUseException, InvalidArgumentException;

    public BulkOperationResults<String, TaskanaException> deleteWorkbaskets(List<String> var1) throws NotAuthorizedException, WorkbasketNotFoundException, WorkbasketInUseException, InvalidArgumentException;

    public List<WorkbasketSummary> getDistributionSources(String var1) throws NotAuthorizedException, WorkbasketNotFoundException;

    public List<WorkbasketSummary> getDistributionSources(String var1, String var2) throws NotAuthorizedException, WorkbasketNotFoundException;

    public void deleteWorkbasketAccessItemsForAccessId(String var1) throws NotAuthorizedException;
}

