/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.report.TimeIntervalColumnHeader;
import pro.taskana.impl.util.LoggerUtils;

public final class DaysToWorkingDaysConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private static DaysToWorkingDaysConverter instance;
    private static ArrayList<Integer> positiveDaysToWorkingDays;
    private static ArrayList<Integer> negativeDaysToWorkingDays;
    private static Instant dateCreated;
    private static LocalDate easterSunday;
    private static boolean germanHolidaysEnabled;
    private static List<LocalDate> customHolidays;

    private DaysToWorkingDaysConverter(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        easterSunday = this.getEasterSunday(LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).getYear());
        dateCreated = referenceDate;
        positiveDaysToWorkingDays = this.generatePositiveDaysToWorkingDays(columnHeaders, referenceDate);
        negativeDaysToWorkingDays = this.generateNegativeDaysToWorkingDays(columnHeaders, referenceDate);
    }

    public static DaysToWorkingDaysConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException {
        return DaysToWorkingDaysConverter.initialize(columnHeaders, Instant.now());
    }

    public static DaysToWorkingDaysConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize DaysToWorkingDaysConverter with columnHeaders: {}", (Object)LoggerUtils.listToString(columnHeaders));
        }
        if (columnHeaders == null) {
            throw new InvalidArgumentException("TimeIntervalColumnHeaders can\u00b4t be used as NULL-Parameter");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can\u00b4t be used as NULL-Parameter");
        }
        int largesLowerLimit = DaysToWorkingDaysConverter.getLargestLowerLimit(columnHeaders);
        int smallestUpperLimit = DaysToWorkingDaysConverter.getSmallestUpperLimit(columnHeaders);
        if (!(instance != null && positiveDaysToWorkingDays.contains(largesLowerLimit) && negativeDaysToWorkingDays.contains(smallestUpperLimit) && dateCreated.truncatedTo(ChronoUnit.DAYS).equals(referenceDate.truncatedTo(ChronoUnit.DAYS)))) {
            instance = new DaysToWorkingDaysConverter(columnHeaders, referenceDate);
            LOGGER.debug("Create new converter for the values from {} until {} for the date: {}.", new Object[]{largesLowerLimit, smallestUpperLimit, dateCreated});
        }
        return instance;
    }

    private static int getSmallestUpperLimit(List<? extends TimeIntervalColumnHeader> columnHeaders) {
        int smallestUpperLimit = 0;
        for (TimeIntervalColumnHeader timeIntervalColumnHeader : columnHeaders) {
            if (timeIntervalColumnHeader.getUpperAgeLimit() >= smallestUpperLimit) continue;
            smallestUpperLimit = timeIntervalColumnHeader.getUpperAgeLimit();
        }
        return smallestUpperLimit;
    }

    private static int getLargestLowerLimit(List<? extends TimeIntervalColumnHeader> columnHeaders) {
        int greatestLowerLimit = 0;
        for (TimeIntervalColumnHeader timeIntervalColumnHeader : columnHeaders) {
            if (timeIntervalColumnHeader.getUpperAgeLimit() <= greatestLowerLimit) continue;
            greatestLowerLimit = timeIntervalColumnHeader.getLowerAgeLimit();
        }
        return greatestLowerLimit;
    }

    public static void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        germanHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public int convertDaysToWorkingDays(int ageInDays) {
        int minDay = -(negativeDaysToWorkingDays.size() - 1);
        int maxDay = positiveDaysToWorkingDays.size() - 1;
        if (ageInDays >= minDay && ageInDays <= 0) {
            return negativeDaysToWorkingDays.get(-ageInDays);
        }
        if (ageInDays > 0 && ageInDays <= maxDay) {
            return positiveDaysToWorkingDays.get(ageInDays);
        }
        return ageInDays;
    }

    public ArrayList<Integer> convertWorkingDaysToDays(int ageInWorkingDays) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int minWorkingDay = negativeDaysToWorkingDays.get(negativeDaysToWorkingDays.size() - 1);
        int maxWorkingDay = positiveDaysToWorkingDays.get(positiveDaysToWorkingDays.size() - 1);
        if (ageInWorkingDays >= minWorkingDay && ageInWorkingDays < 0) {
            for (int ageInDays = 0; ageInDays < negativeDaysToWorkingDays.size(); ++ageInDays) {
                if (negativeDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(-ageInDays);
            }
            return list;
        }
        if (ageInWorkingDays > 0 && ageInWorkingDays <= maxWorkingDay) {
            for (int ageInDays = 0; ageInDays < positiveDaysToWorkingDays.size(); ++ageInDays) {
                if (positiveDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(ageInDays);
            }
            return list;
        }
        if (ageInWorkingDays == 0) {
            int ageInDays;
            list.add(0);
            for (ageInDays = 1; ageInDays < positiveDaysToWorkingDays.size(); ++ageInDays) {
                if (positiveDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(ageInDays);
            }
            for (ageInDays = 1; ageInDays < negativeDaysToWorkingDays.size(); ++ageInDays) {
                if (negativeDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(-ageInDays);
            }
            return list;
        }
        list.add(ageInWorkingDays);
        return list;
    }

    public long convertWorkingDaysToDays(Instant startTime, long numberOfDays) {
        int days = 0;
        int workingDays = 0;
        while ((long)workingDays < numberOfDays) {
            if (this.isWorkingDay(days, startTime)) {
                ++workingDays;
            }
            ++days;
            while (!this.isWorkingDay(days, startTime)) {
                ++days;
            }
        }
        return days;
    }

    private ArrayList<Integer> generateNegativeDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        int minUpperLimit = DaysToWorkingDaysConverter.getSmallestUpperLimit(columnHeaders);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = -1;
        int workingDay = 0;
        while (workingDay > minUpperLimit) {
            if (this.isWorkingDay(day, referenceDate)) {
                --workingDay;
            }
            daysToWorkingDays.add(workingDay);
            --day;
        }
        return daysToWorkingDays;
    }

    private ArrayList<Integer> generatePositiveDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        int maxLowerLimit = DaysToWorkingDaysConverter.getLargestLowerLimit(columnHeaders);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = 1;
        int workingDay = 0;
        while (workingDay < maxLowerLimit) {
            if (this.isWorkingDay(day, referenceDate)) {
                ++workingDay;
            }
            daysToWorkingDays.add(workingDay);
            ++day;
        }
        return daysToWorkingDays;
    }

    private boolean isWorkingDay(int day, Instant referenceDate) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day);
        return !dateTime.getDayOfWeek().equals(DayOfWeek.SATURDAY) && !dateTime.getDayOfWeek().equals(DayOfWeek.SUNDAY) && !this.isHoliday(dateTime.toLocalDate());
    }

    private boolean isHoliday(LocalDate date) {
        if (germanHolidaysEnabled && (date.getDayOfMonth() == 1 && date.getMonthValue() == 1 || date.getDayOfMonth() == 1 && date.getMonthValue() == 5 || date.getDayOfMonth() == 3 && date.getMonthValue() == 10 || date.getDayOfMonth() == 25 && date.getMonthValue() == 12 || date.getDayOfMonth() == 26 && date.getMonthValue() == 12 || easterSunday.minusDays(2L).equals(date) || easterSunday.plusDays(1L).equals(date) || easterSunday.plusDays(39L).equals(date) || easterSunday.plusDays(50L).equals(date))) {
            return true;
        }
        if (customHolidays != null) {
            for (LocalDate customHoliday : customHolidays) {
                if (!date.equals(customHoliday)) continue;
                return true;
            }
        }
        return false;
    }

    public LocalDate getEasterSunday(int year) {
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int k = year / 100;
        int p = (13 + 8 * k) / 25;
        int q = k / 4;
        int m = (15 - p + k - q) % 30;
        int n = (4 + k - q) % 7;
        int d = (19 * a + m) % 30;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        if (d == 29 && e == 6) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        if (d == 28 && e == 6 && (11 * m + 11) % 30 < 19) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        return LocalDate.of(year, 3, 22).plusDays(d + e);
    }

    public List<LocalDate> getCustomHolidays() {
        return customHolidays;
    }

    public static void setCustomHolidays(List<LocalDate> holidays) {
        customHolidays = holidays;
    }

    public boolean isGermanPublicHolidayEnabled() {
        return germanHolidaysEnabled;
    }

    public String toString() {
        return "DaysToWorkingDaysConverter [instance= " + instance + ", positiveDaysToWorkingDays= " + positiveDaysToWorkingDays + ", negativeDaysToWorkingDays= " + negativeDaysToWorkingDays + ", dateCreated= " + dateCreated + ", easterSunday= " + easterSunday + ", germanHolidaysEnabled= " + germanHolidaysEnabled + ", customHolidays= " + LoggerUtils.listToString(customHolidays) + "]";
    }
}

