/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.JobService;
import pro.taskana.TaskanaEngine;
import pro.taskana.impl.TaskanaEngineImpl;
import pro.taskana.jobs.ScheduledJob;
import pro.taskana.mappings.JobMapper;

public class JobServiceImpl
implements JobService {
    public static final Integer JOB_DEFAULT_PRIORITY = 50;
    public static final long DEFAULT_LOCK_EXPIRATION_PERIOD = 60000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobServiceImpl.class);
    private JobMapper jobMapper;
    private TaskanaEngineImpl taskanaEngineImpl;

    public JobServiceImpl(TaskanaEngine taskanaEngine, JobMapper jobMapper) {
        this.taskanaEngineImpl = (TaskanaEngineImpl)taskanaEngine;
        this.jobMapper = jobMapper;
    }

    @Override
    public ScheduledJob createJob(ScheduledJob job) {
        LOGGER.debug("Entry to createJob({})", (Object)job);
        try {
            this.taskanaEngineImpl.openConnection();
            job = this.initializeJobDefault(job);
            this.jobMapper.insertJob(job);
            LOGGER.debug("Created job {}", (Object)job);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
        }
        LOGGER.debug("Exit from createJob");
        return job;
    }

    public ScheduledJob lockJob(ScheduledJob job, String owner) {
        LOGGER.debug("entry to lockJob(jobId = {}, owner = {})", (Object)job.getJobId(), (Object)owner);
        try {
            this.taskanaEngineImpl.openConnection();
            job.setLockedBy(owner);
            job.setLockExpires(Instant.now().plusMillis(60000L));
            job.setRetryCount(job.getRetryCount() - 1);
            this.jobMapper.update(job);
            LOGGER.debug("Job {} locked. Remaining retries: {}", (Object)job.getJobId(), (Object)job.getRetryCount());
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from lockJob()");
        }
        return job;
    }

    public List<ScheduledJob> findJobsToRun() {
        List<ScheduledJob> availableJobs;
        LOGGER.debug("entry to findJobsToRun");
        try {
            this.taskanaEngineImpl.openConnection();
            availableJobs = this.jobMapper.findJobsToRun();
            LOGGER.debug("Found available jobs: {}", availableJobs);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from findJobsToRun()");
        }
        return availableJobs;
    }

    public void deleteJob(ScheduledJob job) {
        LOGGER.debug("entry to deleteJob(jobId = {})", (Object)job.getJobId());
        try {
            this.taskanaEngineImpl.openConnection();
            this.jobMapper.delete(job);
            LOGGER.debug("Deleted job: {}", (Object)job);
        }
        finally {
            this.taskanaEngineImpl.returnConnection();
            LOGGER.debug("exit from deleteJob()");
        }
    }

    private ScheduledJob initializeJobDefault(ScheduledJob job) {
        LOGGER.debug("entry to initializeJobDefault(job = {})", (Object)job);
        job.setCreated(Instant.now());
        job.setState(ScheduledJob.State.READY);
        job.setPriority(JOB_DEFAULT_PRIORITY);
        if (job.getDue() == null) {
            job.setDue(Instant.now());
        }
        job.setRetryCount(this.taskanaEngineImpl.getConfiguration().getMaxNumberOfJobRetries());
        LOGGER.debug("Job after initialization: {}", (Object)job);
        return job;
    }
}

