/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report.header;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import pro.taskana.impl.report.item.AgeQueryItem;
import pro.taskana.impl.report.structure.ColumnHeader;

public class TimeIntervalColumnHeader
implements ColumnHeader<AgeQueryItem> {
    private final int lowerAgeLimit;
    private final int upperAgeLimit;

    public TimeIntervalColumnHeader(int ageInDays) {
        this.lowerAgeLimit = ageInDays;
        this.upperAgeLimit = ageInDays;
    }

    public TimeIntervalColumnHeader(int lowerAgeLimit, int upperAgeLimit) {
        this.lowerAgeLimit = lowerAgeLimit;
        this.upperAgeLimit = upperAgeLimit;
    }

    public int getLowerAgeLimit() {
        return this.lowerAgeLimit;
    }

    public int getUpperAgeLimit() {
        return this.upperAgeLimit;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public String getDisplayName() {
        return "(" + this.lowerAgeLimit + "," + this.upperAgeLimit + ")";
    }

    @Override
    public boolean fits(AgeQueryItem item) {
        return this.lowerAgeLimit <= item.getAgeInDays() && this.upperAgeLimit >= item.getAgeInDays();
    }

    public static class Range
    extends TimeIntervalColumnHeader {
        public Range(int ageInDays) {
            super(ageInDays);
        }

        public Range(int lowerAgeLimit, int upperAgeLimit) {
            super(lowerAgeLimit, upperAgeLimit);
        }

        @Override
        public String getDisplayName() {
            if (this.getLowerAgeLimit() == Integer.MIN_VALUE) {
                return "<" + this.getUpperAgeLimit();
            }
            if (this.getUpperAgeLimit() == Integer.MAX_VALUE) {
                return ">" + this.getLowerAgeLimit();
            }
            if (this.getLowerAgeLimit() == this.getUpperAgeLimit()) {
                return this.getUpperAgeLimit() + "";
            }
            if (this.getLowerAgeLimit() != this.getUpperAgeLimit()) {
                return "[" + this.getLowerAgeLimit() + " ... " + this.getUpperAgeLimit() + "]";
            }
            return super.getDisplayName();
        }
    }

    public static class Date
    extends TimeIntervalColumnHeader {
        public Date(int ageInDays) {
            super(ageInDays);
        }

        @Override
        public String getDisplayName() {
            LocalDateTime ldt = LocalDateTime.now().plusDays(this.getLowerAgeLimit());
            DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
            return dateFormat.format(ldt);
        }
    }
}

