/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report.structure;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.report.row.SingleRow;
import pro.taskana.impl.report.structure.ColumnHeader;
import pro.taskana.impl.report.structure.QueryItem;
import pro.taskana.impl.report.structure.QueryItemPreprocessor;
import pro.taskana.impl.report.structure.Row;

public abstract class Report<I extends QueryItem, H extends ColumnHeader<? super I>> {
    protected List<H> columnHeaders;
    private Map<String, Row<I>> reportRows = new LinkedHashMap<String, Row<I>>();
    private Row<I> sumRow;
    private String[] rowDesc;

    protected Report(List<H> columnHeaders, String[] rowDesc) {
        this.rowDesc = rowDesc;
        this.sumRow = this.createRow(columnHeaders.size());
        this.columnHeaders = new ArrayList<H>(columnHeaders);
    }

    public final Map<String, Row<I>> getRows() {
        return this.reportRows;
    }

    public final Row<I> getSumRow() {
        return this.sumRow;
    }

    public final List<H> getColumnHeaders() {
        return this.columnHeaders;
    }

    public final String[] getRowDesc() {
        return this.rowDesc;
    }

    public Row<I> getRow(String key) {
        return this.reportRows.get(key);
    }

    public final Set<String> rowTitles() {
        return this.reportRows.keySet();
    }

    public final int rowSize() {
        return this.reportRows.size();
    }

    public final void addItem(I item) {
        Row row = null;
        if (this.columnHeaders.isEmpty()) {
            row = this.reportRows.computeIfAbsent(item.getKey(), s -> this.createRow(this.columnHeaders.size()));
            row.updateTotalValue(item);
            this.sumRow.updateTotalValue(item);
        } else {
            for (int i = 0; i < this.columnHeaders.size(); ++i) {
                if (!((ColumnHeader)this.columnHeaders.get(i)).fits(item)) continue;
                if (row == null) {
                    row = this.reportRows.computeIfAbsent(item.getKey(), s -> this.createRow(this.columnHeaders.size()));
                }
                row.addItem(item, i);
                this.sumRow.addItem(item, i);
            }
        }
    }

    public final void addItem(I item, QueryItemPreprocessor<I> preprocessor) {
        this.addItem(preprocessor.apply(item));
    }

    public final void addItems(List<? extends I> items, QueryItemPreprocessor<I> preprocessor) {
        items.stream().map(preprocessor::apply).forEach(this::addItem);
    }

    public final void addItems(List<I> items) {
        items.forEach(this::addItem);
    }

    protected Row<I> createRow(int columnSize) {
        return new SingleRow(columnSize);
    }

    public static interface Builder<I extends QueryItem, H extends ColumnHeader<? super I>> {
        public Report<I, H> buildReport() throws NotAuthorizedException, InvalidArgumentException;
    }
}

