/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbSchemaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSchemaCreator.class);
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA = "/sql/taskana-schema.sql";
    private static final String DB_SCHEMA_DB2 = "/sql/taskana-schema-db2.sql";
    private static final String DB_SCHEMA_POSTGRES = "/sql/taskana-schema-postgres.sql";
    private static final String DB_SCHEMA_DETECTION = "/sql/schema-detection.sql";
    private static final String DB_SCHEMA_DETECTION_POSTGRES = "/sql/schema-detection-postgres.sql";
    private DataSource dataSource;
    private String schemaName;
    private StringWriter outWriter = new StringWriter();
    private PrintWriter logWriter = new PrintWriter(this.outWriter);
    private StringWriter errorWriter = new StringWriter();
    private PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);

    public DbSchemaCreator(DataSource dataSource, String schema) {
        this.dataSource = dataSource;
        this.schemaName = schema;
    }

    private static String selectDbScriptFileName(String dbProductName) {
        return "PostgreSQL".equals(dbProductName) ? DB_SCHEMA_POSTGRES : ("H2".equals(dbProductName) ? DB_SCHEMA : DB_SCHEMA_DB2);
    }

    private static String selectDbSchemaDetectionScript(String dbProductName) {
        return "PostgreSQL".equals(dbProductName) ? DB_SCHEMA_DETECTION_POSTGRES : DB_SCHEMA_DETECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException {
        Connection connection = this.dataSource.getConnection();
        LOGGER.debug("Using database of type {} with url '{}'", (Object)connection.getMetaData().getDatabaseProductName(), (Object)connection.getMetaData().getURL());
        ScriptRunner runner = this.getScriptRunnerInstance(connection);
        try {
            if (!this.isSchemaPreexisting(connection)) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(DbSchemaCreator.selectDbScriptFileName(connection.getMetaData().getDatabaseProductName()))));
                runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
            }
        }
        finally {
            runner.closeConnection();
        }
        LOGGER.debug(this.outWriter.toString());
        if (!this.errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(this.errorWriter.toString());
        }
    }

    private ScriptRunner getScriptRunnerInstance(Connection connection) {
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        return runner;
    }

    private boolean isSchemaPreexisting(Connection connection) {
        ScriptRunner runner = this.getScriptRunnerInstance(connection);
        StringWriter errorWriter = new StringWriter();
        runner.setErrorLogWriter(new PrintWriter(errorWriter));
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(DbSchemaCreator.selectDbSchemaDetectionScript(connection.getMetaData().getDatabaseProductName()))));
            runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
        }
        catch (Exception e) {
            LOGGER.debug("Schema does not exist.");
            if (!errorWriter.toString().trim().isEmpty()) {
                LOGGER.debug(errorWriter.toString());
            }
            return false;
        }
        LOGGER.debug("Schema does exist.");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSchemaVersion(String expectedVersion) {
        SqlRunner runner = null;
        try {
            Connection connection = this.dataSource.getConnection();
            connection.setSchema(this.schemaName);
            runner = new SqlRunner(connection);
            LOGGER.debug(connection.getMetaData().toString());
            String query = "select VERSION from TASKANA_SCHEMA_VERSION where VERSION = (select max(VERSION) from TASKANA_SCHEMA_VERSION) AND VERSION = ?";
            Map queryResult = runner.selectOne(query, new Object[]{expectedVersion});
            if (queryResult == null || queryResult.isEmpty()) {
                LOGGER.error("Schema version not valid. The VERSION property in table TASKANA_SCHEMA_VERSION has not the expected value {}", (Object)expectedVersion);
                boolean bl = false;
                return bl;
            }
            LOGGER.debug("Schema version is valid.");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Schema version not valid. The VERSION property in table TASKANA_SCHEMA_VERSION has not the expected value {}", (Object)expectedVersion);
            boolean bl = false;
            return bl;
        }
        finally {
            if (runner != null) {
                runner.closeConnection();
            }
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private StringReader getSqlSchemaNameParsed(BufferedReader reader) {
        StringBuffer content = new StringBuffer();
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                content.append(line.replaceAll("%schemaName%", this.schemaName) + System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOGGER.error("SchemaName sql parsing failed for schemaName {}", (Object)this.schemaName);
        }
        return new StringReader(content.toString());
    }
}

