/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.AbstractWorkbasketAccessItemQuery;
import pro.taskana.AccessItemQueryColumnName;
import pro.taskana.BaseQuery;
import pro.taskana.WorkbasketAccessItem;
import pro.taskana.exceptions.TaskanaRuntimeException;
import pro.taskana.impl.InternalTaskanaEngine;
import pro.taskana.impl.WorkbasketQueryImpl;
import pro.taskana.impl.util.LoggerUtils;

abstract class AbstractWorkbasketAccessItemQueryImpl<Q extends AbstractWorkbasketAccessItemQuery<Q, T>, T extends WorkbasketAccessItem>
implements AbstractWorkbasketAccessItemQuery<Q, T> {
    private static final String LINK_TO_COUNTER = "pro.taskana.mappings.QueryMapper.countQueryWorkbasketAccessItems";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractWorkbasketAccessItemQueryImpl.class);
    private AccessItemQueryColumnName columnName;
    private String[] accessIdIn;
    private String[] workbasketIdIn;
    private String[] idIn;
    private InternalTaskanaEngine taskanaEngine;
    private List<String> orderBy;
    private List<String> orderColumns;

    AbstractWorkbasketAccessItemQueryImpl(InternalTaskanaEngine taskanaEngine) {
        this.taskanaEngine = taskanaEngine;
        this.orderBy = new ArrayList<String>();
        this.orderColumns = new ArrayList<String>();
    }

    abstract Q _this();

    abstract String getLinkToMapper();

    abstract String getLinkToValueMapper();

    @Override
    public Q idIn(String ... ids) {
        this.idIn = ids;
        return this._this();
    }

    @Override
    public Q workbasketIdIn(String ... id) {
        this.workbasketIdIn = id;
        return this._this();
    }

    @Override
    public Q accessIdIn(String ... accessId) {
        this.accessIdIn = accessId;
        WorkbasketQueryImpl.lowercaseAccessIds(this.accessIdIn);
        return this._this();
    }

    @Override
    public Q orderById(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ID", sortDirection);
    }

    @Override
    public Q orderByWorkbasketId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("WORKBASKET_ID", sortDirection);
    }

    @Override
    public Q orderByAccessId(BaseQuery.SortDirection sortDirection) {
        return this.addOrderCriteria("ACCESS_ID", sortDirection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> list() {
        LOGGER.debug("entry to list(), this = {}", this._this());
        ArrayList result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            List foundAccessItms = this.taskanaEngine.getSqlSession().selectList(this.getLinkToMapper(), this._this());
            result.addAll(foundAccessItms);
            ArrayList arrayList = result;
            return arrayList;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(). Returning {} resulting Objects: {} ", (Object)result.size(), (Object)LoggerUtils.listToString(result));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listValues(AccessItemQueryColumnName columnName, BaseQuery.SortDirection sortDirection) {
        List list;
        LOGGER.debug("Entry to listValues(dbColumnName={}) this = {}", (Object)columnName, this._this());
        List result = null;
        try {
            this.taskanaEngine.openConnection();
            this.columnName = columnName;
            this.orderBy.clear();
            this.addOrderCriteria(columnName.toString(), sortDirection);
            list = result = this.taskanaEngine.getSqlSession().selectList(this.getLinkToValueMapper(), this._this());
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                int numberOfResultObjects = result == null ? 0 : result.size();
                LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            int numberOfResultObjects = result == null ? 0 : result.size();
            LOGGER.debug("Exit from listValues. Returning {} resulting Objects: {} ", (Object)numberOfResultObjects, (Object)LoggerUtils.listToString(result));
        }
        return list;
    }

    @Override
    public List<T> list(int offset, int limit) {
        LOGGER.debug("entry to list(offset = {}, limit = {}), this = {}", new Object[]{offset, limit, this._this()});
        ArrayList result = new ArrayList();
        try {
            this.taskanaEngine.openConnection();
            RowBounds rowBounds = new RowBounds(offset, limit);
            List foundAccessItms = this.taskanaEngine.getSqlSession().selectList(this.getLinkToMapper(), this._this(), rowBounds);
            result.addAll(foundAccessItms);
            ArrayList arrayList = result;
            return arrayList;
        }
        catch (PersistenceException e) {
            if (e.getMessage().contains("ERRORCODE=-4470")) {
                TaskanaRuntimeException ex = new TaskanaRuntimeException("The offset beginning was set over the amount of result-rows.", e.getCause());
                ex.setStackTrace(e.getStackTrace());
                throw ex;
            }
            throw e;
        }
        finally {
            this.taskanaEngine.returnConnection();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("exit from list(offset,limit). Returning {} resulting Objects: {} ", (Object)result.size(), (Object)LoggerUtils.listToString(result));
            }
        }
    }

    @Override
    public T single() {
        WorkbasketAccessItem workbasketAccessItem;
        LOGGER.debug("entry to single(), this = {}", this._this());
        WorkbasketAccessItem accessItem = null;
        try {
            this.taskanaEngine.openConnection();
            workbasketAccessItem = accessItem = (WorkbasketAccessItem)this.taskanaEngine.getSqlSession().selectOne(this.getLinkToMapper(), this._this());
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from single(). Returning result {} ", accessItem);
            throw throwable;
        }
        LOGGER.debug("exit from single(). Returning result {} ", (Object)accessItem);
        return (T)workbasketAccessItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count() {
        long l;
        LOGGER.debug("entry to count(), this = {}", this._this());
        Long rowCount = null;
        try {
            this.taskanaEngine.openConnection();
            rowCount = (Long)this.taskanaEngine.getSqlSession().selectOne(LINK_TO_COUNTER, this._this());
            l = rowCount == null ? 0L : rowCount;
            this.taskanaEngine.returnConnection();
        }
        catch (Throwable throwable) {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from count(). Returning result {} ", rowCount);
            throw throwable;
        }
        LOGGER.debug("exit from count(). Returning result {} ", (Object)rowCount);
        return l;
    }

    protected Q addOrderCriteria(String colName, BaseQuery.SortDirection sortDirection) {
        String orderByDirection = " " + (Object)((Object)(sortDirection == null ? BaseQuery.SortDirection.ASCENDING : sortDirection));
        this.orderBy.add(colName + orderByDirection);
        this.orderColumns.add(colName);
        return this._this();
    }

    public String[] getIdIn() {
        return this.idIn;
    }

    public String[] getAccessIdIn() {
        return this.accessIdIn;
    }

    public String[] getWorkbasketIdIn() {
        return this.workbasketIdIn;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    public List<String> getOrderColumns() {
        return this.orderColumns;
    }

    public AccessItemQueryColumnName getColumnName() {
        return this.columnName;
    }

    public String toString() {
        return "AbstractWorkbasketAccessItemQueryImpl [idIn=" + Arrays.toString(this.idIn) + ", accessIdIn=" + Arrays.toString(this.accessIdIn) + ", workbasketIdIn=" + Arrays.toString(this.workbasketIdIn) + ", orderBy=" + this.orderBy + "]";
    }
}

