/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pro.taskana.Attachment;
import pro.taskana.AttachmentSummary;
import pro.taskana.CallbackState;
import pro.taskana.ClassificationSummary;
import pro.taskana.ObjectReference;
import pro.taskana.Task;
import pro.taskana.TaskState;
import pro.taskana.TaskSummary;
import pro.taskana.WorkbasketSummary;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.impl.ClassificationSummaryImpl;
import pro.taskana.impl.TaskSummaryImpl;
import pro.taskana.impl.WorkbasketSummaryImpl;

public class TaskImpl
implements Task {
    private String id;
    private String externalId;
    private Instant created;
    private Instant claimed;
    private Instant completed;
    private Instant modified;
    private Instant planned;
    private Instant due;
    private String name;
    private String creator;
    private String description;
    private String note;
    private int priority;
    private TaskState state;
    private ClassificationSummary classificationSummary;
    private WorkbasketSummary workbasketSummary;
    private String businessProcessId;
    private String parentBusinessProcessId;
    private String owner;
    private ObjectReference primaryObjRef;
    private boolean isRead;
    private boolean isTransferred;
    private Map<String, String> customAttributes = Collections.emptyMap();
    private Map<String, String> callbackInfo = Collections.emptyMap();
    private CallbackState callbackState;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private String custom1;
    private String custom2;
    private String custom3;
    private String custom4;
    private String custom5;
    private String custom6;
    private String custom7;
    private String custom8;
    private String custom9;
    private String custom10;
    private String custom11;
    private String custom12;
    private String custom13;
    private String custom14;
    private String custom15;
    private String custom16;
    private static final String ARGUMENT_STR = "Argument '";
    private static final String NOT_A_VALID_NUMBER_GET = "' of getCustomAttribute() cannot be converted to a number between 1 and 16";
    private static final String NOT_A_VALID_NUMBER_SET = "' of setCustomAttribute() cannot be converted to a number between 1 and 16";

    TaskImpl() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    @Override
    public Instant getCreated() {
        return this.created;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    @Override
    public Instant getClaimed() {
        return this.claimed;
    }

    public void setClaimed(Instant claimed) {
        this.claimed = claimed;
    }

    @Override
    public Instant getCompleted() {
        return this.completed;
    }

    public void setCompleted(Instant completed) {
        this.completed = completed;
    }

    @Override
    public Instant getModified() {
        return this.modified;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    @Override
    public Instant getPlanned() {
        return this.planned;
    }

    @Override
    public void setPlanned(Instant planned) {
        this.planned = planned;
    }

    @Override
    public Instant getDue() {
        return this.due;
    }

    @Override
    public void setDue(Instant due) {
        this.due = due;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getNote() {
        return this.note;
    }

    @Override
    public void setNote(String note) {
        this.note = note;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState state) {
        this.state = state;
    }

    @Override
    public ClassificationSummary getClassificationSummary() {
        return this.classificationSummary;
    }

    @Override
    public void setClassificationKey(String classificationKey) {
        if (this.classificationSummary == null) {
            this.classificationSummary = new ClassificationSummaryImpl();
        }
        ((ClassificationSummaryImpl)this.classificationSummary).setKey(classificationKey);
    }

    public void setClassificationCategory(String classificationCategory) {
        if (this.classificationSummary == null) {
            this.classificationSummary = new ClassificationSummaryImpl();
        }
        ((ClassificationSummaryImpl)this.classificationSummary).setCategory(classificationCategory);
    }

    @Override
    public String getClassificationCategory() {
        return this.classificationSummary == null ? null : this.classificationSummary.getCategory();
    }

    @Override
    public String getWorkbasketKey() {
        return this.workbasketSummary == null ? null : this.workbasketSummary.getKey();
    }

    public void setWorkbasketKey(String workbasketKey) {
        if (this.workbasketSummary == null) {
            this.workbasketSummary = new WorkbasketSummaryImpl();
        }
        ((WorkbasketSummaryImpl)this.workbasketSummary).setKey(workbasketKey);
    }

    @Override
    public WorkbasketSummary getWorkbasketSummary() {
        return this.workbasketSummary;
    }

    public void setWorkbasketSummary(WorkbasketSummary workbasket) {
        this.workbasketSummary = workbasket;
    }

    @Override
    public String getDomain() {
        return this.workbasketSummary == null ? null : this.workbasketSummary.getDomain();
    }

    public void setDomain(String domain) {
        if (this.workbasketSummary == null) {
            this.workbasketSummary = new WorkbasketSummaryImpl();
        }
        ((WorkbasketSummaryImpl)this.workbasketSummary).setDomain(domain);
    }

    @Override
    public String getBusinessProcessId() {
        return this.businessProcessId;
    }

    @Override
    public void setBusinessProcessId(String businessProcessId) {
        this.businessProcessId = businessProcessId;
    }

    @Override
    public String getParentBusinessProcessId() {
        return this.parentBusinessProcessId;
    }

    @Override
    public void setParentBusinessProcessId(String parentBusinessProcessId) {
        this.parentBusinessProcessId = parentBusinessProcessId;
    }

    @Override
    public String getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Override
    public ObjectReference getPrimaryObjRef() {
        return this.primaryObjRef;
    }

    @Override
    public void setPrimaryObjRef(ObjectReference primaryObjRef) {
        this.primaryObjRef = primaryObjRef;
    }

    @Override
    public boolean isRead() {
        return this.isRead;
    }

    public void setRead(boolean isRead) {
        this.isRead = isRead;
    }

    @Override
    public boolean isTransferred() {
        return this.isTransferred;
    }

    public void setTransferred(boolean isTransferred) {
        this.isTransferred = isTransferred;
    }

    @Override
    public Map<String, String> getCustomAttributes() {
        if (this.customAttributes == null) {
            this.customAttributes = new HashMap<String, String>();
        }
        return this.customAttributes;
    }

    @Override
    public void setCustomAttributes(Map<String, String> customAttributes) {
        this.customAttributes = customAttributes;
    }

    @Override
    public Map<String, String> getCallbackInfo() {
        if (this.callbackInfo == null) {
            this.callbackInfo = new HashMap<String, String>();
        }
        return this.callbackInfo;
    }

    @Override
    public void setCallbackInfo(Map<String, String> callbackInfo) {
        this.callbackInfo = callbackInfo;
    }

    public CallbackState getCallbackState() {
        return this.callbackState;
    }

    public void setCallbackState(CallbackState callbackState) {
        this.callbackState = callbackState;
    }

    @Override
    public String getCustomAttribute(String number) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(ARGUMENT_STR + number + NOT_A_VALID_NUMBER_GET, e.getCause());
        }
        switch (num) {
            case 1: {
                return this.custom1;
            }
            case 2: {
                return this.custom2;
            }
            case 3: {
                return this.custom3;
            }
            case 4: {
                return this.custom4;
            }
            case 5: {
                return this.custom5;
            }
            case 6: {
                return this.custom6;
            }
            case 7: {
                return this.custom7;
            }
            case 8: {
                return this.custom8;
            }
            case 9: {
                return this.custom9;
            }
            case 10: {
                return this.custom10;
            }
            case 11: {
                return this.custom11;
            }
            case 12: {
                return this.custom12;
            }
            case 13: {
                return this.custom13;
            }
            case 14: {
                return this.custom14;
            }
            case 15: {
                return this.custom15;
            }
            case 16: {
                return this.custom16;
            }
        }
        throw new InvalidArgumentException(ARGUMENT_STR + number + NOT_A_VALID_NUMBER_GET);
    }

    @Override
    public void setCustomAttribute(String number, String value) throws InvalidArgumentException {
        int num = 0;
        try {
            num = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            throw new InvalidArgumentException(ARGUMENT_STR + number + NOT_A_VALID_NUMBER_SET, e.getCause());
        }
        switch (num) {
            case 1: {
                this.custom1 = value;
                break;
            }
            case 2: {
                this.custom2 = value;
                break;
            }
            case 3: {
                this.custom3 = value;
                break;
            }
            case 4: {
                this.custom4 = value;
                break;
            }
            case 5: {
                this.custom5 = value;
                break;
            }
            case 6: {
                this.custom6 = value;
                break;
            }
            case 7: {
                this.custom7 = value;
                break;
            }
            case 8: {
                this.custom8 = value;
                break;
            }
            case 9: {
                this.custom9 = value;
                break;
            }
            case 10: {
                this.custom10 = value;
                break;
            }
            case 11: {
                this.custom11 = value;
                break;
            }
            case 12: {
                this.custom12 = value;
                break;
            }
            case 13: {
                this.custom13 = value;
                break;
            }
            case 14: {
                this.custom14 = value;
                break;
            }
            case 15: {
                this.custom15 = value;
                break;
            }
            case 16: {
                this.custom16 = value;
                break;
            }
            default: {
                throw new InvalidArgumentException(ARGUMENT_STR + number + NOT_A_VALID_NUMBER_SET);
            }
        }
    }

    @Override
    public void addAttachment(Attachment attachmentToAdd) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        if (attachmentToAdd != null) {
            if (attachmentToAdd.getId() != null) {
                Iterator<Attachment> i = this.attachments.iterator();
                while (i.hasNext()) {
                    Attachment attachment = i.next();
                    if (!attachmentToAdd.getId().equals(attachment.getId())) continue;
                    i.remove();
                }
            }
            this.attachments.add(attachmentToAdd);
        }
    }

    @Override
    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        return this.attachments;
    }

    @Override
    public TaskSummary asSummary() {
        TaskSummaryImpl taskSummary = new TaskSummaryImpl();
        ArrayList<AttachmentSummary> attSummaries = new ArrayList<AttachmentSummary>();
        for (Attachment att : this.attachments) {
            attSummaries.add(att.asSummary());
        }
        taskSummary.setAttachmentSummaries(attSummaries);
        taskSummary.setBusinessProcessId(this.businessProcessId);
        taskSummary.setClaimed(this.claimed);
        if (this.classificationSummary != null) {
            taskSummary.setClassificationSummary(this.classificationSummary);
        }
        taskSummary.setExternalId(this.externalId);
        taskSummary.setCompleted(this.completed);
        taskSummary.setCreated(this.created);
        taskSummary.setCustom1(this.custom1);
        taskSummary.setCustom2(this.custom2);
        taskSummary.setCustom3(this.custom3);
        taskSummary.setCustom4(this.custom4);
        taskSummary.setCustom5(this.custom5);
        taskSummary.setCustom6(this.custom6);
        taskSummary.setCustom7(this.custom7);
        taskSummary.setCustom8(this.custom8);
        taskSummary.setCustom9(this.custom9);
        taskSummary.setCustom10(this.custom10);
        taskSummary.setCustom11(this.custom11);
        taskSummary.setCustom12(this.custom12);
        taskSummary.setCustom13(this.custom13);
        taskSummary.setCustom14(this.custom14);
        taskSummary.setCustom15(this.custom15);
        taskSummary.setCustom16(this.custom16);
        taskSummary.setDue(this.due);
        taskSummary.setTaskId(this.id);
        taskSummary.setModified(this.modified);
        taskSummary.setName(this.name);
        taskSummary.setCreator(this.creator);
        taskSummary.setNote(this.note);
        taskSummary.setOwner(this.owner);
        taskSummary.setParentBusinessProcessId(this.parentBusinessProcessId);
        taskSummary.setPlanned(this.planned);
        taskSummary.setPrimaryObjRef(this.primaryObjRef);
        taskSummary.setPriority(this.priority);
        taskSummary.setRead(this.isRead);
        taskSummary.setState(this.state);
        taskSummary.setTransferred(this.isTransferred);
        taskSummary.setWorkbasketSummary(this.workbasketSummary);
        return taskSummary;
    }

    public void setAttachments(List<Attachment> attachments) {
        if (attachments != null) {
            this.attachments = attachments;
        } else if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
    }

    public String getClassificationKey() {
        return this.classificationSummary == null ? null : this.classificationSummary.getKey();
    }

    public void setClassificationSummary(ClassificationSummary classificationSummary) {
        this.classificationSummary = classificationSummary;
    }

    public ClassificationSummaryImpl getClassificationSummaryImpl() {
        return (ClassificationSummaryImpl)this.classificationSummary;
    }

    public WorkbasketSummaryImpl getWorkbasketSummaryImpl() {
        return (WorkbasketSummaryImpl)this.workbasketSummary;
    }

    public void setWorkbasketSummaryImpl(WorkbasketSummaryImpl workbasketSummary) {
        this.workbasketSummary = workbasketSummary;
    }

    public void setClassificationSummaryImpl(ClassificationSummaryImpl classificationSummary) {
        this.setClassificationSummary(classificationSummary);
    }

    public String getCustom1() {
        return this.custom1;
    }

    public void setCustom1(String custom1) {
        this.custom1 = custom1;
    }

    public String getCustom2() {
        return this.custom2;
    }

    public void setCustom2(String custom2) {
        this.custom2 = custom2;
    }

    public String getCustom3() {
        return this.custom3;
    }

    public void setCustom3(String custom3) {
        this.custom3 = custom3;
    }

    public String getCustom4() {
        return this.custom4;
    }

    public void setCustom4(String custom4) {
        this.custom4 = custom4;
    }

    public String getCustom5() {
        return this.custom5;
    }

    public void setCustom5(String custom5) {
        this.custom5 = custom5;
    }

    public String getCustom6() {
        return this.custom6;
    }

    public void setCustom6(String custom6) {
        this.custom6 = custom6;
    }

    public String getCustom7() {
        return this.custom7;
    }

    public void setCustom7(String custom7) {
        this.custom7 = custom7;
    }

    public String getCustom8() {
        return this.custom8;
    }

    public void setCustom8(String custom8) {
        this.custom8 = custom8;
    }

    public String getCustom9() {
        return this.custom9;
    }

    public void setCustom9(String custom9) {
        this.custom9 = custom9;
    }

    public String getCustom10() {
        return this.custom10;
    }

    public void setCustom10(String custom10) {
        this.custom10 = custom10;
    }

    public String getCustom11() {
        return this.custom11;
    }

    public void setCustom11(String custom11) {
        this.custom11 = custom11;
    }

    public String getCustom12() {
        return this.custom12;
    }

    public void setCustom12(String custom12) {
        this.custom12 = custom12;
    }

    public String getCustom13() {
        return this.custom13;
    }

    public void setCustom13(String custom13) {
        this.custom13 = custom13;
    }

    public String getCustom14() {
        return this.custom14;
    }

    public void setCustom14(String custom14) {
        this.custom14 = custom14;
    }

    public String getCustom15() {
        return this.custom15;
    }

    public void setCustom15(String custom15) {
        this.custom15 = custom15;
    }

    public String getCustom16() {
        return this.custom16;
    }

    public void setCustom16(String custom16) {
        this.custom16 = custom16;
    }

    @Override
    public Attachment removeAttachment(String attachmentId) {
        Attachment result = null;
        for (Attachment attachment : this.attachments) {
            if (!attachment.getId().equals(attachmentId) || !this.attachments.remove(attachment)) continue;
            result = attachment;
            break;
        }
        return result;
    }

    public String toString() {
        return "TaskImpl [id=" + this.id + ", externalId=" + this.externalId + ", created=" + this.created + ", claimed=" + this.claimed + ", completed=" + this.completed + ", modified=" + this.modified + ", planned=" + this.planned + ", due=" + this.due + ", name=" + this.name + ", creator=" + this.creator + ", description=" + this.description + ", note=" + this.note + ", priority=" + this.priority + ", state=" + (Object)((Object)this.state) + ", classificationSummary=" + this.classificationSummary + ", workbasketSummary=" + this.workbasketSummary + ", businessProcessId=" + this.businessProcessId + ", parentBusinessProcessId=" + this.parentBusinessProcessId + ", owner=" + this.owner + ", primaryObjRef=" + this.primaryObjRef + ", isRead=" + this.isRead + ", isTransferred=" + this.isTransferred + ", customAttributes=" + this.customAttributes + ", callbackInfo=" + this.callbackInfo + ", callbackState=" + (Object)((Object)this.callbackState) + ", attachments=" + this.attachments + ", custom1=" + this.custom1 + ", custom2=" + this.custom2 + ", custom3=" + this.custom3 + ", custom4=" + this.custom4 + ", custom5=" + this.custom5 + ", custom6=" + this.custom6 + ", custom7=" + this.custom7 + ", custom8=" + this.custom8 + ", custom9=" + this.custom9 + ", custom10=" + this.custom10 + ", custom11=" + this.custom11 + ", custom12=" + this.custom12 + ", custom13=" + this.custom13 + ", custom14=" + this.custom14 + ", custom15=" + this.custom15 + ", custom16=" + this.custom16 + "]";
    }

    public int hashCode() {
        Object[] myFields;
        int prime = 31;
        int result = 1;
        for (Object property : myFields = new Object[]{this.externalId, this.attachments, this.businessProcessId, this.claimed, this.classificationSummary, this.completed, this.created, this.creator, this.custom1, this.custom10, this.custom11, this.custom12, this.custom13, this.custom14, this.custom15, this.custom16, this.custom2, this.custom3, this.custom4, this.custom5, this.custom6, this.custom7, this.custom8, this.custom9, this.customAttributes, this.callbackInfo, this.callbackState, this.description, this.due, this.id, this.modified, this.name, this.note, this.owner, this.parentBusinessProcessId, this.planned, this.primaryObjRef, this.state, this.workbasketSummary}) {
            result = 31 * result + (property == null ? 0 : property.hashCode());
        }
        result = 31 * result + (this.isRead ? 1231 : 1237);
        result = 31 * result + (this.isTransferred ? 1231 : 1237);
        result = 31 * result + this.priority;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskImpl other = (TaskImpl)obj;
        Object[] myFields = new Object[]{this.externalId, this.attachments, this.businessProcessId, this.claimed, this.classificationSummary, this.completed, this.created, this.creator, this.custom1, this.custom10, this.custom11, this.custom12, this.custom13, this.custom14, this.custom15, this.custom16, this.custom2, this.custom3, this.custom4, this.custom5, this.custom6, this.custom7, this.custom8, this.custom9, this.customAttributes, this.callbackInfo, this.callbackState, this.description, this.due, this.id, this.modified, this.name, this.note, this.owner, this.parentBusinessProcessId, this.planned, this.primaryObjRef, this.state, this.workbasketSummary};
        Object[] otherFields = new Object[]{other.externalId, other.attachments, other.businessProcessId, other.claimed, other.classificationSummary, other.completed, other.created, other.creator, other.custom1, other.custom10, other.custom11, other.custom12, other.custom13, other.custom14, other.custom15, other.custom16, other.custom2, other.custom3, other.custom4, other.custom5, other.custom6, other.custom7, other.custom8, other.custom9, other.customAttributes, other.callbackInfo, other.callbackState, other.description, other.due, other.id, other.modified, other.name, other.note, other.owner, other.parentBusinessProcessId, other.planned, other.primaryObjRef, other.state, other.workbasketSummary};
        if (myFields.length != otherFields.length) {
            throw new SystemException("TaskSummaryImpl: length mismatch between internal arrays");
        }
        for (int i = 0; i < myFields.length; ++i) {
            if ((myFields[i] != null || otherFields[i] == null) && (myFields[i] == null || myFields[i].equals(otherFields[i]))) continue;
            return false;
        }
        if (this.isRead != other.isRead) {
            return false;
        }
        if (this.isTransferred != other.isTransferred) {
            return false;
        }
        return this.priority == other.priority;
    }
}

