/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.session.SqlSessionManager;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.transaction.jdbc.JdbcTransactionFactory;
import org.apache.ibatis.transaction.managed.ManagedTransactionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.ClassificationService;
import pro.taskana.JobService;
import pro.taskana.TaskMonitorService;
import pro.taskana.TaskService;
import pro.taskana.TaskanaEngine;
import pro.taskana.TaskanaRole;
import pro.taskana.WorkbasketService;
import pro.taskana.configuration.TaskanaEngineConfiguration;
import pro.taskana.exceptions.AutocommitFailedException;
import pro.taskana.exceptions.ConnectionNotSetException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.exceptions.SystemException;
import pro.taskana.exceptions.UnsupportedDatabaseException;
import pro.taskana.history.HistoryEventProducer;
import pro.taskana.impl.ClassificationServiceImpl;
import pro.taskana.impl.InternalTaskanaEngine;
import pro.taskana.impl.JobServiceImpl;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.impl.WorkbasketServiceImpl;
import pro.taskana.impl.persistence.MapTypeHandler;
import pro.taskana.impl.util.LoggerUtils;
import pro.taskana.mappings.AttachmentMapper;
import pro.taskana.mappings.ClassificationMapper;
import pro.taskana.mappings.DistributionTargetMapper;
import pro.taskana.mappings.JobMapper;
import pro.taskana.mappings.ObjectReferenceMapper;
import pro.taskana.mappings.QueryMapper;
import pro.taskana.mappings.TaskMapper;
import pro.taskana.mappings.TaskMonitorMapper;
import pro.taskana.mappings.WorkbasketAccessMapper;
import pro.taskana.mappings.WorkbasketMapper;
import pro.taskana.security.CurrentUserContext;

public class TaskanaEngineImpl
implements TaskanaEngine {
    private static final String DEFAULT = "default";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskanaEngineImpl.class);
    private static ThreadLocal<Deque<SqlSessionManager>> sessionStack = new ThreadLocal();
    protected TaskanaEngineConfiguration taskanaEngineConfiguration;
    protected TransactionFactory transactionFactory;
    protected SqlSessionManager sessionManager;
    protected TaskanaEngine.ConnectionManagementMode mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
    protected Connection connection = null;
    private HistoryEventProducer historyEventProducer;
    private InternalTaskanaEngineImpl internalTaskanaEngineImpl;

    protected TaskanaEngineImpl(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        this.taskanaEngineConfiguration = taskanaEngineConfiguration;
        this.createTransactionFactory(taskanaEngineConfiguration.getUseManagedTransactions());
        this.sessionManager = this.createSqlSessionManager();
        this.historyEventProducer = HistoryEventProducer.getInstance(taskanaEngineConfiguration);
        this.internalTaskanaEngineImpl = new InternalTaskanaEngineImpl();
    }

    public static TaskanaEngine createTaskanaEngine(TaskanaEngineConfiguration taskanaEngineConfiguration) {
        return new TaskanaEngineImpl(taskanaEngineConfiguration);
    }

    private static Deque<SqlSessionManager> getSessionStack() {
        Deque<SqlSessionManager> stack = sessionStack.get();
        if (stack == null) {
            stack = new ArrayDeque<SqlSessionManager>();
            sessionStack.set(stack);
        }
        return stack;
    }

    private static SqlSessionManager getSessionFromStack() {
        Deque<SqlSessionManager> stack = TaskanaEngineImpl.getSessionStack();
        if (stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    private static void pushSessionToStack(SqlSessionManager session) {
        TaskanaEngineImpl.getSessionStack().push(session);
    }

    private static void popSessionFromStack() {
        Deque<SqlSessionManager> stack = TaskanaEngineImpl.getSessionStack();
        if (!stack.isEmpty()) {
            stack.pop();
        }
    }

    public static boolean isDb2(String dbProductName) {
        return dbProductName.contains("DB2");
    }

    public static boolean isH2(String databaseProductName) {
        return databaseProductName.contains("H2");
    }

    public static boolean isPostgreSQL(String databaseProductName) {
        return "PostgreSQL".equals(databaseProductName);
    }

    @Override
    public TaskService getTaskService() {
        SqlSessionManager session = this.sessionManager;
        return new TaskServiceImpl(this.internalTaskanaEngineImpl, (TaskMapper)session.getMapper(TaskMapper.class), (AttachmentMapper)session.getMapper(AttachmentMapper.class));
    }

    @Override
    public TaskMonitorService getTaskMonitorService() {
        SqlSessionManager session = this.sessionManager;
        return new TaskMonitorServiceImpl(this.internalTaskanaEngineImpl, (TaskMonitorMapper)session.getMapper(TaskMonitorMapper.class));
    }

    @Override
    public WorkbasketService getWorkbasketService() {
        SqlSessionManager session = this.sessionManager;
        return new WorkbasketServiceImpl(this.internalTaskanaEngineImpl, (WorkbasketMapper)session.getMapper(WorkbasketMapper.class), (DistributionTargetMapper)session.getMapper(DistributionTargetMapper.class), (WorkbasketAccessMapper)session.getMapper(WorkbasketAccessMapper.class));
    }

    @Override
    public ClassificationService getClassificationService() {
        SqlSessionManager session = this.sessionManager;
        return new ClassificationServiceImpl(this.internalTaskanaEngineImpl, (ClassificationMapper)session.getMapper(ClassificationMapper.class), (TaskMapper)session.getMapper(TaskMapper.class));
    }

    @Override
    public JobService getJobService() {
        SqlSessionManager session = this.sessionManager;
        return new JobServiceImpl(this.internalTaskanaEngineImpl, (JobMapper)session.getMapper(JobMapper.class));
    }

    @Override
    public TaskanaEngineConfiguration getConfiguration() {
        return this.taskanaEngineConfiguration;
    }

    @Override
    public boolean isHistoryEnabled() {
        return HistoryEventProducer.isHistoryEnabled();
    }

    @Override
    public void setConnectionManagementMode(TaskanaEngine.ConnectionManagementMode mode) {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && this.connection != null && mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.connection = null;
        }
        this.mode = mode;
    }

    @Override
    public void setConnection(Connection connection) throws SQLException {
        if (connection != null) {
            this.connection = connection;
            connection.setAutoCommit(false);
            connection.setSchema(this.taskanaEngineConfiguration.getSchemaName());
            this.mode = TaskanaEngine.ConnectionManagementMode.EXPLICIT;
            this.sessionManager.startManagedSession(connection);
        } else if (this.connection != null) {
            this.closeConnection();
        }
    }

    @Override
    public void closeConnection() {
        if (this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
            this.connection = null;
            if (this.sessionManager.isManagedSessionStarted()) {
                this.sessionManager.close();
            }
            this.mode = TaskanaEngine.ConnectionManagementMode.PARTICIPATE;
        }
    }

    @Override
    public void checkRoleMembership(TaskanaRole ... roles) throws NotAuthorizedException {
        if (!this.isUserInRole(roles)) {
            if (LOGGER.isDebugEnabled()) {
                String accessIds = LoggerUtils.listToString(CurrentUserContext.getAccessIds());
                String rolesAsString = Arrays.toString((Object[])roles);
                LOGGER.debug("Throwing NotAuthorizedException because accessIds {} are not member of roles {}", (Object)accessIds, (Object)rolesAsString);
            }
            throw new NotAuthorizedException("current user is not member of role(s) " + Arrays.toString((Object[])roles));
        }
    }

    @Override
    public boolean isUserInRole(TaskanaRole ... roles) {
        if (!this.getConfiguration().isSecurityEnabled()) {
            return true;
        }
        List<String> accessIds = CurrentUserContext.getAccessIds();
        HashSet rolesMembers = new HashSet();
        for (TaskanaRole role : roles) {
            rolesMembers.addAll(this.getConfiguration().getRoleMap().get((Object)role));
        }
        for (String accessId : accessIds) {
            if (!rolesMembers.contains(accessId)) continue;
            return true;
        }
        return false;
    }

    protected SqlSessionManager createSqlSessionManager() {
        Configuration configuration;
        block17: {
            Environment environment = new Environment(DEFAULT, this.transactionFactory, this.taskanaEngineConfiguration.getDatasource());
            configuration = new Configuration(environment);
            try (Connection con = this.taskanaEngineConfiguration.getDatasource().getConnection();){
                String databaseProductName = con.getMetaData().getDatabaseProductName();
                if (TaskanaEngineImpl.isDb2(databaseProductName)) {
                    configuration.setDatabaseId("db2");
                    break block17;
                }
                if (TaskanaEngineImpl.isH2(databaseProductName)) {
                    configuration.setDatabaseId("h2");
                    break block17;
                }
                if (TaskanaEngineImpl.isPostgreSQL(databaseProductName)) {
                    configuration.setDatabaseId("postgres");
                    break block17;
                }
                throw new UnsupportedDatabaseException(databaseProductName);
            }
            catch (SQLException e) {
                throw new SystemException("Method createSqlSessionManager() could not open a connection to the database. No databaseId has been set.", e.getCause());
            }
        }
        configuration.addMapper(TaskMapper.class);
        configuration.addMapper(TaskMonitorMapper.class);
        configuration.addMapper(WorkbasketMapper.class);
        configuration.addMapper(DistributionTargetMapper.class);
        configuration.addMapper(ClassificationMapper.class);
        configuration.addMapper(WorkbasketAccessMapper.class);
        configuration.addMapper(ObjectReferenceMapper.class);
        configuration.addMapper(QueryMapper.class);
        configuration.addMapper(AttachmentMapper.class);
        configuration.addMapper(JobMapper.class);
        configuration.getTypeHandlerRegistry().register(MapTypeHandler.class);
        SqlSessionFactory localSessionFactory = new SqlSessionFactoryBuilder().build(configuration);
        return SqlSessionManager.newInstance((SqlSessionFactory)localSessionFactory);
    }

    private void createTransactionFactory(boolean useManagedTransactions) {
        this.transactionFactory = useManagedTransactions ? new ManagedTransactionFactory() : new JdbcTransactionFactory();
    }

    private class InternalTaskanaEngineImpl
    implements InternalTaskanaEngine {
        private InternalTaskanaEngineImpl() {
        }

        @Override
        public void openConnection() {
            this.initSqlSession();
            try {
                TaskanaEngineImpl.this.sessionManager.getConnection().setSchema(TaskanaEngineImpl.this.taskanaEngineConfiguration.getSchemaName());
            }
            catch (SQLException e) {
                throw new SystemException("Method openConnection() could not open a connection to the database. No schema has been created.", e.getCause());
            }
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
                TaskanaEngineImpl.pushSessionToStack(TaskanaEngineImpl.this.sessionManager);
            }
        }

        @Override
        public void initSqlSession() {
            if (TaskanaEngineImpl.this.mode == TaskanaEngine.ConnectionManagementMode.EXPLICIT && TaskanaEngineImpl.this.connection == null) {
                throw new ConnectionNotSetException();
            }
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT && !TaskanaEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                TaskanaEngineImpl.this.sessionManager.startManagedSession();
            }
        }

        @Override
        public void returnConnection() {
            if (TaskanaEngineImpl.this.mode != TaskanaEngine.ConnectionManagementMode.EXPLICIT) {
                TaskanaEngineImpl.popSessionFromStack();
                if (TaskanaEngineImpl.getSessionStack().isEmpty() && TaskanaEngineImpl.this.sessionManager != null && TaskanaEngineImpl.this.sessionManager.isManagedSessionStarted()) {
                    if (TaskanaEngineImpl.this.mode == TaskanaEngine.ConnectionManagementMode.AUTOCOMMIT) {
                        try {
                            TaskanaEngineImpl.this.sessionManager.commit();
                        }
                        catch (Exception e) {
                            throw new AutocommitFailedException(e.getCause());
                        }
                    }
                    TaskanaEngineImpl.this.sessionManager.close();
                }
            }
        }

        @Override
        public <T> T openAndReturnConnection(Supplier<T> supplier) {
            try {
                this.openConnection();
                T t = supplier.get();
                return t;
            }
            finally {
                this.returnConnection();
            }
        }

        @Override
        public boolean domainExists(String domain) {
            return TaskanaEngineImpl.this.getConfiguration().getDomains().contains(domain);
        }

        @Override
        public SqlSession getSqlSession() {
            return TaskanaEngineImpl.this.sessionManager;
        }

        @Override
        public TaskanaEngine getEngine() {
            return TaskanaEngineImpl.this;
        }

        @Override
        public HistoryEventProducer getHistoryEventProducer() {
            return TaskanaEngineImpl.this.historyEventProducer;
        }
    }
}

