/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskState;
import pro.taskana.TaskanaRole;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.InternalTaskanaEngine;
import pro.taskana.impl.SelectedItem;
import pro.taskana.impl.TimeIntervalReportBuilderImpl;
import pro.taskana.impl.report.header.TimeIntervalColumnHeader;
import pro.taskana.impl.report.item.TimestampQueryItem;
import pro.taskana.impl.report.preprocessor.DaysToWorkingDaysPreProcessor;
import pro.taskana.mappings.TaskMonitorMapper;
import pro.taskana.report.Timestamp;
import pro.taskana.report.TimestampReport;

public class TimestampReportBuilderImpl
extends TimeIntervalReportBuilderImpl<TimestampReport.Builder, TimestampQueryItem, TimeIntervalColumnHeader>
implements TimestampReport.Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimestampReport.Builder.class);
    private List<Timestamp> status = Arrays.asList(Timestamp.CREATED, Timestamp.COMPLETED);

    TimestampReportBuilderImpl(InternalTaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        super(taskanaEngine, taskMonitorMapper);
    }

    @Override
    public TimestampReport.Builder stateIn(List<TaskState> states) {
        throw new UnsupportedOperationException("The states have no influence regarding this report. Use withTimestamps instead");
    }

    @Override
    protected TimestampReport.Builder _this() {
        return this;
    }

    @Override
    public List<String> listTaskIdsForSelectedItems(List<SelectedItem> selectedItems) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String determineGroupedBy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TimestampReport.Builder withTimestamps(List<Timestamp> statuses) {
        this.status = new ArrayList<Timestamp>(statuses);
        return this._this();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimestampReport buildReport() throws NotAuthorizedException, InvalidArgumentException {
        LOGGER.debug("entry to buildDetailedReport(), this = {}", (Object)this);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            TimestampReport report = new TimestampReport(this.columnHeaders);
            List items = this.status.stream().map(this::getTasksCountForStatusGroupedByOrgLevel).flatMap(Collection::stream).collect(Collectors.toList());
            report.addItems(items, new DaysToWorkingDaysPreProcessor(this.columnHeaders, this.inWorkingDays));
            TimestampReport timestampReport = report;
            return timestampReport;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from buildDetailedReport().");
        }
    }

    private List<TimestampQueryItem> getTasksCountForStatusGroupedByOrgLevel(Timestamp s) {
        return this.taskMonitorMapper.getTasksCountForStatusGroupedByOrgLevel(s, this.categories, this.classificationIds, this.excludedClassificationIds, this.domains, this.customAttributeFilter);
    }
}

