/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report.row;

import pro.taskana.impl.report.structure.QueryItem;
import pro.taskana.impl.report.structure.Row;

public class SingleRow<I extends QueryItem>
implements Row<I> {
    private final int[] cells;
    private int total = 0;

    public SingleRow(int columnCount) {
        this.cells = new int[columnCount];
    }

    @Override
    public void addItem(I item, int index) throws IndexOutOfBoundsException {
        this.total += item.getValue();
        int n = index;
        this.cells[n] = this.cells[n] + item.getValue();
    }

    @Override
    public void updateTotalValue(I item) {
        this.total += item.getValue();
    }

    @Override
    public final int getTotalValue() {
        return this.total;
    }

    @Override
    public final int[] getCells() {
        return (int[])this.cells.clone();
    }
}

