/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.configuration;

import pro.taskana.exceptions.UnsupportedDatabaseException;

public enum DB {
    H2("H2", "h2"),
    DB2("DB2", "db2"),
    POSTGRESS("PostgreSQL", "postgres");

    public final String dbProductname;
    public final String dbProductId;

    private DB(String dbProductname, String dbProductId) {
        this.dbProductname = dbProductname;
        this.dbProductId = dbProductId;
    }

    public static boolean isDb2(String dbProductName) {
        return dbProductName != null && dbProductName.contains(DB.DB2.dbProductname);
    }

    public static boolean isH2(String dbProductName) {
        return dbProductName != null && dbProductName.contains(DB.H2.dbProductname);
    }

    public static boolean isPostgreSql(String dbProductName) {
        return DB.POSTGRESS.dbProductname.equals(dbProductName);
    }

    public static String getDatabaseProductId(String dbProductName) {
        if (DB.isDb2(dbProductName)) {
            return DB.DB2.dbProductId;
        }
        if (DB.isH2(dbProductName)) {
            return DB.H2.dbProductId;
        }
        if (DB.isPostgreSql(dbProductName)) {
            return DB.POSTGRESS.dbProductId;
        }
        throw new UnsupportedDatabaseException(dbProductName);
    }
}

