/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.exceptions.InvalidArgumentException;
import pro.taskana.impl.TaskMonitorServiceImpl;
import pro.taskana.impl.report.header.TimeIntervalColumnHeader;
import pro.taskana.impl.util.LoggerUtils;

public final class DaysToWorkingDaysConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMonitorServiceImpl.class);
    private static boolean germanHolidaysEnabled;
    private static Set<LocalDate> customHolidays;
    private List<Integer> positiveDaysToWorkingDays;
    private List<Integer> negativeDaysToWorkingDays;
    private Instant dateCreated;
    private LocalDate easterSunday;

    private DaysToWorkingDaysConverter(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        this.easterSunday = DaysToWorkingDaysConverter.getEasterSunday(LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).getYear());
        this.dateCreated = referenceDate;
        this.positiveDaysToWorkingDays = this.generatePositiveDaysToWorkingDays(columnHeaders, referenceDate);
        this.negativeDaysToWorkingDays = this.generateNegativeDaysToWorkingDays(columnHeaders, referenceDate);
    }

    public static DaysToWorkingDaysConverter initialize() throws InvalidArgumentException {
        return DaysToWorkingDaysConverter.initialize(Collections.singletonList(new TimeIntervalColumnHeader(0)), Instant.now());
    }

    public static DaysToWorkingDaysConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders) throws InvalidArgumentException {
        return DaysToWorkingDaysConverter.initialize(columnHeaders, Instant.now());
    }

    public static DaysToWorkingDaysConverter initialize(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) throws InvalidArgumentException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Initialize DaysToWorkingDaysConverter with columnHeaders: {}", (Object)LoggerUtils.listToString(columnHeaders));
        }
        if (columnHeaders == null) {
            throw new InvalidArgumentException("TimeIntervalColumnHeaders can\u00b4t be used as NULL-Parameter");
        }
        if (referenceDate == null) {
            throw new InvalidArgumentException("ReferenceDate can\u00b4t be used as NULL-Parameter");
        }
        return new DaysToWorkingDaysConverter(columnHeaders, referenceDate);
    }

    public static void setGermanPublicHolidaysEnabled(boolean germanPublicHolidaysEnabled) {
        germanHolidaysEnabled = germanPublicHolidaysEnabled;
    }

    public static void setCustomHolidays(List<LocalDate> holidays) {
        customHolidays = new HashSet(holidays == null ? Collections.emptyList() : holidays);
    }

    public int convertDaysToWorkingDays(int ageInDays) {
        int minDay = -(this.negativeDaysToWorkingDays.size() - 1);
        int maxDay = this.positiveDaysToWorkingDays.size() - 1;
        if (ageInDays >= minDay && ageInDays <= 0) {
            return this.negativeDaysToWorkingDays.get(-ageInDays);
        }
        if (ageInDays > 0 && ageInDays <= maxDay) {
            return this.positiveDaysToWorkingDays.get(ageInDays);
        }
        return ageInDays;
    }

    public ArrayList<Integer> convertWorkingDaysToDays(int ageInWorkingDays) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int minWorkingDay = this.negativeDaysToWorkingDays.get(this.negativeDaysToWorkingDays.size() - 1);
        int maxWorkingDay = this.positiveDaysToWorkingDays.get(this.positiveDaysToWorkingDays.size() - 1);
        if (ageInWorkingDays >= minWorkingDay && ageInWorkingDays < 0) {
            for (int ageInDays = 0; ageInDays < this.negativeDaysToWorkingDays.size(); ++ageInDays) {
                if (this.negativeDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(-ageInDays);
            }
            return list;
        }
        if (ageInWorkingDays > 0 && ageInWorkingDays <= maxWorkingDay) {
            for (int ageInDays = 0; ageInDays < this.positiveDaysToWorkingDays.size(); ++ageInDays) {
                if (this.positiveDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(ageInDays);
            }
            return list;
        }
        if (ageInWorkingDays == 0) {
            int ageInDays;
            list.add(0);
            for (ageInDays = 1; ageInDays < this.positiveDaysToWorkingDays.size(); ++ageInDays) {
                if (this.positiveDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(ageInDays);
            }
            for (ageInDays = 1; ageInDays < this.negativeDaysToWorkingDays.size(); ++ageInDays) {
                if (this.negativeDaysToWorkingDays.get(ageInDays) != ageInWorkingDays) continue;
                list.add(-ageInDays);
            }
            return list;
        }
        list.add(ageInWorkingDays);
        return list;
    }

    public long convertWorkingDaysToDays(Instant startTime, long numberOfDays) {
        int direction = numberOfDays >= 0L ? 1 : -1;
        long limit = Math.abs(numberOfDays);
        return LongStream.iterate(0L, i -> i + (long)direction).filter(day -> this.isWorkingDay(day, startTime)).skip(limit).findFirst().orElse(0L);
    }

    static LocalDate getEasterSunday(int year) {
        int a = year % 19;
        int b = year % 4;
        int c = year % 7;
        int k = year / 100;
        int p = (13 + 8 * k) / 25;
        int q = k / 4;
        int m = (15 - p + k - q) % 30;
        int n = (4 + k - q) % 7;
        int d = (19 * a + m) % 30;
        int e = (2 * b + 4 * c + 6 * d + n) % 7;
        if (d == 29 && e == 6) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        if (d == 28 && e == 6 && (11 * m + 11) % 30 < 19) {
            return LocalDate.of(year, 3, 15).plusDays(d + e);
        }
        return LocalDate.of(year, 3, 22).plusDays(d + e);
    }

    private List<Integer> generateNegativeDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        int minUpperLimit = TimeIntervalColumnHeader.getSmallestUpperLimit(columnHeaders);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = -1;
        int workingDay = 0;
        while (workingDay > minUpperLimit) {
            daysToWorkingDays.add(workingDay -= this.isWorkingDay(day--, referenceDate) ? 1 : 0);
        }
        return daysToWorkingDays;
    }

    private List<Integer> generatePositiveDaysToWorkingDays(List<? extends TimeIntervalColumnHeader> columnHeaders, Instant referenceDate) {
        int maxLowerLimit = TimeIntervalColumnHeader.getLargestLowerLimit(columnHeaders);
        ArrayList<Integer> daysToWorkingDays = new ArrayList<Integer>();
        daysToWorkingDays.add(0);
        int day = 1;
        int workingDay = 0;
        while (workingDay < maxLowerLimit) {
            daysToWorkingDays.add(workingDay += this.isWorkingDay(day++, referenceDate) ? 1 : 0);
        }
        return daysToWorkingDays;
    }

    private boolean isWorkingDay(long day, Instant referenceDate) {
        LocalDateTime dateToCheck = LocalDateTime.ofInstant(referenceDate, ZoneId.systemDefault()).plusDays(day);
        return !this.isWeekend(dateToCheck) && !this.isHoliday(dateToCheck.toLocalDate());
    }

    private boolean isWeekend(LocalDateTime dateToCheck) {
        return dateToCheck.getDayOfWeek().equals(DayOfWeek.SATURDAY) || dateToCheck.getDayOfWeek().equals(DayOfWeek.SUNDAY);
    }

    private boolean isHoliday(LocalDate date) {
        if (germanHolidaysEnabled && this.isGermanHoliday(date)) {
            return true;
        }
        return customHolidays.contains(date);
    }

    private boolean isGermanHoliday(LocalDate date) {
        if (Stream.of(GermanFixHolidays.values()).anyMatch(day -> day.matches(date))) {
            return true;
        }
        long diffFromEasterSunday = ChronoUnit.DAYS.between(this.easterSunday, date);
        long goodFriday = -2L;
        long easterMonday = 1L;
        long ascensionDay = 39L;
        long whitMonday = 50L;
        return LongStream.of(goodFriday, easterMonday, ascensionDay, whitMonday).anyMatch(diff -> diff == diffFromEasterSunday);
    }

    public String toString() {
        return "DaysToWorkingDaysConverter{positiveDaysToWorkingDays=" + this.positiveDaysToWorkingDays + ", negativeDaysToWorkingDays=" + this.negativeDaysToWorkingDays + ", dateCreated=" + this.dateCreated + ", easterSunday=" + this.easterSunday + '}';
    }

    static {
        customHolidays = new HashSet<LocalDate>();
    }

    private static enum GermanFixHolidays {
        NEWYEAR(1, 1),
        LABOURDAY(5, 1),
        GERMANUNITY(10, 3),
        CHRISTMAS1(12, 25),
        CHRISTMAS2(12, 26);

        private int month;
        private int day;

        private GermanFixHolidays(int month, int day) {
            this.month = month;
            this.day = day;
        }

        public boolean matches(LocalDate date) {
            return date.getDayOfMonth() == this.day && date.getMonthValue() == this.month;
        }
    }
}

