/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskState;
import pro.taskana.TaskanaRole;
import pro.taskana.exceptions.NotAuthorizedException;
import pro.taskana.impl.InternalTaskanaEngine;
import pro.taskana.impl.report.item.TaskQueryItem;
import pro.taskana.mappings.TaskMonitorMapper;
import pro.taskana.report.TaskStatusReport;

public class TaskStatusReportBuilderImpl
implements TaskStatusReport.Builder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskStatusReportBuilderImpl.class);
    private InternalTaskanaEngine taskanaEngine;
    private TaskMonitorMapper taskMonitorMapper;
    private List<String> domains;
    private List<TaskState> states;

    TaskStatusReportBuilderImpl(InternalTaskanaEngine taskanaEngine, TaskMonitorMapper taskMonitorMapper) {
        this.taskanaEngine = taskanaEngine;
        this.taskMonitorMapper = taskMonitorMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatusReport buildReport() throws NotAuthorizedException {
        LOGGER.debug("entry to buildReport(), this = {}", (Object)this);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.MONITOR, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            List<TaskQueryItem> tasks = this.taskMonitorMapper.getTasksCountByState(this.domains, this.states);
            TaskStatusReport report = new TaskStatusReport(this.states);
            report.addItems(tasks);
            TaskStatusReport taskStatusReport = report;
            return taskStatusReport;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from buildReport().");
        }
    }

    @Override
    public TaskStatusReportBuilderImpl stateIn(List<TaskState> states) {
        this.states = states;
        return this;
    }

    @Override
    public TaskStatusReportBuilderImpl domainIn(List<String> domains) {
        this.domains = domains;
        return this;
    }
}

