/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report.header;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import pro.taskana.impl.report.item.AgeQueryItem;
import pro.taskana.impl.report.structure.ColumnHeader;

public class TimeIntervalColumnHeader
implements ColumnHeader<AgeQueryItem> {
    private final int lowerAgeLimit;
    private final int upperAgeLimit;

    public TimeIntervalColumnHeader(int ageInDays) {
        this.lowerAgeLimit = ageInDays;
        this.upperAgeLimit = ageInDays;
    }

    public TimeIntervalColumnHeader(int lowerAgeLimit, int upperAgeLimit) {
        this.lowerAgeLimit = lowerAgeLimit;
        this.upperAgeLimit = upperAgeLimit;
    }

    public static int getSmallestUpperLimit(List<? extends TimeIntervalColumnHeader> columnHeaders) {
        return columnHeaders.stream().mapToInt(TimeIntervalColumnHeader::getUpperAgeLimit).filter(i -> i < 0).min().orElse(0);
    }

    public static int getLargestLowerLimit(List<? extends TimeIntervalColumnHeader> columnHeaders) {
        int greatestLowerLimit = 0;
        for (TimeIntervalColumnHeader timeIntervalColumnHeader : columnHeaders) {
            if (timeIntervalColumnHeader.getUpperAgeLimit() <= greatestLowerLimit) continue;
            greatestLowerLimit = timeIntervalColumnHeader.getLowerAgeLimit();
        }
        return greatestLowerLimit;
    }

    public int getLowerAgeLimit() {
        return this.lowerAgeLimit;
    }

    public int getUpperAgeLimit() {
        return this.upperAgeLimit;
    }

    @Override
    public String getDisplayName() {
        return "(" + this.lowerAgeLimit + "," + this.upperAgeLimit + ")";
    }

    @Override
    public boolean fits(AgeQueryItem item) {
        return this.lowerAgeLimit <= item.getAgeInDays() && this.upperAgeLimit >= item.getAgeInDays();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static class Range
    extends TimeIntervalColumnHeader {
        public Range(int ageInDays) {
            super(ageInDays);
        }

        public Range(int lowerAgeLimit, int upperAgeLimit) {
            super(lowerAgeLimit, upperAgeLimit);
        }

        @Override
        public String getDisplayName() {
            if (this.getLowerAgeLimit() == Integer.MIN_VALUE) {
                return "<" + this.getUpperAgeLimit();
            }
            if (this.getUpperAgeLimit() == Integer.MAX_VALUE) {
                return ">" + this.getLowerAgeLimit();
            }
            if (this.getLowerAgeLimit() == -1) {
                return "-1 day";
            }
            if (this.getLowerAgeLimit() == 1) {
                return "+1 day";
            }
            if (this.getLowerAgeLimit() == 0) {
                return "today";
            }
            if (this.getLowerAgeLimit() == this.getUpperAgeLimit()) {
                return this.getUpperAgeLimit() + "";
            }
            if (this.getLowerAgeLimit() != this.getUpperAgeLimit()) {
                return "[" + this.getLowerAgeLimit() + " ... " + this.getUpperAgeLimit() + "]";
            }
            return super.getDisplayName();
        }
    }

    public static class Date
    extends TimeIntervalColumnHeader {
        public Date(int ageInDays) {
            super(ageInDays);
        }

        @Override
        public String getDisplayName() {
            LocalDateTime ldt = LocalDateTime.now().plusDays(this.getLowerAgeLimit());
            DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
            return dateFormat.format(ldt);
        }
    }
}

