/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.impl.report.row;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import pro.taskana.impl.report.row.SingleRow;
import pro.taskana.impl.report.structure.QueryItem;
import pro.taskana.impl.report.structure.Row;
import pro.taskana.impl.util.LoggerUtils;

public abstract class FoldableRow<I extends QueryItem>
extends SingleRow<I> {
    private Map<String, Row<I>> foldableRows = new LinkedHashMap<String, Row<I>>();
    private Function<? super I, String> calcFoldableRowKey;
    private int columnSize;

    protected FoldableRow(int columnSize, Function<? super I, String> calcFoldableRowKey) {
        super(columnSize);
        this.columnSize = columnSize;
        this.calcFoldableRowKey = calcFoldableRowKey;
    }

    public final int getFoldableRowCount() {
        return this.foldableRows.size();
    }

    public final Set<String> getFoldableRowKeySet() {
        return this.foldableRows.keySet();
    }

    @Override
    public void addItem(I item, int index) throws IndexOutOfBoundsException {
        super.addItem(item, index);
        this.foldableRows.computeIfAbsent(this.calcFoldableRowKey.apply(item), s -> this.buildRow(this.columnSize)).addItem(item, index);
    }

    @Override
    public void updateTotalValue(I item) {
        super.updateTotalValue(item);
        this.foldableRows.computeIfAbsent(this.calcFoldableRowKey.apply(item), s -> this.buildRow(this.columnSize)).updateTotalValue(item);
    }

    public Row<I> getFoldableRow(String key) {
        return this.foldableRows.get(key);
    }

    abstract Row<I> buildRow(int var1);

    public String toString() {
        return String.format("FoldableRow [detailRows= %s, columnSize= %d]", LoggerUtils.mapToString(this.foldableRows), this.columnSize);
    }
}

