/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.jobs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.TaskanaEngine;
import pro.taskana.exceptions.TaskanaException;
import pro.taskana.impl.TaskServiceImpl;
import pro.taskana.jobs.AbstractTaskanaJob;
import pro.taskana.jobs.ScheduledJob;
import pro.taskana.transaction.TaskanaTransactionProvider;

public class ClassificationChangedJob
extends AbstractTaskanaJob {
    public static final String TASK_IDS = "taskIds";
    public static final String CLASSIFICATION_ID = "classificationId";
    public static final String PRIORITY_CHANGED = "priorityChanged";
    public static final String SERVICE_LEVEL_CHANGED = "serviceLevelChanged";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationChangedJob.class);
    private String classificationId;
    private boolean priorityChanged;
    private boolean serviceLevelChanged;

    public ClassificationChangedJob(TaskanaEngine engine, TaskanaTransactionProvider<Object> txProvider, ScheduledJob job) {
        super(engine, txProvider, job);
        Map<String, String> args = job.getArguments();
        this.classificationId = args.get(CLASSIFICATION_ID);
        this.priorityChanged = Boolean.parseBoolean(args.get(PRIORITY_CHANGED));
        this.serviceLevelChanged = Boolean.parseBoolean(args.get(SERVICE_LEVEL_CHANGED));
    }

    @Override
    public void run() throws TaskanaException {
        LOGGER.info("Running ClassificationChangedJob for classification ({})", (Object)this.classificationId);
        try {
            TaskServiceImpl taskService = (TaskServiceImpl)this.taskanaEngineImpl.getTaskService();
            Set<String> affectedTaskIds = taskService.findTasksIdsAffectedByClassificationChange(this.classificationId);
            this.scheduleTaskRefreshJobs(affectedTaskIds);
            LOGGER.info("ClassificationChangedJob ended successfully.");
        }
        catch (Exception e) {
            throw new TaskanaException("Error while processing ClassificationChangedJob.", e);
        }
    }

    private void scheduleTaskRefreshJobs(Set<String> affectedTaskIds) {
        int batchSize = this.taskanaEngineImpl.getConfiguration().getMaxNumberOfUpdatesPerTransaction();
        List<List<String>> affectedTaskBatches = this.partition(affectedTaskIds, batchSize);
        LOGGER.debug("Creating {} TaskRefreshJobs out of {} affected tasks with a maximum number of {} tasks each. ", new Object[]{affectedTaskBatches.size(), affectedTaskIds.size(), batchSize});
        for (List<String> taskIdBatch : affectedTaskBatches) {
            HashMap<String, String> args = new HashMap<String, String>();
            if (taskIdBatch.isEmpty()) continue;
            String taskIds = String.join((CharSequence)",", affectedTaskIds);
            args.put(TASK_IDS, taskIds);
            args.put(PRIORITY_CHANGED, Boolean.valueOf(this.priorityChanged).toString());
            args.put(SERVICE_LEVEL_CHANGED, Boolean.valueOf(this.serviceLevelChanged).toString());
            ScheduledJob job = new ScheduledJob();
            job.setType(ScheduledJob.Type.UPDATETASKSJOB);
            job.setArguments(args);
            this.taskanaEngineImpl.getJobService().createJob(job);
        }
    }
}

