/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.taskrouting;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.Task;
import pro.taskana.TaskanaEngine;
import pro.taskana.taskrouting.api.TaskRoutingProvider;

public final class TaskRoutingManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskRoutingManager.class);
    private static TaskRoutingManager singleton;
    private static boolean enabled;
    private static List<TaskRoutingProvider> theTaskRoutingProviders;
    private ServiceLoader<TaskRoutingProvider> serviceLoader = ServiceLoader.load(TaskRoutingProvider.class);

    private TaskRoutingManager(TaskanaEngine taskanaEngine) {
        for (TaskRoutingProvider router : this.serviceLoader) {
            router.initialize(taskanaEngine);
            theTaskRoutingProviders.add(router);
            LOGGER.info("Registered TaskRouter provider: {}", (Object)router.getClass().getName());
        }
        if (theTaskRoutingProviders.isEmpty()) {
            LOGGER.info("No TaskRouter provider found. Running without Task Routing.");
        } else {
            enabled = true;
        }
    }

    public static synchronized TaskRoutingManager getInstance(TaskanaEngine taskanaEngine) {
        if (singleton == null) {
            singleton = new TaskRoutingManager(taskanaEngine);
        }
        return singleton;
    }

    public static boolean isTaskRoutingEnabled() {
        return enabled;
    }

    public String determineWorkbasketId(Task task) {
        LOGGER.debug("entry to routeToWorkbasket. TaskRouterr is enabled {}, task = {}", (Object)TaskRoutingManager.isTaskRoutingEnabled(), (Object)task);
        String workbasketId = null;
        if (TaskRoutingManager.isTaskRoutingEnabled()) {
            Set workbasketIds = theTaskRoutingProviders.stream().map(rtr -> rtr.determineWorkbasketId(task)).filter(Objects::nonNull).collect(Collectors.toSet());
            if (workbasketIds.isEmpty()) {
                LOGGER.error("No TaskRouter determined a workbasket for task {}.", (Object)task);
            } else if (workbasketIds.size() > 1) {
                LOGGER.error("The TaskRouters determined more than one workbasket for task {}", (Object)task);
            } else {
                workbasketId = workbasketIds.stream().findFirst().orElse(null);
            }
        }
        LOGGER.debug("exit from routeToWorkbasketId. Destination WorkbasketId = {}", workbasketId);
        return workbasketId;
    }

    static {
        enabled = false;
        theTaskRoutingProviders = new ArrayList<TaskRoutingProvider>();
    }
}

