/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.classification.internal;

import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.exceptions.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.classification.api.ClassificationQuery;
import pro.taskana.classification.api.ClassificationService;
import pro.taskana.classification.api.exceptions.ClassificationAlreadyExistException;
import pro.taskana.classification.api.exceptions.ClassificationInUseException;
import pro.taskana.classification.api.exceptions.ClassificationNotFoundException;
import pro.taskana.classification.api.models.Classification;
import pro.taskana.classification.api.models.ClassificationSummary;
import pro.taskana.classification.internal.ClassificationMapper;
import pro.taskana.classification.internal.ClassificationQueryImpl;
import pro.taskana.classification.internal.models.ClassificationImpl;
import pro.taskana.common.api.ScheduledJob;
import pro.taskana.common.api.TaskanaRole;
import pro.taskana.common.api.exceptions.ConcurrencyException;
import pro.taskana.common.api.exceptions.DomainNotFoundException;
import pro.taskana.common.api.exceptions.InvalidArgumentException;
import pro.taskana.common.api.exceptions.NotAuthorizedException;
import pro.taskana.common.internal.InternalTaskanaEngine;
import pro.taskana.common.internal.util.IdGenerator;
import pro.taskana.task.api.models.TaskSummary;
import pro.taskana.task.internal.TaskMapper;

public class ClassificationServiceImpl
implements ClassificationService {
    private static final String ID_PREFIX_CLASSIFICATION = "CLI";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassificationServiceImpl.class);
    private ClassificationMapper classificationMapper;
    private TaskMapper taskMapper;
    private InternalTaskanaEngine taskanaEngine;

    public ClassificationServiceImpl(InternalTaskanaEngine taskanaEngine, ClassificationMapper classificationMapper, TaskMapper taskMapper) {
        this.taskanaEngine = taskanaEngine;
        this.classificationMapper = classificationMapper;
        this.taskMapper = taskMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification getClassification(String key, String domain) throws ClassificationNotFoundException {
        LOGGER.debug("entry to getClassification(key = {}, domain = {})", (Object)key, (Object)domain);
        if (key == null) {
            throw new ClassificationNotFoundException(null, domain, "Classification for null key and domain " + domain + " was not found.");
        }
        ClassificationImpl result = null;
        try {
            this.taskanaEngine.openConnection();
            result = this.classificationMapper.findByKeyAndDomain(key, domain);
            if (result == null && (result = this.classificationMapper.findByKeyAndDomain(key, "")) == null) {
                throw new ClassificationNotFoundException(key, domain, "Classification for key = " + key + " and master domain was not found");
            }
            ClassificationImpl classificationImpl = result;
            return classificationImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getClassification(). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification getClassification(String id) throws ClassificationNotFoundException {
        if (id == null) {
            throw new ClassificationNotFoundException(null, "Classification for null id is invalid.");
        }
        LOGGER.debug("entry to getClassification(id = {})", (Object)id);
        ClassificationImpl result = null;
        try {
            this.taskanaEngine.openConnection();
            result = this.classificationMapper.findById(id);
            if (result == null) {
                throw new ClassificationNotFoundException(id, "Classification for id " + id + " was not found");
            }
            ClassificationImpl classificationImpl = result;
            return classificationImpl;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from getClassification(). Returning result {} ", (Object)result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClassification(String classificationId) throws ClassificationInUseException, ClassificationNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to deleteClassification(id = {})", (Object)classificationId);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationImpl classification = this.classificationMapper.findById(classificationId);
            if (classification == null) {
                throw new ClassificationNotFoundException(classificationId, "The classification \"" + classificationId + "\" wasn't found");
            }
            if (classification.getDomain().equals("")) {
                List classificationsInDomain = this.createClassificationQuery().keyIn(classification.getKey()).list();
                for (ClassificationSummary classificationInDomain : classificationsInDomain) {
                    if ("".equals(classificationInDomain.getDomain())) continue;
                    this.deleteClassification(classificationInDomain.getId());
                }
            }
            List childClassifications = this.createClassificationQuery().parentIdIn(classificationId).list();
            for (ClassificationSummary child : childClassifications) {
                this.deleteClassification(child.getId());
            }
            try {
                this.classificationMapper.deleteClassification(classificationId);
            }
            catch (PersistenceException e) {
                if (this.isReferentialIntegrityConstraintViolation(e)) {
                    throw new ClassificationInUseException(String.format("The classification id = \"%s\" and key = \"%s\" in domain = \"%s\" is in use and cannot be deleted. There are either tasks or attachments associated with the classification.", classificationId, classification.getKey(), classification.getDomain()), e.getCause());
                }
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteClassification()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClassification(String classificationKey, String domain) throws ClassificationInUseException, ClassificationNotFoundException, NotAuthorizedException {
        LOGGER.debug("entry to deleteClassification(key = {}, domain = {})", (Object)classificationKey, (Object)domain);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        try {
            this.taskanaEngine.openConnection();
            ClassificationImpl classification = this.classificationMapper.findByKeyAndDomain(classificationKey, domain);
            if (classification == null) {
                throw new ClassificationNotFoundException(classificationKey, domain, "The classification \"" + classificationKey + "\" wasn't found in the domain " + domain);
            }
            this.deleteClassification(classification.getId());
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from deleteClassification(key,domain)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification createClassification(Classification classification) throws ClassificationAlreadyExistException, NotAuthorizedException, DomainNotFoundException, InvalidArgumentException {
        ClassificationImpl classificationImpl;
        LOGGER.debug("entry to createClassification(classification = {})", (Object)classification);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        if (!this.taskanaEngine.domainExists(classification.getDomain()) && !"".equals(classification.getDomain())) {
            throw new DomainNotFoundException(classification.getDomain(), "Domain " + classification.getDomain() + " does not exist in the configuration.");
        }
        try {
            this.taskanaEngine.openConnection();
            boolean isClassificationExisting = this.doesClassificationExist(classification.getKey(), classification.getDomain());
            if (isClassificationExisting) {
                throw new ClassificationAlreadyExistException(classification);
            }
            classificationImpl = (ClassificationImpl)classification;
            this.checkClassificationId(classificationImpl);
            classificationImpl.setCreated(Instant.now());
            classificationImpl.setModified(classificationImpl.getCreated());
            this.initDefaultClassificationValues(classificationImpl);
            this.validateAndPopulateParentInformation(classificationImpl);
            this.classificationMapper.insert(classificationImpl);
            LOGGER.debug("Method createClassification created classification {}.", (Object)classificationImpl);
            if (!classification.getDomain().isEmpty()) {
                this.addClassificationToMasterDomain(classificationImpl);
            }
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from createClassification()");
        }
        return classificationImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Classification updateClassification(Classification classification) throws NotAuthorizedException, ConcurrencyException, ClassificationNotFoundException, InvalidArgumentException {
        LOGGER.debug("entry to updateClassification(Classification = {})", (Object)classification);
        this.taskanaEngine.getEngine().checkRoleMembership(TaskanaRole.BUSINESS_ADMIN, TaskanaRole.ADMIN);
        ClassificationImpl classificationImpl = null;
        try {
            this.taskanaEngine.openConnection();
            if (classification.getKey().equals(classification.getParentKey())) {
                throw new InvalidArgumentException("The classification " + classification.getName() + " has the same key and parentKey");
            }
            classificationImpl = (ClassificationImpl)classification;
            Classification oldClassification = this.getExistingClassificationAndVerifyTimestampHasNotChanged(classificationImpl);
            classificationImpl.setModified(Instant.now());
            this.initDefaultClassificationValues(classificationImpl);
            if (!Objects.equals(oldClassification.getCategory(), classificationImpl.getCategory())) {
                this.updateCategoryOnAssociatedTasks(classificationImpl, oldClassification);
            }
            this.checkExistenceOfParentClassification(oldClassification, classificationImpl);
            this.classificationMapper.update(classificationImpl);
            this.createJobIfPriorityOrServiceLevelHasChanged(oldClassification, classificationImpl);
            LOGGER.debug("Method updateClassification() updated the classification {}.", (Object)classificationImpl);
            Classification classification2 = classification;
            return classification2;
        }
        finally {
            this.taskanaEngine.returnConnection();
            LOGGER.debug("exit from updateClassification().");
        }
    }

    @Override
    public ClassificationQuery createClassificationQuery() {
        return new ClassificationQueryImpl(this.taskanaEngine);
    }

    @Override
    public Classification newClassification(String key, String domain, String type) {
        ClassificationImpl classification = new ClassificationImpl();
        classification.setKey(key);
        classification.setDomain(domain);
        classification.setType(type);
        return classification;
    }

    private static void validateServiceLevel(String serviceLevel) throws InvalidArgumentException {
        try {
            Duration.parse(serviceLevel);
        }
        catch (Exception e) {
            throw new InvalidArgumentException(String.format("Invalid service level %s. The formats accepted are based on the ISO-8601 duration format PnDTnHnMn.nS with days considered to be exactly 24 hours. For example: \"P2D\" represents a period of \"two days.\" ", serviceLevel), e.getCause());
        }
        String serviceLevelLower = serviceLevel.toLowerCase();
        if ('p' != serviceLevelLower.charAt(0) || 'd' != serviceLevelLower.charAt(serviceLevel.length() - 1)) {
            throw new InvalidArgumentException(String.format("Invalid service level %s. Taskana only supports service levels that contain a number of whole days specified according to the format ''PnD'' where n is the number of days", serviceLevel));
        }
    }

    private void validateAndPopulateParentInformation(ClassificationImpl classificationImpl) throws InvalidArgumentException {
        try {
            Classification parentClassification;
            if (classificationImpl.getParentId() != null && !classificationImpl.getParentId().isEmpty()) {
                parentClassification = this.getClassification(classificationImpl.getParentId());
                if (classificationImpl.getParentKey() != null && !classificationImpl.getParentKey().isEmpty()) {
                    if (!classificationImpl.getParentKey().equals(parentClassification.getKey())) {
                        throw new InvalidArgumentException("Given parent key of classification does not match key of parent id.");
                    }
                    classificationImpl.setParentKey(parentClassification.getKey());
                }
            }
            if (classificationImpl.getParentKey() != null && !classificationImpl.getParentKey().isEmpty()) {
                parentClassification = this.getClassification(classificationImpl.getParentKey(), classificationImpl.getDomain());
                classificationImpl.setParentId(parentClassification.getId());
            }
        }
        catch (ClassificationNotFoundException e) {
            throw new InvalidArgumentException("Parent classification could not be found.", e);
        }
    }

    private void checkClassificationId(ClassificationImpl classificationImpl) throws InvalidArgumentException {
        if (classificationImpl.getId() != null && !"".equals(classificationImpl.getId())) {
            throw new InvalidArgumentException("ClassificationId should be null on creation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClassificationToMasterDomain(ClassificationImpl classificationImpl) {
        if (!Objects.equals(classificationImpl.getDomain(), "")) {
            boolean doesExist = true;
            ClassificationImpl masterClassification = new ClassificationImpl(classificationImpl);
            masterClassification.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
            masterClassification.setParentKey(classificationImpl.getParentKey());
            masterClassification.setDomain("");
            masterClassification.setIsValidInDomain(false);
            try {
                if (classificationImpl.getParentKey() != null && !"".equals(classificationImpl.getParentKey())) {
                    masterClassification.setParentId(this.getClassification(classificationImpl.getParentKey(), "").getId());
                }
                this.getClassification(masterClassification.getKey(), masterClassification.getDomain());
                throw new ClassificationAlreadyExistException(masterClassification);
            }
            catch (ClassificationNotFoundException e) {
                doesExist = false;
                LOGGER.debug("Method createClassification: Classification does not exist in master domain. Classification {}.", (Object)masterClassification);
                if (!doesExist) {
                    this.classificationMapper.insert(masterClassification);
                    LOGGER.debug("Method createClassification: Classification created in master-domain, too. Classification {}.", (Object)masterClassification);
                }
            }
            catch (ClassificationAlreadyExistException ex) {
                try {
                    LOGGER.warn("Method createClassification: Classification does already exist in master domain. Classification {}.", (Object)masterClassification);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (!doesExist) {
                        this.classificationMapper.insert(masterClassification);
                        LOGGER.debug("Method createClassification: Classification created in master-domain, too. Classification {}.", (Object)masterClassification);
                    }
                }
            }
        }
    }

    private void initDefaultClassificationValues(ClassificationImpl classification) throws InvalidArgumentException {
        Instant now = Instant.now();
        if (classification.getId() == null || "".equals(classification.getId())) {
            classification.setId(IdGenerator.generateWithPrefix(ID_PREFIX_CLASSIFICATION));
        }
        if (classification.getCreated() == null) {
            classification.setCreated(now);
        }
        if (classification.getModified() == null) {
            classification.setModified(now);
        }
        if (classification.getIsValidInDomain() == null) {
            classification.setIsValidInDomain(true);
        }
        if (classification.getServiceLevel() != null && !"".equals(classification.getServiceLevel())) {
            ClassificationServiceImpl.validateServiceLevel(classification.getServiceLevel());
        }
        if (classification.getKey() == null) {
            throw new InvalidArgumentException("Classification must contain a key");
        }
        if (classification.getParentId() == null) {
            classification.setParentId("");
        }
        if (classification.getParentKey() == null) {
            classification.setParentKey("");
        }
        if (classification.getType() != null && !this.taskanaEngine.getEngine().getConfiguration().getClassificationTypes().contains(classification.getType())) {
            throw new InvalidArgumentException("Given classification type " + classification.getType() + " is not valid according to the configuration.");
        }
        if (classification.getCategory() != null && !this.taskanaEngine.getEngine().getConfiguration().getClassificationCategoriesByType(classification.getType()).contains(classification.getCategory())) {
            throw new InvalidArgumentException("Given classification category " + classification.getCategory() + " with type " + classification.getType() + " is not valid according to the configuration.");
        }
        if (classification.getDomain().isEmpty()) {
            classification.setIsValidInDomain(false);
        }
    }

    private boolean doesClassificationExist(String key, String domain) {
        boolean isExisting = false;
        try {
            if (this.classificationMapper.findByKeyAndDomain(key, domain) != null) {
                isExisting = true;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Classification-Service threw Exception while calling mapper and searching for classification. EX={}", (Object)ex, (Object)ex);
        }
        return isExisting;
    }

    private boolean isReferentialIntegrityConstraintViolation(PersistenceException e) {
        return this.isH2OrPostgresIntegrityConstraintViolation(e) || this.isDb2IntegrityConstraintViolation(e);
    }

    private boolean isDb2IntegrityConstraintViolation(PersistenceException e) {
        return e.getCause() instanceof SQLIntegrityConstraintViolationException && e.getMessage().contains("-532");
    }

    private boolean isH2OrPostgresIntegrityConstraintViolation(PersistenceException e) {
        return e.getCause() instanceof SQLException && ((SQLException)e.getCause()).getSQLState().equals("23503");
    }

    private Classification getExistingClassificationAndVerifyTimestampHasNotChanged(ClassificationImpl classificationImpl) throws ConcurrencyException, ClassificationNotFoundException {
        Classification oldClassification = this.getClassification(classificationImpl.getKey(), classificationImpl.getDomain());
        if (!oldClassification.getModified().equals(classificationImpl.getModified())) {
            throw new ConcurrencyException("The current Classification has been modified while editing. The values can not be updated. Classification " + classificationImpl.toString());
        }
        return oldClassification;
    }

    private void updateCategoryOnAssociatedTasks(ClassificationImpl classificationImpl, Classification oldClassification) {
        List<TaskSummary> taskSummaries = this.taskanaEngine.getEngine().getTaskService().createTaskQuery().classificationIdIn(oldClassification.getId()).list();
        if (!taskSummaries.isEmpty()) {
            ArrayList<String> taskIds = new ArrayList<String>();
            taskSummaries.forEach(ts -> taskIds.add(ts.getId()));
            this.taskMapper.updateClassificationCategoryOnChange(taskIds, classificationImpl.getCategory());
        }
    }

    private void checkExistenceOfParentClassification(Classification oldClassification, ClassificationImpl classificationImpl) throws ClassificationNotFoundException {
        if (!oldClassification.getParentId().equals(classificationImpl.getParentId()) && classificationImpl.getParentId() != null && !classificationImpl.getParentId().isEmpty()) {
            this.getClassification(classificationImpl.getParentId());
        }
        if (!oldClassification.getParentKey().equals(classificationImpl.getParentKey()) && classificationImpl.getParentKey() != null && !classificationImpl.getParentKey().isEmpty()) {
            this.getClassification(classificationImpl.getParentKey(), classificationImpl.getDomain());
        }
    }

    private void createJobIfPriorityOrServiceLevelHasChanged(Classification oldClassification, ClassificationImpl classificationImpl) {
        boolean serviceLevelChanged;
        boolean priorityChanged = oldClassification.getPriority() != classificationImpl.getPriority();
        boolean bl = serviceLevelChanged = !Objects.equals(oldClassification.getServiceLevel(), classificationImpl.getServiceLevel());
        if (priorityChanged || serviceLevelChanged) {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("classificationId", classificationImpl.getId());
            args.put("priorityChanged", String.valueOf(priorityChanged));
            args.put("serviceLevelChanged", String.valueOf(serviceLevelChanged));
            ScheduledJob job = new ScheduledJob();
            job.setArguments(args);
            job.setType(ScheduledJob.Type.CLASSIFICATIONCHANGEDJOB);
            this.taskanaEngine.getEngine().getJobService().createJob(job);
        }
    }
}

