/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.api.LoggerUtils;

public class BulkOperationResults<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkOperationResults.class);
    private Map<K, V> errorMap = new HashMap();

    public Map<K, V> getErrorMap() {
        return this.errorMap;
    }

    public boolean addError(K objectId, V error) {
        boolean status = false;
        try {
            if (objectId != null) {
                this.errorMap.put(objectId, error);
                status = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Can\u00b4t add bulkoperation-error, because of a map failure. ID={}, error={} and current failure={}", new Object[]{objectId, error, e});
        }
        return status;
    }

    public boolean containsErrors() {
        boolean isContainingErrors = false;
        if (!this.errorMap.isEmpty()) {
            isContainingErrors = true;
        }
        return isContainingErrors;
    }

    public V getErrorForId(K idKey) {
        V result = null;
        if (idKey != null) {
            result = this.errorMap.get(idKey);
        }
        return result;
    }

    public List<K> getFailedIds() {
        return new ArrayList<K>(this.errorMap.keySet());
    }

    public void clearErrors() {
        this.errorMap.clear();
    }

    public void addAllErrors(BulkOperationResults<K, V> log) {
        if (log != null && log.containsErrors()) {
            List<K> failedIds = log.getFailedIds();
            for (K id : failedIds) {
                this.addError(id, log.getErrorForId(id));
            }
        }
    }

    public BulkOperationResults<K, Exception> mapBulkOperationResults() {
        BulkOperationResults<K, Exception> bulkLogMapped = new BulkOperationResults<K, Exception>();
        List<K> failedIds = this.getFailedIds();
        for (K id : failedIds) {
            bulkLogMapped.addError(id, (Exception)this.getErrorForId(id));
        }
        return bulkLogMapped;
    }

    public String toString() {
        return "BulkOperationResults [BulkOperationResults= " + LoggerUtils.mapToString(this.errorMap) + "]";
    }
}

