/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.jdbc.RuntimeSqlException;
import org.apache.ibatis.jdbc.ScriptRunner;
import org.apache.ibatis.jdbc.SqlRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.taskana.common.internal.configuration.DB;

public class DbSchemaCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbSchemaCreator.class);
    private static final String SQL = "/sql";
    private static final String DB_SCHEMA = "/sql/taskana-schema.sql";
    private static final String DB_SCHEMA_DB2 = "/sql/taskana-schema-db2.sql";
    private static final String DB_SCHEMA_POSTGRES = "/sql/taskana-schema-postgres.sql";
    private static final String DB_SCHEMA_DETECTION = "/sql/schema-detection.sql";
    private static final String DB_SCHEMA_DETECTION_POSTGRES = "/sql/schema-detection-postgres.sql";
    private DataSource dataSource;
    private String schemaName;
    private StringWriter outWriter = new StringWriter();
    private PrintWriter logWriter = new PrintWriter(this.outWriter);
    private StringWriter errorWriter = new StringWriter();
    private PrintWriter errorLogWriter = new PrintWriter(this.errorWriter);

    public DbSchemaCreator(DataSource dataSource, String schema) {
        this.dataSource = dataSource;
        this.schemaName = schema;
    }

    public void run() throws SQLException {
        try (Connection connection = this.dataSource.getConnection();){
            LOGGER.debug("Using database of type {} with url '{}'", (Object)connection.getMetaData().getDatabaseProductName(), (Object)connection.getMetaData().getURL());
            ScriptRunner runner = this.getScriptRunnerInstance(connection);
            if (!this.isSchemaPreexisting(connection)) {
                String scriptPath = DbSchemaCreator.selectDbScriptFileName(connection.getMetaData().getDatabaseProductName());
                InputStream resourceAsStream = DbSchemaCreator.class.getResourceAsStream(scriptPath);
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
                runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
            }
        }
        LOGGER.debug(this.outWriter.toString());
        if (!this.errorWriter.toString().trim().isEmpty()) {
            LOGGER.error(this.errorWriter.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValidSchemaVersion(String expectedVersion) {
        SqlRunner runner = null;
        try (Connection connection = this.dataSource.getConnection();){
            connection.setSchema(this.schemaName);
            runner = new SqlRunner(connection);
            LOGGER.debug(connection.getMetaData().toString());
            String query = "select VERSION from TASKANA_SCHEMA_VERSION where VERSION = (select max(VERSION) from TASKANA_SCHEMA_VERSION) AND VERSION = ?";
            Map queryResult = runner.selectOne(query, new Object[]{expectedVersion});
            if (queryResult == null || queryResult.isEmpty()) {
                LOGGER.error("Schema version not valid. The VERSION property in table TASKANA_SCHEMA_VERSION has not the expected value {}", (Object)expectedVersion);
                boolean bl2 = false;
                return bl2;
            }
            LOGGER.debug("Schema version is valid.");
            boolean bl = true;
            return bl;
        }
        catch (SQLException | RuntimeSqlException e) {
            LOGGER.error("Schema version not valid. The VERSION property in table TASKANA_SCHEMA_VERSION has not the expected value {}", (Object)expectedVersion);
            return false;
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private static String selectDbScriptFileName(String dbProductName) {
        return DB.isPostgreSql(dbProductName) ? DB_SCHEMA_POSTGRES : (DB.isH2(dbProductName) ? DB_SCHEMA : DB_SCHEMA_DB2);
    }

    private static String selectDbSchemaDetectionScript(String dbProductName) {
        return DB.isPostgreSql(dbProductName) ? DB_SCHEMA_DETECTION_POSTGRES : DB_SCHEMA_DETECTION;
    }

    private ScriptRunner getScriptRunnerInstance(Connection connection) {
        ScriptRunner runner = new ScriptRunner(connection);
        runner.setStopOnError(true);
        runner.setLogWriter(this.logWriter);
        runner.setErrorLogWriter(this.errorLogWriter);
        return runner;
    }

    private boolean isSchemaPreexisting(Connection connection) {
        ScriptRunner runner = this.getScriptRunnerInstance(connection);
        StringWriter errorWriter = new StringWriter();
        runner.setErrorLogWriter(new PrintWriter(errorWriter));
        try {
            String scriptPath = DbSchemaCreator.selectDbSchemaDetectionScript(connection.getMetaData().getDatabaseProductName());
            InputStream resourceAsStream = DbSchemaCreator.class.getResourceAsStream(scriptPath);
            BufferedReader reader = new BufferedReader(new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
            runner.runScript((Reader)this.getSqlSchemaNameParsed(reader));
        }
        catch (SQLException | RuntimeSqlException e) {
            LOGGER.debug("Schema does not exist.");
            if (!errorWriter.toString().trim().isEmpty()) {
                LOGGER.debug(errorWriter.toString());
            }
            return false;
        }
        LOGGER.debug("Schema does exist.");
        return true;
    }

    private StringReader getSqlSchemaNameParsed(BufferedReader reader) {
        StringBuffer content = new StringBuffer();
        try {
            String line = "";
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                content.append(line.replaceAll("%schemaName%", this.schemaName) + System.lineSeparator());
            }
        }
        catch (IOException e) {
            LOGGER.error("SchemaName sql parsing failed for schemaName {}", (Object)this.schemaName, (Object)e);
        }
        return new StringReader(content.toString());
    }
}

