/*
 * Decompiled with CFR 0.152.
 */
package pro.taskana.common.internal.persistence;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapTypeHandler
extends BaseTypeHandler<Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapTypeHandler.class);

    public void setNonNullParameter(PreparedStatement ps, int i, Map<String, Object> parameter, JdbcType jdbcType) throws SQLException {
        if (parameter != null && parameter.size() > 0) {
            LOGGER.debug("Input-Map before serializing: {}", parameter);
            JSONObject jsonObj = new JSONObject(parameter);
            ps.setString(i, jsonObj.toString());
        } else {
            ps.setNull(i, 2004);
        }
    }

    public Map<String, Object> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String fieldValue = rs.getString(columnName);
        if (fieldValue != null) {
            return this.convertToMap(fieldValue);
        }
        return null;
    }

    public Map<String, Object> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String fieldValue = rs.getString(columnIndex);
        if (fieldValue != null) {
            return this.convertToMap(fieldValue);
        }
        return null;
    }

    public Map<String, Object> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String fieldValue = cs.getString(columnIndex);
        if (fieldValue != null) {
            return this.convertToMap(fieldValue);
        }
        return null;
    }

    private Map<String, Object> convertToMap(String fieldValue) {
        JSONObject jsonObj = new JSONObject(fieldValue);
        return jsonObj.toMap();
    }
}

